/*
 * Decompiled with CFR 0.152.
 */
package com.tiger.useragent.enums;

import org.apache.commons.lang3.StringUtils;

public enum DeviceType {
    Other(0, "-"),
    Phone(1, "phone"),
    Pad(2, "pad"),
    TV(3, "tv"),
    PC(4, "pc"),
    Spider(5, "spider");

    private final int value;
    private final String name;

    private DeviceType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public static DeviceType parseOf(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Other;
        }
        for (DeviceType item : DeviceType.values()) {
            if (!name.equalsIgnoreCase(item.name)) continue;
            return item;
        }
        return Other;
    }

    public static DeviceType parseOf(int value) {
        for (DeviceType item : DeviceType.values()) {
            if (value != item.getValue()) continue;
            return item;
        }
        return Other;
    }

    public int getValue() {
        return this.value;
    }
}

