/*
 * Decompiled with CFR 0.152.
 */
package com.tiger.useragent.enums;

import org.apache.commons.lang3.StringUtils;

public enum NetType {
    Other(0, "-"),
    Wifi(1, "wifi"),
    _2G(2, "2g"),
    _3G(3, "3g"),
    _4G(4, "4g"),
    _5G(5, "5g");

    private final int value;
    private final String name;

    private NetType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public static NetType parseOf(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Other;
        }
        for (NetType item : NetType.values()) {
            if (!name.equalsIgnoreCase(item.name)) continue;
            return item;
        }
        return Other;
    }

    public static NetType parseOf(int value) {
        for (NetType item : NetType.values()) {
            if (value != item.getValue()) continue;
            return item;
        }
        return Other;
    }

    public int getValue() {
        return this.value;
    }
}

