/*
 * Decompiled with CFR 0.152.
 */
package com.tiger.useragent.os;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.tiger.useragent.os.Os;
import com.tiger.useragent.os.OsPattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OsParser {
    private final List<OsPattern> patterns;

    public OsParser(List<OsPattern> patterns) {
        this.patterns = patterns;
    }

    public static OsParser fromList(List<Map<String, String>> configList) {
        ArrayList configPatterns = Lists.newArrayList();
        for (Map<String, String> configMap : configList) {
            configPatterns.add(OsPattern.patternFromMap(configMap));
        }
        return new OsParser(configPatterns);
    }

    public Os parse(String agentString) {
        if (Strings.isNullOrEmpty((String)agentString)) {
            return Os.DEFAULT_OS;
        }
        for (OsPattern p : this.patterns) {
            Os os = p.match(agentString);
            if (os == null) continue;
            return os;
        }
        return Os.DEFAULT_OS;
    }
}

