/*
 * Decompiled with CFR 0.152.
 */
package com.tokenview.api.client;

import com.alibaba.fastjson.JSON;
import com.tokenview.api.client.APICredentials;
import com.tokenview.api.client.APIHttpClient;
import com.tokenview.api.client.APIRetrofit;
import com.tokenview.api.client.ApiHttp;
import com.tokenview.api.config.APIConfiguration;
import com.tokenview.api.constant.APIConstants;
import com.tokenview.api.exception.APIException;
import com.tokenview.api.result.HttpResult;
import java.io.IOException;
import okhttp3.OkHttpClient;
import org.apache.commons.lang.StringUtils;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public class APIClient {
    private final APIConfiguration config;
    private final APICredentials credentials;
    private final OkHttpClient client;
    private final Retrofit retrofit;
    private final ApiHttp apiHttp;

    public APIClient(APIConfiguration config) {
        if (config == null || StringUtils.isEmpty((String)config.getEndpoint())) {
            throw new RuntimeException("The APIClient params can't be empty.");
        }
        this.config = config;
        this.credentials = new APICredentials(config);
        this.client = new APIHttpClient(config, this.credentials).client();
        this.retrofit = new APIRetrofit(config, this.client).retrofit();
        this.apiHttp = new ApiHttp(config, this.client);
    }

    public <T> T createService(Class<T> service) {
        return (T)this.retrofit.create(service);
    }

    public ApiHttp getApiHttp() {
        return this.apiHttp;
    }

    public <T> T executeSync(Call<T> call) {
        try {
            Response response = call.execute();
            int status = response.code();
            String message = response.code() + " / " + response.message();
            if (response.isSuccessful()) {
                return (T)response.body();
            }
            if (APIConstants.resultStatusArray.contains(status)) {
                HttpResult result = (HttpResult)JSON.parseObject((String)new String(response.errorBody().bytes()), HttpResult.class);
                if (result.getCode() == 0 && result.getMessage() == null) {
                    throw new APIException(result.getErrorCode(), result.getErrorMessage());
                }
                throw new APIException(result.getCode(), result.getMessage());
            }
            throw new APIException(message);
        }
        catch (IOException e) {
            throw new APIException("APIClient executeSync exception.", e);
        }
    }
}

