/*
 * Decompiled with CFR 0.152.
 */
package com.tokenview.api.client;

import com.tokenview.api.client.APICredentials;
import com.tokenview.api.config.APIConfiguration;
import com.tokenview.api.constant.APIConstants;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;

public class APIHttpClient {
    private final APIConfiguration config;
    private final APICredentials credentials;

    public APIHttpClient(APIConfiguration config, APICredentials credentials) {
        this.config = config;
        this.credentials = credentials;
    }

    public OkHttpClient client() {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        clientBuilder.connectTimeout(this.config.getConnectTimeout(), TimeUnit.SECONDS);
        clientBuilder.readTimeout(this.config.getReadTimeout(), TimeUnit.SECONDS);
        clientBuilder.writeTimeout(this.config.getWriteTimeout(), TimeUnit.SECONDS);
        clientBuilder.retryOnConnectionFailure(this.config.isRetryOnConnectionFailure());
        return clientBuilder.build();
    }

    private String url(Request request) {
        return request.url().toString();
    }

    private String method(Request request) {
        return request.method().toUpperCase();
    }

    private String requestPath(Request request) {
        String url = this.url(request);
        String requestPath = url = url.replace(this.config.getEndpoint(), "");
        if (requestPath.contains("?")) {
            requestPath = requestPath.substring(0, url.lastIndexOf("?"));
        }
        if (this.config.getEndpoint().endsWith("/")) {
            requestPath = "/" + requestPath;
        }
        return requestPath;
    }

    private String queryString(Request request) {
        String url = this.url(request);
        request.body();
        String queryString = "";
        if (url.contains("?")) {
            queryString = url.substring(url.lastIndexOf("?") + 1);
        }
        return queryString;
    }

    private String body(Request request) throws IOException {
        RequestBody requestBody = request.body();
        String body = "";
        if (requestBody != null) {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            body = buffer.readString(APIConstants.UTF_8);
        }
        return body;
    }
}

