/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.theokanning.openai.DeleteResult;
import com.theokanning.openai.ListSearchParameters;
import com.theokanning.openai.OpenAiError;
import com.theokanning.openai.OpenAiHttpException;
import com.theokanning.openai.OpenAiResponse;
import com.theokanning.openai.assistants.assistant.Assistant;
import com.theokanning.openai.assistants.assistant.AssistantRequest;
import com.theokanning.openai.assistants.assistant.ModifyAssistantRequest;
import com.theokanning.openai.assistants.assistant.VectorStoreFileRequest;
import com.theokanning.openai.assistants.message.Message;
import com.theokanning.openai.assistants.message.MessageListSearchParameters;
import com.theokanning.openai.assistants.message.MessageRequest;
import com.theokanning.openai.assistants.message.ModifyMessageRequest;
import com.theokanning.openai.assistants.run.CreateThreadAndRunRequest;
import com.theokanning.openai.assistants.run.ModifyRunRequest;
import com.theokanning.openai.assistants.run.Run;
import com.theokanning.openai.assistants.run.RunCreateRequest;
import com.theokanning.openai.assistants.run.SubmitToolOutputsRequest;
import com.theokanning.openai.assistants.run_step.RunStep;
import com.theokanning.openai.assistants.thread.Thread;
import com.theokanning.openai.assistants.thread.ThreadRequest;
import com.theokanning.openai.assistants.vector_store.ModifyVectorStoreRequest;
import com.theokanning.openai.assistants.vector_store.VectorStore;
import com.theokanning.openai.assistants.vector_store.VectorStoreRequest;
import com.theokanning.openai.assistants.vector_store_file.VectorStoreFile;
import com.theokanning.openai.assistants.vector_store_file_batch.VectorStoreFilesBatch;
import com.theokanning.openai.assistants.vector_store_file_batch.VectorStoreFilesBatchRequest;
import com.theokanning.openai.audio.CreateSpeechRequest;
import com.theokanning.openai.audio.CreateTranscriptionRequest;
import com.theokanning.openai.audio.CreateTranslationRequest;
import com.theokanning.openai.audio.TranscriptionResult;
import com.theokanning.openai.audio.TranslationResult;
import com.theokanning.openai.batch.Batch;
import com.theokanning.openai.batch.BatchRequest;
import com.theokanning.openai.billing.BillingUsage;
import com.theokanning.openai.billing.Subscription;
import com.theokanning.openai.client.AuthenticationInterceptor;
import com.theokanning.openai.client.OpenAiApi;
import com.theokanning.openai.completion.CompletionChunk;
import com.theokanning.openai.completion.CompletionRequest;
import com.theokanning.openai.completion.CompletionResult;
import com.theokanning.openai.completion.chat.AssistantMessage;
import com.theokanning.openai.completion.chat.ChatCompletionChoice;
import com.theokanning.openai.completion.chat.ChatCompletionChunk;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatCompletionResult;
import com.theokanning.openai.completion.chat.ChatFunction;
import com.theokanning.openai.completion.chat.ChatFunctionCall;
import com.theokanning.openai.completion.chat.ChatToolCall;
import com.theokanning.openai.embedding.EmbeddingRequest;
import com.theokanning.openai.embedding.EmbeddingResult;
import com.theokanning.openai.file.File;
import com.theokanning.openai.fine_tuning.FineTuningEvent;
import com.theokanning.openai.fine_tuning.FineTuningJob;
import com.theokanning.openai.fine_tuning.FineTuningJobCheckpoint;
import com.theokanning.openai.fine_tuning.FineTuningJobRequest;
import com.theokanning.openai.image.CreateImageEditRequest;
import com.theokanning.openai.image.CreateImageRequest;
import com.theokanning.openai.image.CreateImageVariationRequest;
import com.theokanning.openai.image.ImageResult;
import com.theokanning.openai.model.Model;
import com.theokanning.openai.moderation.ModerationRequest;
import com.theokanning.openai.moderation.ModerationResult;
import com.theokanning.openai.service.ChatFunctionMixIn;
import com.theokanning.openai.service.ChatMessageAccumulator;
import com.theokanning.openai.service.ChatMessageAccumulatorWrapper;
import com.theokanning.openai.service.FileUtil;
import com.theokanning.openai.service.ResponseBodyCallback;
import com.theokanning.openai.service.SSE;
import com.theokanning.openai.service.assistant_stream.AssistantResponseBodyCallback;
import com.theokanning.openai.service.assistant_stream.AssistantSSE;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Single;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.validation.constraints.NotNull;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class OpenAiService {
    private static final String DEFAULT_BASE_URL = "https://api.openai.com/v1/";
    public static final String API_BASE_URL_ENV = "OPENAI_API_BASE_URL";
    public static final String API_KEY_ENV = "OPENAI_API_KEY";
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(10L);
    private static final ObjectMapper mapper = OpenAiService.defaultObjectMapper();
    private final OpenAiApi api;
    private final ExecutorService executorService;

    public OpenAiService() {
        this(System.getenv(API_KEY_ENV));
    }

    public OpenAiService(Duration timeout) {
        this(System.getenv(API_KEY_ENV), timeout);
    }

    public OpenAiService(String token) {
        this(token, DEFAULT_TIMEOUT, System.getenv(API_BASE_URL_ENV) != null ? System.getenv(API_BASE_URL_ENV) : DEFAULT_BASE_URL);
    }

    public OpenAiService(String token, String baseUrl) {
        this(token, DEFAULT_TIMEOUT, baseUrl);
    }

    public OpenAiService(String token, Duration timeout) {
        this(token, timeout, System.getenv(API_BASE_URL_ENV) != null ? System.getenv(API_BASE_URL_ENV) : DEFAULT_BASE_URL);
    }

    public OpenAiService(String token, Duration timeout, String baseUrl) {
        ObjectMapper mapper = OpenAiService.defaultObjectMapper();
        OkHttpClient client = OpenAiService.defaultClient(token, timeout);
        Retrofit retrofit = OpenAiService.defaultRetrofit(client, mapper, baseUrl);
        this.api = (OpenAiApi)retrofit.create(OpenAiApi.class);
        this.executorService = client.dispatcher().executorService();
    }

    public OpenAiService(OpenAiApi api) {
        this.api = api;
        this.executorService = null;
    }

    public OpenAiService(OpenAiApi api, ExecutorService executorService) {
        this.api = api;
        this.executorService = executorService;
    }

    public List<Model> listModels() {
        return ((OpenAiResponse)OpenAiService.execute(this.api.listModels())).data;
    }

    public Model getModel(String modelId) {
        return (Model)OpenAiService.execute(this.api.getModel(modelId));
    }

    public static OpenAiApi buildApi(String token, Duration timeout) {
        return OpenAiService.buildApi(token, timeout, System.getenv(API_BASE_URL_ENV) != null ? System.getenv(API_BASE_URL_ENV) : DEFAULT_BASE_URL);
    }

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.addMixIn(ChatFunction.class, ChatFunctionMixIn.class);
        return mapper;
    }

    public ChatCompletionResult createChatCompletion(ChatCompletionRequest request) {
        return (ChatCompletionResult)OpenAiService.execute(this.api.createChatCompletion(request));
    }

    public Flowable<ChatCompletionChunk> streamChatCompletion(ChatCompletionRequest request) {
        request.setStream(Boolean.valueOf(true));
        return OpenAiService.stream((Call<ResponseBody>)this.api.createChatCompletionStream(request), ChatCompletionChunk.class, new BiConsumer<ChatCompletionChunk, SSE>(){

            @Override
            public void accept(ChatCompletionChunk chatCompletionChunk, SSE sse) {
                chatCompletionChunk.setSource(sse.getData());
            }
        }, new Supplier<ChatCompletionChunk>(){

            @Override
            public ChatCompletionChunk get() {
                return new ChatCompletionChunk();
            }
        });
    }

    public EmbeddingResult createEmbeddings(EmbeddingRequest request) {
        return (EmbeddingResult)OpenAiService.execute(this.api.createEmbeddings(request));
    }

    public List<File> listFiles() {
        return ((OpenAiResponse)OpenAiService.execute(this.api.listFiles())).data;
    }

    @Deprecated
    public CompletionResult createCompletion(CompletionRequest request) {
        return (CompletionResult)OpenAiService.execute(this.api.createCompletion(request));
    }

    public DeleteResult deleteFile(String fileId) {
        return (DeleteResult)OpenAiService.execute(this.api.deleteFile(fileId));
    }

    public File retrieveFile(String fileId) {
        return (File)OpenAiService.execute(this.api.retrieveFile(fileId));
    }

    public ResponseBody retrieveFileContent(String fileId) {
        return (ResponseBody)OpenAiService.execute(this.api.retrieveFileContent(fileId));
    }

    public FineTuningJob createFineTuningJob(FineTuningJobRequest request) {
        return (FineTuningJob)OpenAiService.execute(this.api.createFineTuningJob(request));
    }

    public List<FineTuningJob> listFineTuningJobs() {
        return ((OpenAiResponse)OpenAiService.execute(this.api.listFineTuningJobs())).data;
    }

    public FineTuningJob retrieveFineTuningJob(String fineTuningJobId) {
        return (FineTuningJob)OpenAiService.execute(this.api.retrieveFineTuningJob(fineTuningJobId));
    }

    public FineTuningJob cancelFineTuningJob(String fineTuningJobId) {
        return (FineTuningJob)OpenAiService.execute(this.api.cancelFineTuningJob(fineTuningJobId));
    }

    public List<FineTuningEvent> listFineTuningJobEvents(String fineTuningJobId) {
        return ((OpenAiResponse)OpenAiService.execute(this.api.listFineTuningJobEvents((String)fineTuningJobId))).data;
    }

    public List<FineTuningJobCheckpoint> listFineTuningCheckpoints(String fineTuningJobId) {
        return ((OpenAiResponse)OpenAiService.execute(this.api.listFineTuningCheckpoints((String)fineTuningJobId))).data;
    }

    @Deprecated
    public Flowable<CompletionChunk> streamCompletion(CompletionRequest request) {
        request.setStream(Boolean.valueOf(true));
        return OpenAiService.stream((Call<ResponseBody>)this.api.createCompletionStream(request), CompletionChunk.class);
    }

    public File uploadFile(String purpose, String filepath) {
        java.io.File file = new java.io.File(filepath);
        try {
            return this.uploadFile(purpose, new FileInputStream(file), file.getName());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public File uploadFile(String purpose, InputStream fileInputStream, String filename) {
        RequestBody purposeBody = RequestBody.create((MediaType)MultipartBody.FORM, (String)purpose);
        RequestBody fileBody = RequestBody.create((MediaType)FileUtil.getFileUploadMediaType(filename), (byte[])FileUtil.readAllBytes(fileInputStream));
        MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)filename, (RequestBody)fileBody);
        return (File)OpenAiService.execute(this.api.uploadFile(purposeBody, body));
    }

    public Batch createBatch(BatchRequest request) {
        return (Batch)OpenAiService.execute(this.api.createBatch(request));
    }

    public Batch retrieveBatch(String batchId) {
        return (Batch)OpenAiService.execute(this.api.retrieveBatch(batchId));
    }

    public static Flowable<AssistantSSE> assistantStream(Call<ResponseBody> apiCall) {
        return Flowable.create(emitter -> apiCall.enqueue((Callback)new AssistantResponseBodyCallback((FlowableEmitter<AssistantSSE>)emitter)), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    public ImageResult createImage(CreateImageRequest request) {
        return (ImageResult)OpenAiService.execute(this.api.createImage(request));
    }

    public ImageResult createImageEdit(CreateImageEditRequest request, String imagePath, String maskPath) {
        java.io.File image = new java.io.File(imagePath);
        java.io.File mask = null;
        if (maskPath != null) {
            mask = new java.io.File(maskPath);
        }
        return this.createImageEdit(request, image, mask);
    }

    public ImageResult createImageEdit(CreateImageEditRequest request, java.io.File image, java.io.File mask) {
        RequestBody imageBody = RequestBody.create((MediaType)MediaType.parse((String)"image"), (java.io.File)image);
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaType.get((String)"multipart/form-data")).addFormDataPart("prompt", request.getPrompt()).addFormDataPart("size", request.getSize()).addFormDataPart("response_format", request.getResponseFormat()).addFormDataPart("image", "image", imageBody);
        if (request.getN() != null) {
            builder.addFormDataPart("n", request.getN().toString());
        }
        if (mask != null) {
            RequestBody maskBody = RequestBody.create((MediaType)MediaType.parse((String)"image"), (java.io.File)mask);
            builder.addFormDataPart("mask", "mask", maskBody);
        }
        if (request.getModel() != null) {
            builder.addFormDataPart("model", request.getModel());
        }
        return (ImageResult)OpenAiService.execute(this.api.createImageEdit((RequestBody)builder.build()));
    }

    public ImageResult createImageVariation(CreateImageVariationRequest request, String imagePath) {
        java.io.File image = new java.io.File(imagePath);
        return this.createImageVariation(request, image);
    }

    public ImageResult createImageVariation(CreateImageVariationRequest request, java.io.File image) {
        RequestBody imageBody = RequestBody.create((MediaType)MediaType.parse((String)"image"), (java.io.File)image);
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaType.get((String)"multipart/form-data")).addFormDataPart("size", request.getSize()).addFormDataPart("response_format", request.getResponseFormat()).addFormDataPart("image", "image", imageBody);
        if (request.getN() != null) {
            builder.addFormDataPart("n", request.getN().toString());
        }
        if (request.getModel() != null) {
            builder.addFormDataPart("model", request.getModel());
        }
        return (ImageResult)OpenAiService.execute(this.api.createImageVariation((RequestBody)builder.build()));
    }

    public TranscriptionResult createTranscription(CreateTranscriptionRequest request, String audioPath) {
        java.io.File audio = new java.io.File(audioPath);
        return this.createTranscription(request, audio);
    }

    public TranscriptionResult createTranscription(CreateTranscriptionRequest request, java.io.File audio) {
        RequestBody audioBody = RequestBody.create((MediaType)MediaType.parse((String)"audio"), (java.io.File)audio);
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaType.get((String)"multipart/form-data")).addFormDataPart("model", request.getModel()).addFormDataPart("file", audio.getName(), audioBody);
        if (request.getPrompt() != null) {
            builder.addFormDataPart("prompt", request.getPrompt());
        }
        if (request.getResponseFormat() != null) {
            builder.addFormDataPart("response_format", request.getResponseFormat());
        }
        if (request.getTemperature() != null) {
            builder.addFormDataPart("temperature", request.getTemperature().toString());
        }
        if (request.getLanguage() != null) {
            builder.addFormDataPart("language", request.getLanguage());
        }
        if (request.getTimestampGranularities() != null && !request.getTimestampGranularities().isEmpty()) {
            for (String granularity : request.getTimestampGranularities()) {
                builder.addFormDataPart("timestamp_granularities[]", granularity);
            }
        }
        return (TranscriptionResult)OpenAiService.execute(this.api.createTranscription((RequestBody)builder.build()));
    }

    public TranslationResult createTranslation(CreateTranslationRequest request, String audioPath) {
        java.io.File audio = new java.io.File(audioPath);
        return this.createTranslation(request, audio);
    }

    public TranslationResult createTranslation(CreateTranslationRequest request, java.io.File audio) {
        RequestBody audioBody = RequestBody.create((MediaType)MediaType.parse((String)"audio"), (java.io.File)audio);
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaType.get((String)"multipart/form-data")).addFormDataPart("model", request.getModel()).addFormDataPart("file", audio.getName(), audioBody);
        if (request.getPrompt() != null) {
            builder.addFormDataPart("prompt", request.getPrompt());
        }
        if (request.getResponseFormat() != null) {
            builder.addFormDataPart("response_format", request.getResponseFormat());
        }
        if (request.getTemperature() != null) {
            builder.addFormDataPart("temperature", request.getTemperature().toString());
        }
        return (TranslationResult)OpenAiService.execute(this.api.createTranslation((RequestBody)builder.build()));
    }

    public ModerationResult createModeration(ModerationRequest request) {
        return (ModerationResult)OpenAiService.execute(this.api.createModeration(request));
    }

    public ResponseBody createSpeech(CreateSpeechRequest request) {
        return (ResponseBody)OpenAiService.execute(this.api.createSpeech(request));
    }

    public Assistant createAssistant(AssistantRequest request) {
        return (Assistant)OpenAiService.execute(this.api.createAssistant(request));
    }

    public Assistant retrieveAssistant(String assistantId) {
        return (Assistant)OpenAiService.execute(this.api.retrieveAssistant(assistantId));
    }

    public Assistant modifyAssistant(String assistantId, ModifyAssistantRequest request) {
        return (Assistant)OpenAiService.execute(this.api.modifyAssistant(assistantId, request));
    }

    public DeleteResult deleteAssistant(String assistantId) {
        return (DeleteResult)OpenAiService.execute(this.api.deleteAssistant(assistantId));
    }

    public OpenAiResponse<Assistant> listAssistants(ListSearchParameters params) {
        Map queryParameters = (Map)mapper.convertValue((Object)params, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return (OpenAiResponse)OpenAiService.execute(this.api.listAssistants(queryParameters));
    }

    public Thread createThread(ThreadRequest request) {
        return (Thread)OpenAiService.execute(this.api.createThread(request));
    }

    public Thread retrieveThread(String threadId) {
        return (Thread)OpenAiService.execute(this.api.retrieveThread(threadId));
    }

    public Thread modifyThread(String threadId, ThreadRequest request) {
        return (Thread)OpenAiService.execute(this.api.modifyThread(threadId, request));
    }

    public DeleteResult deleteThread(String threadId) {
        return (DeleteResult)OpenAiService.execute(this.api.deleteThread(threadId));
    }

    public Message createMessage(String threadId, MessageRequest request) {
        return (Message)OpenAiService.execute(this.api.createMessage(threadId, request));
    }

    public Message retrieveMessage(String threadId, String messageId) {
        return (Message)OpenAiService.execute(this.api.retrieveMessage(threadId, messageId));
    }

    public Message modifyMessage(String threadId, String messageId, ModifyMessageRequest request) {
        return (Message)OpenAiService.execute(this.api.modifyMessage(threadId, messageId, request));
    }

    public OpenAiResponse<Message> listMessages(String threadId, MessageListSearchParameters params) {
        Map queryParameters = (Map)mapper.convertValue((Object)params, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return (OpenAiResponse)OpenAiService.execute(this.api.listMessages(threadId, queryParameters));
    }

    public DeleteResult deleteMessage(String threadId, String messageId) {
        return (DeleteResult)OpenAiService.execute(this.api.deleteMessage(threadId, messageId));
    }

    public Run createRun(String threadId, RunCreateRequest runCreateRequest) {
        return (Run)OpenAiService.execute(this.api.createRun(threadId, runCreateRequest));
    }

    public OpenAiResponse<Batch> listBatches(ListSearchParameters params) {
        Map queryParameters = (Map)mapper.convertValue((Object)params, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return (OpenAiResponse)OpenAiService.execute(this.api.listBatches(queryParameters));
    }

    public Run retrieveRun(String threadId, String runId) {
        return (Run)OpenAiService.execute(this.api.retrieveRun(threadId, runId));
    }

    public Run modifyRun(String threadId, String runId, ModifyRunRequest request) {
        return (Run)OpenAiService.execute(this.api.modifyRun(threadId, runId, request));
    }

    public OpenAiResponse<Run> listRuns(String threadId, ListSearchParameters listSearchParameters) {
        Map search = new HashMap();
        if (listSearchParameters != null) {
            search = (Map)mapper.convertValue((Object)listSearchParameters, Map.class);
        }
        return (OpenAiResponse)OpenAiService.execute(this.api.listRuns(threadId, search));
    }

    public Run submitToolOutputs(String threadId, String runId, SubmitToolOutputsRequest submitToolOutputsRequest) {
        return (Run)OpenAiService.execute(this.api.submitToolOutputs(threadId, runId, submitToolOutputsRequest));
    }

    public Flowable<AssistantSSE> createRunStream(String threadId, RunCreateRequest runCreateRequest) {
        runCreateRequest.setStream(Boolean.valueOf(true));
        return OpenAiService.assistantStream((Call<ResponseBody>)this.api.createRunStream(threadId, runCreateRequest));
    }

    public Run cancelRun(String threadId, String runId) {
        return (Run)OpenAiService.execute(this.api.cancelRun(threadId, runId));
    }

    public Run createThreadAndRun(CreateThreadAndRunRequest createThreadAndRunRequest) {
        return (Run)OpenAiService.execute(this.api.createThreadAndRun(createThreadAndRunRequest));
    }

    public Flowable<AssistantSSE> createThreadAndRunStream(CreateThreadAndRunRequest createThreadAndRunRequest) {
        createThreadAndRunRequest.setStream(Boolean.valueOf(true));
        return OpenAiService.assistantStream((Call<ResponseBody>)this.api.createThreadAndRunStream(createThreadAndRunRequest));
    }

    public RunStep retrieveRunStep(String threadId, String runId, String stepId) {
        return (RunStep)OpenAiService.execute(this.api.retrieveRunStep(threadId, runId, stepId));
    }

    public OpenAiResponse<RunStep> listRunSteps(String threadId, String runId, ListSearchParameters listSearchParameters) {
        Map search = new HashMap();
        if (listSearchParameters != null) {
            search = (Map)mapper.convertValue((Object)listSearchParameters, Map.class);
        }
        return (OpenAiResponse)OpenAiService.execute(this.api.listRunSteps(threadId, runId, search));
    }

    public VectorStore createVectorStore(VectorStoreRequest request) {
        return (VectorStore)OpenAiService.execute(this.api.createVectorStore(request));
    }

    public OpenAiResponse<VectorStore> listVectorStores(ListSearchParameters listSearchParameters) {
        Map search = new HashMap();
        if (listSearchParameters != null) {
            search = (Map)mapper.convertValue((Object)listSearchParameters, Map.class);
        }
        return (OpenAiResponse)OpenAiService.execute(this.api.listVectorStores(search));
    }

    public VectorStore retrieveVectorStore(String vectorStoreId) {
        return (VectorStore)OpenAiService.execute(this.api.retrieveVectorStore(vectorStoreId));
    }

    public VectorStore modifyVectorStore(String vectorStoreId, ModifyVectorStoreRequest request) {
        return (VectorStore)OpenAiService.execute(this.api.modifyVectorStore(vectorStoreId, request));
    }

    public DeleteResult deleteVectorStore(String vectorStoreId) {
        return (DeleteResult)OpenAiService.execute(this.api.deleteVectorStore(vectorStoreId));
    }

    public VectorStoreFile createVectorStoreFile(String vectorStoreId, VectorStoreFileRequest fileRequest) {
        return (VectorStoreFile)OpenAiService.execute(this.api.createVectorStoreFile(vectorStoreId, fileRequest));
    }

    public OpenAiResponse<VectorStoreFile> listVectorStoreFiles(String vectorStoreId, ListSearchParameters listSearchParameters) {
        Map search = new HashMap();
        if (listSearchParameters != null) {
            search = (Map)mapper.convertValue((Object)listSearchParameters, Map.class);
        }
        return (OpenAiResponse)OpenAiService.execute(this.api.listVectorStoreFiles(vectorStoreId, search));
    }

    public VectorStoreFile retrieveVectorStoreFile(String vectorStoreId, String fileId) {
        return (VectorStoreFile)OpenAiService.execute(this.api.retrieveVectorStoreFile(vectorStoreId, fileId));
    }

    public DeleteResult deleteVectorStoreFile(String vectorStoreId, String fileId) {
        return (DeleteResult)OpenAiService.execute(this.api.deleteVectorStoreFile(vectorStoreId, fileId));
    }

    public VectorStoreFilesBatch createVectorStoreFileBatch(String vectorStoreId, VectorStoreFilesBatchRequest request) {
        return (VectorStoreFilesBatch)OpenAiService.execute(this.api.createVectorStoreFileBatch(vectorStoreId, request));
    }

    public VectorStoreFilesBatch retrieveVectorStoreFileBatch(String vectorStoreId, String batchId) {
        return (VectorStoreFilesBatch)OpenAiService.execute(this.api.retrieveVectorStoreFileBatch(vectorStoreId, batchId));
    }

    public VectorStoreFilesBatch cancelVectorStoreFileBatch(String vectorStoreId, String batchId) {
        return (VectorStoreFilesBatch)OpenAiService.execute(this.api.cancelVectorStoreFileBatch(vectorStoreId, batchId));
    }

    public OpenAiResponse<VectorStoreFile> listVectorStoreFilesInBatch(String vectorStoreId, String batchId, ListSearchParameters listSearchParameters) {
        Map search = new HashMap();
        if (listSearchParameters != null) {
            search = (Map)mapper.convertValue((Object)listSearchParameters, Map.class);
        }
        return (OpenAiResponse)OpenAiService.execute(this.api.listVectorStoreFilesInBatch(vectorStoreId, batchId, search));
    }

    public Flowable<AssistantSSE> submitToolOutputsStream(String threadId, String runId, SubmitToolOutputsRequest submitToolOutputsRequest) {
        submitToolOutputsRequest.setStream(Boolean.valueOf(true));
        return OpenAiService.assistantStream((Call<ResponseBody>)this.api.submitToolOutputsStream(threadId, runId, submitToolOutputsRequest));
    }

    public Subscription subscription() {
        Single subscription = this.api.subscription();
        return (Subscription)subscription.blockingGet();
    }

    public static <T> T execute(Single<T> apiCall) {
        try {
            return (T)apiCall.blockingGet();
        }
        catch (HttpException e) {
            try {
                if (e.response() == null || e.response().errorBody() == null) {
                    throw e;
                }
                String errorBody = e.response().errorBody().string();
                OpenAiError error = (OpenAiError)mapper.readValue(errorBody, OpenAiError.class);
                throw new OpenAiHttpException(error, (Exception)((Object)e), e.code());
            }
            catch (IOException ex) {
                throw e;
            }
        }
    }

    public static Flowable<SSE> stream(Call<ResponseBody> apiCall) {
        return OpenAiService.stream(apiCall, false);
    }

    public BillingUsage billingUsage(@NotNull LocalDate starDate, @NotNull LocalDate endDate) {
        Single billingUsage = this.api.billingUsage(starDate, endDate);
        return (BillingUsage)billingUsage.blockingGet();
    }

    public static Flowable<SSE> stream(Call<ResponseBody> apiCall, boolean emitDone) {
        return Flowable.create(emitter -> apiCall.enqueue((Callback)new ResponseBodyCallback((FlowableEmitter<SSE>)emitter, emitDone)), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    public static <T> Flowable<T> stream(Call<ResponseBody> apiCall, Class<T> cl) {
        return OpenAiService.stream(apiCall).map(sse -> mapper.readValue(sse.getData(), cl));
    }

    public static <T> Flowable<T> stream(Call<ResponseBody> apiCall, Class<T> cl, BiConsumer<T, SSE> consumer, Supplier<T> newInstance) {
        return OpenAiService.stream(apiCall, true).map(sse -> {
            try {
                Object t = mapper.readValue(sse.getData(), cl);
                if (Objects.nonNull(consumer)) {
                    consumer.accept((Object)t, (SSE)sse);
                }
                return t;
            }
            catch (JsonProcessingException e) {
                Object t = newInstance.get();
                consumer.accept(t, (SSE)sse);
                return t;
            }
        });
    }

    public void shutdownExecutor() {
        Objects.requireNonNull(this.executorService, "executorService must be set in order to shut down");
        this.executorService.shutdown();
    }

    public Batch cancelBatch(String batchId) {
        return (Batch)OpenAiService.execute(this.api.cancelBatch(batchId));
    }

    public static OpenAiApi buildApi(String token, Duration timeout, String baseUrl) {
        OkHttpClient client = OpenAiService.defaultClient(token, timeout);
        Retrofit retrofit = OpenAiService.defaultRetrofit(client, mapper, baseUrl);
        return (OpenAiApi)retrofit.create(OpenAiApi.class);
    }

    public static OkHttpClient defaultClient(String token, Duration timeout) {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthenticationInterceptor(token)).connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).build();
    }

    public static Retrofit defaultRetrofit(OkHttpClient client, ObjectMapper mapper, String baseUrl) {
        return new Retrofit.Builder().baseUrl(baseUrl).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
    }

    public Flowable<ChatMessageAccumulator> mapStreamToAccumulator(Flowable<ChatCompletionChunk> flowable) {
        ChatFunctionCall functionCall = new ChatFunctionCall(null, null);
        AssistantMessage accumulatedMessage = new AssistantMessage();
        return flowable.map(chunk -> {
            ChatCompletionChoice firstChoice = (ChatCompletionChoice)chunk.getChoices().get(0);
            AssistantMessage messageChunk = firstChoice.getMessage();
            this.appendContent(messageChunk, accumulatedMessage);
            this.processFunctionCall(messageChunk, functionCall, accumulatedMessage);
            this.processToolCalls(messageChunk, accumulatedMessage);
            if (firstChoice.getFinishReason() != null) {
                this.handleFinishReason(firstChoice.getFinishReason(), functionCall, accumulatedMessage);
            }
            return new ChatMessageAccumulator(messageChunk, accumulatedMessage);
        });
    }

    public Flowable<ChatMessageAccumulatorWrapper> mapStreamToAccumulatorWrapper(Flowable<ChatCompletionChunk> flowable) {
        ChatFunctionCall functionCall = new ChatFunctionCall(null, null);
        AssistantMessage accumulatedMessage = new AssistantMessage();
        return flowable.map(chunk -> {
            List choices = chunk.getChoices();
            AssistantMessage messageChunk = null;
            if (null != choices && !choices.isEmpty()) {
                ChatCompletionChoice firstChoice = (ChatCompletionChoice)choices.get(0);
                messageChunk = firstChoice.getMessage();
                this.appendContent(messageChunk, accumulatedMessage);
                this.processFunctionCall(messageChunk, functionCall, accumulatedMessage);
                this.processToolCalls(messageChunk, accumulatedMessage);
                if (firstChoice.getFinishReason() != null) {
                    this.handleFinishReason(firstChoice.getFinishReason(), functionCall, accumulatedMessage);
                }
            }
            ChatMessageAccumulator chatMessageAccumulator = new ChatMessageAccumulator(messageChunk, accumulatedMessage);
            return new ChatMessageAccumulatorWrapper(chatMessageAccumulator, (ChatCompletionChunk)chunk);
        });
    }

    private void processFunctionCall(AssistantMessage messageChunk, ChatFunctionCall functionCall, AssistantMessage accumulatedMessage) {
        Optional.ofNullable(messageChunk.getFunctionCall()).ifPresent(messageFunctionCall -> {
            this.updateFunctionCall((ChatFunctionCall)messageFunctionCall, functionCall);
            accumulatedMessage.setFunctionCall(functionCall);
        });
    }

    private void updateFunctionCall(ChatFunctionCall messageFunctionCall, ChatFunctionCall functionCall) {
        Optional.ofNullable(messageFunctionCall.getName()).ifPresent(name -> functionCall.setName((functionCall.getName() == null ? "" : functionCall.getName()) + name));
        Optional.ofNullable(messageFunctionCall.getArguments()).ifPresent(argNode -> {
            if (argNode instanceof ObjectNode) {
                functionCall.setArguments(argNode);
            } else if (argNode instanceof TextNode) {
                String argumentsPart = argNode.asText();
                functionCall.setArguments((JsonNode)new TextNode((functionCall.getArguments() == null ? "" : functionCall.getArguments().asText()) + argumentsPart));
            }
        });
    }

    private void processToolCalls(AssistantMessage messageChunk, AssistantMessage accumulatedMessage) {
        Optional.ofNullable(messageChunk.getToolCalls()).ifPresent(toolCalls -> {
            ChatToolCall partToolCall = (ChatToolCall)toolCalls.get(0);
            ChatFunctionCall partFunction = partToolCall.getFunction();
            int index = partToolCall.getIndex();
            List<ChatToolCall> accumulatedChatTools = this.getOrInitializeToolCalls(accumulatedMessage);
            ChatToolCall accumulatedToolCall = accumulatedChatTools.stream().filter(chatToolCall -> chatToolCall.getIndex() == index).findFirst().orElseGet(() -> {
                ChatToolCall newToolCall = new ChatToolCall(index, partToolCall.getId(), partToolCall.getType());
                accumulatedChatTools.add(newToolCall);
                return newToolCall;
            });
            this.updateFunctionCall(partFunction, accumulatedToolCall.getFunction());
        });
    }

    private List<ChatToolCall> getOrInitializeToolCalls(AssistantMessage accumulatedMessage) {
        return Optional.ofNullable(accumulatedMessage.getToolCalls()).orElseGet(() -> {
            ArrayList newToolCalls = new ArrayList();
            accumulatedMessage.setToolCalls(newToolCalls);
            return newToolCalls;
        });
    }

    private void appendContent(AssistantMessage messageChunk, AssistantMessage accumulatedMessage) {
        accumulatedMessage.setContent(Optional.ofNullable(accumulatedMessage.getContent()).orElse("") + Optional.ofNullable(messageChunk.getContent()).orElse(""));
    }

    private void handleFinishReason(String finishReason, ChatFunctionCall functionCall, AssistantMessage accumulatedMessage) throws IOException {
        List toolCalls;
        if ("function_call".equals(finishReason) && functionCall.getArguments() instanceof TextNode) {
            functionCall.setArguments(mapper.readTree(functionCall.getArguments().asText()));
            accumulatedMessage.setFunctionCall(functionCall);
        }
        if ("tool_calls".equals(finishReason) && (toolCalls = accumulatedMessage.getToolCalls()) != null) {
            toolCalls.sort(Comparator.comparingInt(ChatToolCall::getIndex));
            for (ChatToolCall chatToolCall : toolCalls) {
                if (!(chatToolCall.getFunction().getArguments() instanceof TextNode)) continue;
                chatToolCall.getFunction().setArguments(mapper.readTree(chatToolCall.getFunction().getArguments().asText()));
            }
        }
    }
}

