/*
 * Decompiled with CFR 0.152.
 */
package cn.jsms.api.schedule.model;

import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.TimeUtils;
import cn.jsms.api.common.model.IModel;
import cn.jsms.api.common.model.RecipientPayload;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

public class ScheduleSMSPayload
implements IModel {
    private static String SEND_TIME = "send_time";
    private static String RECIPIENTS = "recipients";
    private static String MOBILE = "mobile";
    private static String SIGN_ID = "sign_id";
    private static String TEMP_ID = "temp_id";
    private static String TAG = "tag";
    private static String TEMP_PARA = "temp_para";
    private String sendTime;
    private String mobile;
    private int sign_id;
    private int temp_id;
    private String tag;
    private final Map<String, String> temp_para;
    private static Gson gson = new Gson();
    private JsonArray recipients;

    private ScheduleSMSPayload(String mobileNumber, int signId, String tag, int tempId, Map<String, String> temp_para, String sendTime, JsonArray recipients) {
        this.mobile = mobileNumber;
        this.sign_id = signId;
        this.tag = tag;
        this.temp_id = tempId;
        this.temp_para = temp_para;
        this.sendTime = sendTime;
        this.recipients = recipients;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.sendTime) {
            json.addProperty(SEND_TIME, this.sendTime);
        }
        if (null != this.mobile) {
            json.addProperty(MOBILE, this.mobile);
        }
        if (this.sign_id > 0) {
            json.addProperty(SIGN_ID, (Number)this.sign_id);
        }
        if (this.temp_id > 0) {
            json.addProperty(TEMP_ID, (Number)this.temp_id);
        }
        if (null != this.tag) {
            json.addProperty(TAG, this.tag);
        }
        JsonObject tempJson = null;
        if (null != this.temp_para) {
            tempJson = new JsonObject();
            for (String key : this.temp_para.keySet()) {
                if (this.temp_para.get(key) != null) {
                    tempJson.add(key, (JsonElement)new JsonPrimitive(this.temp_para.get(key)));
                    continue;
                }
                tempJson.add(key, (JsonElement)JsonNull.INSTANCE);
            }
        }
        if (null != tempJson) {
            json.add(TEMP_PARA, (JsonElement)tempJson);
        }
        if (null != this.recipients && this.recipients.size() > 0) {
            json.add(RECIPIENTS, (JsonElement)this.recipients);
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public String getMobile() {
        return this.mobile;
    }

    public JsonArray getRecipients() {
        return this.recipients;
    }

    public static class Builder {
        private String mobile;
        private int sign_id;
        private int temp_id;
        private String tag;
        private Map<String, String> tempParaBuilder;
        private String sendTime;
        private JsonArray recipients = new JsonArray();

        public Builder setMobileNumber(String mobileNumber) {
            this.mobile = mobileNumber.trim();
            return this;
        }

        public Builder setSignId(int signId) {
            this.sign_id = signId;
            return this;
        }

        public Builder setTempId(int tempId) {
            this.temp_id = tempId;
            return this;
        }

        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder setTempPara(Map<String, String> temp_para) {
            Preconditions.checkArgument((null != temp_para ? 1 : 0) != 0, (Object)"temp_para should not be null.");
            if (null == this.tempParaBuilder) {
                this.tempParaBuilder = new HashMap<String, String>();
            }
            for (String key : temp_para.keySet()) {
                this.tempParaBuilder.put(key, temp_para.get(key));
            }
            return this;
        }

        public Builder addTempPara(String key, String value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.tempParaBuilder) {
                this.tempParaBuilder = new HashMap<String, String>();
            }
            this.tempParaBuilder.put(key, value);
            return this;
        }

        public Builder setSendTime(String sendTime) {
            this.sendTime = sendTime;
            return this;
        }

        public Builder setRecipients(RecipientPayload ... recipients) {
            if (recipients == null) {
                return this;
            }
            for (RecipientPayload recipientPayload : recipients) {
                this.recipients.add(recipientPayload.toJSON());
            }
            return this;
        }

        public Builder addRecipient(RecipientPayload recipientPayload) {
            Preconditions.checkArgument((null != recipientPayload ? 1 : 0) != 0, (Object)"RecipientPayload should not be null");
            this.recipients.add(recipientPayload.toJSON());
            return this;
        }

        public ScheduleSMSPayload build() {
            Preconditions.checkArgument((this.temp_id >= 0 ? 1 : 0) != 0, (Object)"temp id should not less 0");
            Preconditions.checkArgument((null != this.sendTime ? 1 : 0) != 0, (Object)"send time should not be null");
            Preconditions.checkArgument((boolean)TimeUtils.isDateFormat((String)this.sendTime), (Object)"send time format is invalid");
            return new ScheduleSMSPayload(this.mobile, this.sign_id, this.tag, this.temp_id, this.tempParaBuilder, this.sendTime, this.recipients);
        }
    }
}

