/*
 * Decompiled with CFR 0.152.
 */
package com.lly835.bestpay.rest.param;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.client.WebTarget;

public class Path {
    private final List<String> paths = new ArrayList<String>();

    private Path(String ... paths) {
        Collections.addAll(this.paths, paths);
    }

    public static Path build(String ... paths) {
        Objects.requireNonNull(paths, "Paths are null.");
        return new Path(paths);
    }

    public WebTarget appendToTarget(WebTarget target) {
        WebTarget newTarget = target;
        for (String path : this.paths) {
            newTarget = newTarget.path(path);
        }
        return newTarget;
    }

    public String toString() {
        return this.paths.stream().filter(p -> p != null).map(p -> {
            if (!p.startsWith("/")) {
                return "/" + p;
            }
            return p;
        }).collect(Collectors.joining("", "{Path: ", "}"));
    }
}

