/*
 * Decompiled with CFR 0.152.
 */
package com.lly835.bestpay.service.impl;

import com.lly835.bestpay.config.AlipayConfig;
import com.lly835.bestpay.config.SignType;
import com.lly835.bestpay.service.impl.AbstractComponent;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;

class AlipaySignature
extends AbstractComponent {
    private AlipayConfig alipayConfig;

    public AlipaySignature(AlipayConfig alipayConfig) {
        Objects.requireNonNull(alipayConfig, "alipayConfig is null.");
        this.alipayConfig = alipayConfig;
    }

    public String sign(SortedMap<String, String> sortedParamMap) {
        Objects.requireNonNull(sortedParamMap, "sortedParamMap is null.");
        ArrayList paramList = new ArrayList();
        sortedParamMap.forEach((k, v) -> {
            if (StringUtils.isBlank((CharSequence)k) || k.equals("sign") || StringUtils.isBlank((CharSequence)v)) {
                return;
            }
            paramList.add(k + "=" + v);
        });
        String param = String.join((CharSequence)"&", paramList);
        return this.signParamWithRSA(param);
    }

    public boolean verify(Map<String, String> toBeVerifiedParamMap, SignType signType, String sign) {
        Objects.requireNonNull(toBeVerifiedParamMap, "to be verified param map is null.");
        if (toBeVerifiedParamMap.isEmpty()) {
            throw new IllegalArgumentException("to be verified param map is empty.");
        }
        Objects.requireNonNull(signType, "sign type is null.");
        switch (signType) {
            case MD5: {
                throw new IllegalArgumentException("unsupported sign type: MD5.");
            }
        }
        if (StringUtils.isBlank((CharSequence)sign)) {
            throw new IllegalArgumentException("sign is blank.");
        }
        ArrayList paramList = new ArrayList();
        toBeVerifiedParamMap.forEach((k, v) -> {
            if (StringUtils.isBlank((CharSequence)k) || k.equals("sign_type") || k.equals("sign") || StringUtils.isEmpty((CharSequence)v)) {
                return;
            }
            paramList.add(k + "=" + v);
        });
        Collections.sort(paramList);
        String toBeVerifiedStr = String.join((CharSequence)"&", paramList);
        boolean r = this.verifyParamWithRSA(toBeVerifiedStr, signType, sign);
        if (!r) {
            this.logger.warn("fail to verify sign with sign type {}.", (Object)signType.name());
            return false;
        }
        String notifyId = toBeVerifiedParamMap.get("notify_id");
        if (!StringUtils.isEmpty((CharSequence)notifyId) && !(r = this.verifyNotifyId(notifyId))) {
            this.logger.warn("fail to verify notify id.");
            return false;
        }
        return true;
    }

    private boolean verifyNotifyId(String notifyId) {
        return false;
    }

    private String signParamWithRSA(String param) {
        String algorithm;
        switch (this.alipayConfig.getSignType()) {
            case RSA: {
                algorithm = "SHA1WithRSA";
                break;
            }
            case RSA2: {
                algorithm = "SHA256WithRSA";
                break;
            }
            default: {
                throw new IllegalStateException("unsupported sign type [" + (Object)((Object)this.alipayConfig.getSignType()) + "].");
            }
        }
        try {
            Signature sig = Signature.getInstance(algorithm);
            sig.initSign(this.alipayConfig.getAppRSAPrivateKeyObject());
            sig.update(param.getBytes(this.alipayConfig.getInputCharset()));
            return Base64.getEncoder().encodeToString(sig.sign());
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IllegalStateException("sign error.", e);
        }
    }

    private boolean verifyParamWithRSA(String param, SignType signType, String sign) {
        String algorithm;
        switch (signType) {
            case RSA: {
                algorithm = "SHA1WithRSA";
                break;
            }
            case RSA2: {
                algorithm = "SHA256WithRSA";
                break;
            }
            default: {
                throw new IllegalStateException("unsupported sign type [" + (Object)((Object)this.alipayConfig.getSignType()) + "].");
            }
        }
        try {
            Signature sig = Signature.getInstance(algorithm);
            sig.initVerify(this.alipayConfig.getAlipayRSAPublicKeyOBject());
            sig.update(param.getBytes("utf-8"));
            return sig.verify(Base64.getDecoder().decode(sign));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IllegalStateException("AliPay verify error.");
        }
    }
}

