/*
 * Decompiled with CFR 0.152.
 */
package com.lly835.bestpay.service.impl;

import com.lly835.bestpay.config.AlipayConfig;
import com.lly835.bestpay.config.SignType;
import com.lly835.bestpay.model.AlipayBizParam;
import com.lly835.bestpay.model.PayRequest;
import com.lly835.bestpay.model.PayResponse;
import com.lly835.bestpay.model.RefundRequest;
import com.lly835.bestpay.model.RefundResponse;
import com.lly835.bestpay.service.BestPayService;
import com.lly835.bestpay.service.impl.AbstractComponent;
import com.lly835.bestpay.service.impl.AlipaySignature;
import com.lly835.bestpay.utils.JsonUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

class AlipayWapServiceImpl
extends AbstractComponent
implements BestPayService {
    private AlipayConfig alipayConfig;
    private AlipaySignature signature;

    public AlipayWapServiceImpl(AlipayConfig alipayConfig, AlipaySignature signature) {
        Objects.requireNonNull(alipayConfig, "alipayConfig is null.");
        this.alipayConfig = alipayConfig;
        Objects.requireNonNull(signature, "signature is null.");
        this.signature = signature;
    }

    @Override
    public PayResponse pay(PayRequest request) {
        String payUrl;
        this.logger.info("\u3010\u652f\u4ed8\u5b9dWap\u7aef\u652f\u4ed8\u3011request={}", (Object)JsonUtil.toJson(request));
        TreeMap<String, String> commonParamMap = new TreeMap<String, String>();
        commonParamMap.put("app_id", this.alipayConfig.getAppId());
        commonParamMap.put("method", "alipay.trade.wap.pay");
        commonParamMap.put("format", "JSON");
        commonParamMap.put("return_url", this.alipayConfig.getReturnUrl());
        commonParamMap.put("charset", this.alipayConfig.getInputCharset());
        commonParamMap.put("sign_type", this.alipayConfig.getSignType().name());
        commonParamMap.put("timestamp", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        commonParamMap.put("version", "1.0");
        commonParamMap.put("notify_url", this.alipayConfig.getNotifyUrl());
        commonParamMap.put("biz_content", JsonUtil.toJson(this.buildParam(request).getBizParam()));
        String sign = this.signature.sign(commonParamMap);
        commonParamMap.put("sign", sign);
        try {
            payUrl = new URIBuilder("https://openapi.alipay.com/gateway.do").setParameters(commonParamMap.entrySet().stream().filter(e -> {
                String k = (String)e.getKey();
                String v = (String)e.getValue();
                return !StringUtils.isBlank((CharSequence)k) && !StringUtils.isBlank((CharSequence)v);
            }).map(e -> {
                String k = (String)e.getKey();
                String v = (String)e.getValue();
                return new BasicNameValuePair(k, v);
            }).collect(Collectors.toList())).toString();
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException("illegal pay url.", e2);
        }
        PayResponse response = new PayResponse();
        response.setPayUri(URI.create(payUrl));
        this.logger.info("\u3010\u652f\u4ed8\u5b9dWap\u7aef\u652f\u4ed8\u3011response={}", (Object)JsonUtil.toJson(response));
        return response;
    }

    @Override
    public boolean verify(Map<String, String> toBeVerifiedParamMap, SignType signType, String sign) {
        return this.signature.verify(toBeVerifiedParamMap, signType, sign);
    }

    @Override
    public PayResponse asyncNotify(String notifyData) {
        return null;
    }

    @Override
    public PayResponse syncNotify(HttpServletRequest request) {
        return null;
    }

    private AlipayBizParam buildParam(PayRequest request) {
        AlipayBizParam alipayBizParam = new AlipayBizParam();
        alipayBizParam.setSubject(request.getOrderName());
        alipayBizParam.setOutTradeNo(request.getOrderId());
        alipayBizParam.setTotalAmount(String.valueOf(request.getOrderAmount()));
        alipayBizParam.setProductCode("QUICK_WAP_PAY");
        return alipayBizParam;
    }

    @Override
    public RefundResponse refund(RefundRequest request) {
        return null;
    }
}

