/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ans.shaded.com.taobao.vipserver.client.core;

import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Domain;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.Host;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.HostListener;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.HostReactor;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.IPListener;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.TenantInfo;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.core.VIPClient;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.CollectionUtils;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class EventDispatcher {
    private static ExecutorService executor = null;
    private static BlockingQueue<Domain> changedDoms = new LinkedBlockingQueue<Domain>();
    private static ConcurrentMap<String, List<HostListener>> observerMap = new ConcurrentHashMap<String, List<HostListener>>();
    private static ConcurrentMap<String, List<IPListener>> oldObserverMap = new ConcurrentHashMap<String, List<IPListener>>();

    public static void addListener(String dom, String clusters, HostListener listener) {
        EventDispatcher.addListener(dom, clusters, "", listener);
    }

    public static void addListener(String dom, String clusters, String env, HostListener listener) {
        EventDispatcher.addListener(dom, clusters, env, "", listener);
    }

    public static void addListener(String dom, String clusters, String env, String sepcifiedURL, HostListener listener) {
        List<HostListener> observers = Collections.synchronizedList(new ArrayList());
        observers.add(listener);
        observers = observerMap.putIfAbsent(Domain.getKey(dom, clusters, env), observers);
        if (observers != null) {
            observers.add(listener);
        }
        Domain domain = HostReactor.getDom(dom, clusters, env);
        domain.setSpecifiedURL(sepcifiedURL);
        EventDispatcher.domChanged(domain);
    }

    public static void addListener(String dom, String clusters, IPListener listener) {
        List<IPListener> observers = Collections.synchronizedList(new ArrayList());
        observers.add(listener);
        String unit = "";
        if (StringUtils.isNotEmpty(TenantInfo.tenantEnv)) {
            unit = TenantInfo.tenantEnv;
        }
        if ((observers = oldObserverMap.putIfAbsent(Domain.getKey(dom, clusters, unit), observers)) != null) {
            observers.add(listener);
        }
        EventDispatcher.domChanged(HostReactor.getDom(dom, clusters));
    }

    public static void removeListener(String dom, String clusters, HostListener listener) {
        List observers;
        String unit = "";
        if (StringUtils.isNotEmpty(TenantInfo.tenantEnv)) {
            unit = TenantInfo.tenantEnv;
        }
        if ((observers = (List)observerMap.get(Domain.getKey(dom, clusters, unit))) != null) {
            Iterator iter = observers.iterator();
            while (iter.hasNext()) {
                HostListener oldListener = (HostListener)iter.next();
                if (!oldListener.equals(listener)) continue;
                iter.remove();
            }
        }
    }

    public static void removeListener(String dom, String clusters, IPListener listener) {
        List observers = (List)oldObserverMap.get(Domain.getKey(dom, clusters, ""));
        if (observers != null) {
            Iterator iter = observers.iterator();
            while (iter.hasNext()) {
                IPListener oldListener = (IPListener)iter.next();
                if (!oldListener.equals(listener)) continue;
                iter.remove();
            }
        }
    }

    public static void domChanged(Domain dom) {
        if (dom == null) {
            return;
        }
        changedDoms.add(dom);
    }

    public static void setExecutor(ExecutorService executor) {
        ExecutorService oldExecutor = EventDispatcher.executor;
        EventDispatcher.executor = executor;
        oldExecutor.shutdown();
    }

    static {
        executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "com.vipserver.client.listener");
                thread.setDaemon(true);
                return thread;
            }
        });
        executor.execute(new Notifier());
    }

    private static class Notifier
    implements Runnable {
        private Notifier() {
        }

        @Override
        public void run() {
            block4: while (true) {
                Domain dom = null;
                try {
                    dom = (Domain)changedDoms.poll(5L, TimeUnit.MINUTES);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dom == null) continue;
                try {
                    List<Host> hosts;
                    List listeners = (List)observerMap.get(dom.getKey());
                    List oldListeners = (List)oldObserverMap.get(dom.getKey());
                    if (!CollectionUtils.isEmpty(listeners)) {
                        for (Object listener : listeners) {
                            hosts = Collections.unmodifiableList(dom.getHosts());
                            if (CollectionUtils.isEmpty(hosts)) continue;
                            listener.ipChanged(hosts);
                        }
                    }
                    if (CollectionUtils.isEmpty(oldListeners)) continue;
                    Iterator iterator = oldListeners.iterator();
                    while (true) {
                        Object listener;
                        if (!iterator.hasNext()) continue block4;
                        listener = (IPListener)iterator.next();
                        hosts = Collections.unmodifiableList(dom.getHosts());
                        ArrayList<String> ips = new ArrayList<String>();
                        for (Host host : hosts) {
                            if (!host.isValid()) continue;
                            String ip = host.getIp() + ":" + host.getPort();
                            for (int weight = 0; weight < host.getWeight(); ++weight) {
                                ips.add(ip);
                            }
                        }
                        List<String> results = Collections.unmodifiableList(ips);
                        if (CollectionUtils.isEmpty(results)) continue;
                        listener.ipChanged(results);
                    }
                }
                catch (Exception e) {
                    VIPClient.LOG.error("NA", "notify error for dom: " + dom.getName() + ", clusters: " + dom.getClusters(), e);
                    continue;
                }
                break;
            }
        }
    }
}

