/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.dubbo.util;

import com.alibaba.boot.dubbo.util.EnvironmentUtils;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.springframework.core.env.ConfigurableEnvironment;

public abstract class DubboUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String PROPERTY_NAME_SEPARATOR = ".";
    public static final String DUBBO_PREFIX = "dubbo";
    public static final String DUBBO_SCAN_PREFIX = "dubbo.scan";
    public static final String DUBBO_CONFIG_PREFIX = "dubbo.config";
    public static final String BASE_PACKAGES_PROPERTY_NAME = "dubbo.scan.basePackages";
    public static final String MULTIPLE_CONFIG_PROPERTY_NAME = "dubbo.config.multiple";
    public static final boolean DEFAULT_MULTIPLE_CONFIG_PROPERTY_VALUE = false;
    public static final String OVERRIDE_CONFIG_PROPERTY_NAME = "dubbo.config.override";
    public static final boolean DEFAULT_OVERRIDE_CONFIG_PROPERTY_VALUE = true;
    public static final String DUBBO_SPRING_BOOT_GITHUB_URL = "https://github.com/dubbo/dubbo-spring-boot-project";
    public static final String DUBBO_SPRING_BOOT_GIT_URL = "https://github.com/dubbo/dubbo-spring-boot-project.git";
    public static final String DUBBO_SPRING_BOOT_ISSUES_URL = "https://github.com/dubbo/dubbo-spring-boot-project/issues";
    public static final String DUBBO_GITHUB_URL = "https://github.com/alibaba/dubbo";
    public static final String DUBBO_GOOGLE_GROUP_URL = "http://groups.google.com/group/dubbo";

    public static SortedMap<String, Object> filterDubboProperties(ConfigurableEnvironment environment) {
        TreeMap<String, Object> dubboProperties = new TreeMap<String, Object>();
        Map<String, Object> properties = EnvironmentUtils.extractProperties(environment);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String propertyName = entry.getKey();
            if (!propertyName.startsWith("dubbo.")) continue;
            dubboProperties.put(propertyName, entry.getValue());
        }
        return Collections.unmodifiableSortedMap(dubboProperties);
    }
}

