/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.serpapi;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.serpapi.SerpApiProperties;
import com.alibaba.cloud.ai.toolcalling.serpapi.SerpApiService;
import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;
import org.springframework.http.HttpHeaders;

@Configuration
@EnableConfigurationProperties(value={SerpApiProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.toolcalling.serpapi", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SerpApiAutoConfiguration {
    @Bean(name={"serpApiSearch"})
    @ConditionalOnMissingBean
    @Description(value="Use SerpApi search to query for the latest news.")
    public SerpApiService serpApiSearch(JsonParseTool jsonParseTool, SerpApiProperties serpApiProperties) {
        Consumer<HttpHeaders> consumer = headers -> {
            headers.add("User-Agent", SerpApiProperties.USER_AGENT_VALUE);
            headers.add("Connection", "keep-alive");
        };
        WebClientTool webClientTool = WebClientTool.builder((JsonParseTool)jsonParseTool, (CommonToolCallProperties)serpApiProperties).httpHeadersConsumer(consumer).build();
        return new SerpApiService(serpApiProperties, jsonParseTool, webClientTool);
    }
}

