/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.worldbankdata;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.worldbankdata.WorldBankDataProperties;
import com.alibaba.cloud.ai.toolcalling.worldbankdata.WorldBankDataService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;

@Configuration
@EnableConfigurationProperties(value={WorldBankDataProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.toolcalling.worldbankdata", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class WorldBankDataAutoConfiguration {
    @Bean(name={"worldBankData"})
    @ConditionalOnMissingBean
    @Description(value="World Bank Development Data Search Service")
    public WorldBankDataService worldBankDataService(JsonParseTool jsonParseTool, WorldBankDataProperties properties) {
        return new WorldBankDataService(WebClientTool.builder((JsonParseTool)jsonParseTool, (CommonToolCallProperties)properties).httpHeadersConsumer(httpHeaders -> {
            httpHeaders.add("Accept", "application/json");
            httpHeaders.add("User-Agent", "Spring-AI-Alibaba-WorldBankData/1.0");
        }).build(), jsonParseTool, properties);
    }
}

