/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.context.edas;

import com.alibaba.cloud.context.AliCloudDeploymentMode;
import com.alibaba.cloud.context.edas.EdasChangeOrderConfiguration;
import com.alibaba.cloud.context.utils.AssertUtils;
import java.io.FileReader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleEdasChangeOrderConfiguration
implements EdasChangeOrderConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SimpleEdasChangeOrderConfiguration.class);
    private AliCloudDeploymentMode deploymentMode;
    private String projectName;
    private String tenantId;
    private String addressServerDomain;
    private String spasIdentityFile;
    private String addressServerPort;
    private String configserverClientPort;
    private String eccId;
    private String dauthAccessKey;
    private String dauthSecretKey;

    public SimpleEdasChangeOrderConfiguration() {
        String deploymentModeString = System.getProperty("alicloud.deployment.mode");
        if (deploymentModeString == null) {
            deploymentModeString = System.getenv("ALICLOUD_DEPLOYMENT_MODE");
        }
        this.deploymentMode = deploymentModeString == null ? AliCloudDeploymentMode.UNMANAGED : AliCloudDeploymentMode.valueOf(deploymentModeString);
        if (this.deploymentMode == AliCloudDeploymentMode.EDAS_MANAGED) {
            this.readEdasChangeOrderConfiguration();
            this.checkEdasChangeOrderConfiguration();
        }
    }

    private void readEdasChangeOrderConfiguration() {
        this.configserverClientPort = System.getProperty("configserver.client.port");
        this.projectName = System.getProperty("project.name");
        this.addressServerDomain = System.getProperty("address.server.domain");
        this.addressServerPort = System.getProperty("address.server.port");
        this.spasIdentityFile = System.getProperty("spas.identity");
        this.tenantId = System.getProperty("tenant.id");
        this.eccId = System.getProperty("ecc.id");
        try {
            FileReader spasIdentityFileReader = new FileReader(this.spasIdentityFile);
            Properties properties = new Properties();
            properties.load(spasIdentityFileReader);
            this.dauthAccessKey = properties.getProperty("accessKey");
            this.dauthSecretKey = properties.getProperty("secretKey");
        }
        catch (Exception e) {
            log.error("read spas identity file error.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void checkEdasChangeOrderConfiguration() {
        AssertUtils.notNull(this.projectName, "Project name can't be null.");
        AssertUtils.notNull(this.tenantId, "Tenant id can't be null.");
        AssertUtils.notNull(this.dauthAccessKey, "Dauth ak can't be null.");
        AssertUtils.notNull(this.dauthSecretKey, "Dauth sk can't be null.");
        AssertUtils.notNull(this.addressServerPort, "Server port can't be null.");
        AssertUtils.notNull(this.addressServerDomain, "Server domain can't be null.");
    }

    @Override
    public boolean isEdasManaged() {
        return this.deploymentMode == AliCloudDeploymentMode.EDAS_MANAGED;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getAddressServerDomain() {
        return this.addressServerDomain;
    }

    @Override
    public String getSpasIdentityFile() {
        return this.spasIdentityFile;
    }

    @Override
    public String getAddressServerPort() {
        return this.addressServerPort;
    }

    @Override
    public String getConfigserverClientPort() {
        return this.configserverClientPort;
    }

    @Override
    public String getEccId() {
        return this.eccId;
    }

    @Override
    public String getDauthAccessKey() {
        return this.dauthAccessKey;
    }

    @Override
    public String getDauthSecretKey() {
        return this.dauthSecretKey;
    }
}

