/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.spring.boot.redis.actuate.endpoint;

import com.alibaba.cloud.spring.boot.context.env.AliCloudProperties;
import com.alibaba.cloud.spring.boot.redis.env.RedisProperties;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.concurrent.Callable;

public abstract class AbstractRedisEndpoint {
    private final AliCloudProperties aliCloudProperties;
    private final RedisProperties redisProperties;

    public AbstractRedisEndpoint(AliCloudProperties aliCloudProperties, RedisProperties redisProperties) {
        this.aliCloudProperties = aliCloudProperties;
        this.redisProperties = redisProperties;
    }

    public AliCloudProperties getAliCloudProperties() {
        return this.aliCloudProperties;
    }

    public String getAccessKey() {
        return this.getAliCloudProperties().getAccessKey();
    }

    public String getSecretKey() {
        return this.getAliCloudProperties().getSecretKey();
    }

    protected IAcsClient createIAcsClient(String regionId) {
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)this.getAccessKey(), (String)this.getSecretKey());
        return new DefaultAcsClient((IClientProfile)profile);
    }

    protected Object execute(Callable<?> task) {
        Exception result = null;
        try {
            result = (Exception)task.call();
        }
        catch (Exception e) {
            result = e;
        }
        return result;
    }

    public String getInstanceId() {
        return this.redisProperties.getInstanceId();
    }

    public String getDefaultRegionID() {
        return this.redisProperties.getDefaultRegionId();
    }
}

