/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.discovery;

import com.alibaba.cloud.nacos.ConditionalOnNacosDiscoveryEnabled;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.discovery.NacosDiscoveryAutoConfiguration;
import com.alibaba.cloud.nacos.discovery.NacosDiscoveryHeartBeatPublisher;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnBlockingDiscoveryEnabled
@ConditionalOnNacosDiscoveryEnabled
@AutoConfigureAfter(value={NacosDiscoveryAutoConfiguration.class}, name={"de.codecentric.boot.admin.server.cloud.config.AdminServerDiscoveryAutoConfiguration"})
public class NacosDiscoveryHeartBeatConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={NacosDiscoveryHeartBeatCondition.class})
    public NacosDiscoveryHeartBeatPublisher nacosDiscoveryHeartBeatPublisher(NacosDiscoveryProperties nacosDiscoveryProperties) {
        return new NacosDiscoveryHeartBeatPublisher(nacosDiscoveryProperties);
    }

    private static class NacosDiscoveryHeartBeatCondition
    extends AnyNestedCondition {
        NacosDiscoveryHeartBeatCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"spring.cloud.nacos.discovery.heart-beat.enabled"}, matchIfMissing=false)
        static class NacosDiscoveryHeartBeatEnabled {
            NacosDiscoveryHeartBeatEnabled() {
            }
        }

        @ConditionalOnBean(type={"de.codecentric.boot.admin.server.cloud.discovery.InstanceDiscoveryListener"})
        static class SpringBootAdminHeartBeatEnabled {
            SpringBootAdminHeartBeatEnabled() {
            }
        }

        @ConditionalOnProperty(value={"spring.cloud.gateway.discovery.locator.enabled"}, matchIfMissing=false)
        static class GatewayLocatorHeartBeatEnabled {
            GatewayLocatorHeartBeatEnabled() {
            }
        }
    }
}

