/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.custom.context;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.sentinel.SentinelProperties;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.init.InitExecutor;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class SentinelApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        String applicationName = environment.getProperty("spring.application.name");
        SentinelProperties sentinelProperties = (SentinelProperties)Binder.get((Environment)environment).bindOrCreate("spring.cloud.sentinel", SentinelProperties.class);
        this.initSentinelConfig(sentinelProperties, applicationName);
    }

    private void initSentinelConfig(SentinelProperties properties, String applicationName) {
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.log.dir")) && StringUtils.isNotBlank((CharSequence)properties.getLog().getDir())) {
            System.setProperty("csp.sentinel.log.dir", properties.getLog().getDir());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.log.use.pid")) && properties.getLog().isSwitchPid()) {
            System.setProperty("csp.sentinel.log.use.pid", String.valueOf(properties.getLog().isSwitchPid()));
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.app.name")) && StringUtils.isNotBlank((CharSequence)applicationName)) {
            System.setProperty("csp.sentinel.app.name", applicationName);
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.api.port")) && StringUtils.isNotBlank((CharSequence)properties.getTransport().getPort())) {
            System.setProperty("csp.sentinel.api.port", properties.getTransport().getPort());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.dashboard.server")) && StringUtils.isNotBlank((CharSequence)properties.getTransport().getDashboard())) {
            System.setProperty("csp.sentinel.dashboard.server", properties.getTransport().getDashboard());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.heartbeat.interval.ms")) && StringUtils.isNotBlank((CharSequence)properties.getTransport().getHeartbeatIntervalMs())) {
            System.setProperty("csp.sentinel.heartbeat.interval.ms", properties.getTransport().getHeartbeatIntervalMs());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.heartbeat.client.ip")) && StringUtils.isNotBlank((CharSequence)properties.getTransport().getClientIp())) {
            System.setProperty("csp.sentinel.heartbeat.client.ip", properties.getTransport().getClientIp());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.charset")) && StringUtils.isNotBlank((CharSequence)properties.getMetric().getCharset())) {
            System.setProperty("csp.sentinel.charset", properties.getMetric().getCharset());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.metric.file.single.size")) && StringUtils.isNotBlank((CharSequence)properties.getMetric().getFileSingleSize())) {
            System.setProperty("csp.sentinel.metric.file.single.size", properties.getMetric().getFileSingleSize());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.metric.file.total.count")) && StringUtils.isNotBlank((CharSequence)properties.getMetric().getFileTotalCount())) {
            System.setProperty("csp.sentinel.metric.file.total.count", properties.getMetric().getFileTotalCount());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.flow.cold.factor")) && StringUtils.isNotBlank((CharSequence)properties.getFlow().getColdFactor())) {
            System.setProperty("csp.sentinel.flow.cold.factor", properties.getFlow().getColdFactor());
        }
        if (StringUtils.isNotBlank((CharSequence)properties.getBlockPage())) {
            SentinelConfig.setConfig((String)"csp.sentinel.web.servlet.block.page", (String)properties.getBlockPage());
        }
        if (properties.isEager()) {
            InitExecutor.doInit();
        }
    }
}

