/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.stream.binder.rocketmq.integration.inbound.pull;

import java.util.Collections;
import org.apache.rocketmq.client.consumer.DefaultLitePullConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.acks.AcknowledgmentCallback;
import org.springframework.util.Assert;

public class RocketMQAckCallback
implements AcknowledgmentCallback {
    private static final Logger log = LoggerFactory.getLogger(RocketMQAckCallback.class);
    private boolean acknowledged;
    private boolean autoAckEnabled = true;
    private MessageExt messageExt;
    private DefaultLitePullConsumer consumer;
    private final MessageQueue messageQueue;

    public RocketMQAckCallback(DefaultLitePullConsumer consumer, MessageQueue messageQueue, MessageExt messageExt) {
        this.messageExt = messageExt;
        this.consumer = consumer;
        this.messageQueue = messageQueue;
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public void noAutoAck() {
        this.autoAckEnabled = false;
    }

    public boolean isAutoAck() {
        return this.autoAckEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void acknowledge(AcknowledgmentCallback.Status status) {
        Assert.notNull((Object)status, (String)"'status' cannot be null");
        if (this.acknowledged) {
            throw new IllegalStateException("Already acknowledged");
        }
        MessageQueue messageQueue = this.messageQueue;
        // MONITORENTER : messageQueue
        try {
            long offset = this.messageExt.getQueueOffset();
            switch (status) {
                case REJECT: 
                case ACCEPT: {
                    this.consumer.commit(Collections.singleton(this.messageQueue), false);
                    return;
                }
                case REQUEUE: {
                    this.consumer.seek(this.messageQueue, offset);
                    return;
                }
            }
            return;
        }
        catch (MQClientException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.acknowledged = true;
        }
    }
}

