/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.config;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;

public final class WebServletLocalConfig {
    public static final String BLOCK_PAGE_URL_CONF_KEY = "csp.sentinel.web.servlet.block.page";
    public static final String BLOCK_PAGE_HTTP_STATUS_CONF_KEY = "csp.sentinel.web.servlet.block.status";
    public static final String BLOCK_PAGE_ALLOW_ORIGINS_CONF_KEY = "csp.sentinel.web.servlet.block.cors-allow-origins";
    private static final int HTTP_STATUS_TOO_MANY_REQUESTS = 429;

    public static String getBlockPage() {
        return SentinelConfig.getConfig((String)BLOCK_PAGE_URL_CONF_KEY);
    }

    public static void setBlockPage(String blockPage) {
        SentinelConfig.setConfig((String)BLOCK_PAGE_URL_CONF_KEY, (String)blockPage);
    }

    public static int getBlockPageHttpStatus() {
        String value = SentinelConfig.getConfig((String)BLOCK_PAGE_HTTP_STATUS_CONF_KEY);
        if (StringUtil.isEmpty((String)value)) {
            return 429;
        }
        try {
            int s = Integer.parseInt(value);
            if (s <= 0) {
                throw new IllegalArgumentException("Invalid status code: " + s);
            }
            return s;
        }
        catch (Exception e) {
            RecordLog.warn((String)("[WebServletConfig] Invalid block HTTP status (" + value + "), using default 429"), (Object[])new Object[0]);
            WebServletLocalConfig.setBlockPageHttpStatus(429);
            return 429;
        }
    }

    public static void setBlockPageHttpStatus(int httpStatus) {
        if (httpStatus <= 0) {
            throw new IllegalArgumentException("Invalid HTTP status code: " + httpStatus);
        }
        SentinelConfig.setConfig((String)BLOCK_PAGE_HTTP_STATUS_CONF_KEY, (String)String.valueOf(httpStatus));
    }

    private WebServletLocalConfig() {
    }
}

