/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLCurrentOfCursorExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCommitStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGAlterSchemaStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGConnectToStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGCreateSchemaStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDeleteStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDropSchemaStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGShowStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGStartTransactionStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGCreateTableParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class PGSQLStatementParser
extends SQLStatementParser {
    public static final String TIME_ZONE = "TIME ZONE";
    public static final String TIME = "TIME";
    public static final String LOCAL = "LOCAL";

    public PGSQLStatementParser(PGExprParser parser) {
        super(parser);
    }

    public PGSQLStatementParser(String sql) {
        super(new PGExprParser(sql));
    }

    public PGSQLStatementParser(String sql, SQLParserFeature ... features) {
        super(new PGExprParser(sql, features));
    }

    public PGSQLStatementParser(Lexer lexer) {
        super(new PGExprParser(lexer));
    }

    @Override
    public PGSelectParser createSQLSelectParser() {
        return new PGSelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public SQLUpdateStatement parseUpdateStatement() {
        this.accept(Token.UPDATE);
        PGUpdateStatement udpateStatement = new PGUpdateStatement();
        SQLSelectParser selectParser = this.exprParser.createSelectParser();
        SQLTableSource tableSource = selectParser.parseTableSource();
        udpateStatement.setTableSource(tableSource);
        this.parseUpdateSet(udpateStatement);
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLTableSource from = selectParser.parseTableSource();
            udpateStatement.setFrom(from);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            udpateStatement.setWhere(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.RETURNING) {
            this.lexer.nextToken();
            while (true) {
                udpateStatement.getReturning().add(this.exprParser.expr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        return udpateStatement;
    }

    @Override
    public PGInsertStatement parseInsert() {
        PGInsertStatement stmt = new PGInsertStatement();
        if (this.lexer.token() == Token.INSERT) {
            this.lexer.nextToken();
            this.accept(Token.INTO);
            SQLName tableName = this.exprParser.name();
            stmt.setTableName(tableName);
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
                stmt.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.IDENTIFIER) {
                stmt.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.DEFAULT) {
            this.lexer.nextToken();
            this.accept(Token.VALUES);
            stmt.setDefaultValues(true);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getColumns(), stmt);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            while (true) {
                this.accept(Token.LPAREN);
                SQLInsertStatement.ValuesClause valuesCaluse = new SQLInsertStatement.ValuesClause();
                this.exprParser.exprList(valuesCaluse.getValues(), valuesCaluse);
                stmt.addValueCause(valuesCaluse);
                this.accept(Token.RPAREN);
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.SELECT) {
            SQLQueryExpr queryExpr = (SQLQueryExpr)this.exprParser.expr();
            stmt.setQuery(queryExpr.getSubQuery());
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.CONFLICT)) {
                SQLExpr where;
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    ArrayList<SQLExpr> onConflictTarget = new ArrayList<SQLExpr>();
                    this.exprParser.exprList(onConflictTarget, stmt);
                    stmt.setOnConflictTarget(onConflictTarget);
                    this.accept(Token.RPAREN);
                }
                if (this.lexer.token() == Token.ON) {
                    this.lexer.nextToken();
                    this.accept(Token.CONSTRAINT);
                    SQLName constraintName = this.exprParser.name();
                    stmt.setOnConflictConstraint(constraintName);
                }
                if (this.lexer.token() == Token.WHERE) {
                    this.lexer.nextToken();
                    where = this.exprParser.expr();
                    stmt.setOnConflictWhere(where);
                }
                if (this.lexer.token() == Token.DO) {
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals(FnvHash.Constants.NOTHING)) {
                        this.lexer.nextToken();
                        stmt.setOnConflictDoNothing(true);
                    } else {
                        this.accept(Token.UPDATE);
                        this.accept(Token.SET);
                        while (true) {
                            SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
                            stmt.addConflicUpdateItem(item);
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        if (this.lexer.token() == Token.WHERE) {
                            this.lexer.nextToken();
                            where = this.exprParser.expr();
                            stmt.setOnConflictUpdateWhere(where);
                        }
                    }
                }
            }
        }
        if (this.lexer.token() == Token.RETURNING) {
            this.lexer.nextToken();
            SQLExpr returning = this.exprParser.expr();
            if (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                SQLListExpr list = new SQLListExpr();
                list.addItem(returning);
                this.exprParser.exprList(list.getItems(), list);
                returning = list;
            }
            stmt.setReturning(returning);
        }
        return stmt;
    }

    @Override
    public PGCreateSchemaStatement parseCreateSchema() {
        this.accept(Token.CREATE);
        this.accept(Token.SCHEMA);
        PGCreateSchemaStatement stmt = new PGCreateSchemaStatement();
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        if (this.lexer.token() == Token.IDENTIFIER) {
            if (this.lexer.identifierEquals("AUTHORIZATION")) {
                this.lexer.nextToken();
                stmt.setAuthorization(true);
                SQLIdentifierExpr userName = (SQLIdentifierExpr)this.exprParser.expr();
                stmt.setUserName(userName);
            } else {
                SQLIdentifierExpr schemaName = (SQLIdentifierExpr)this.exprParser.expr();
                stmt.setSchemaName(schemaName);
                if (this.lexer.identifierEquals("AUTHORIZATION")) {
                    this.lexer.nextToken();
                    stmt.setAuthorization(true);
                    SQLIdentifierExpr userName = (SQLIdentifierExpr)this.exprParser.expr();
                    stmt.setUserName(userName);
                }
            }
        } else {
            throw new ParserException("TODO " + this.lexer.info());
        }
        return stmt;
    }

    @Override
    protected SQLStatement parseAlterSchema() {
        this.accept(Token.ALTER);
        this.accept(Token.SCHEMA);
        PGAlterSchemaStatement stmt = new PGAlterSchemaStatement();
        stmt.setSchemaName(this.exprParser.identifier());
        if (this.lexer.identifierEquals(FnvHash.Constants.RENAME)) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            stmt.setNewName(this.exprParser.identifier());
        } else if (this.lexer.identifierEquals(FnvHash.Constants.OWNER)) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            stmt.setNewOwner(this.exprParser.identifier());
        }
        return stmt;
    }

    @Override
    public PGDropSchemaStatement parseDropSchema() {
        PGDropSchemaStatement stmt = new PGDropSchemaStatement();
        if (this.lexer.token() == Token.SCHEMA) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.DATABASE);
        }
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLIdentifierExpr name = this.exprParser.identifier();
        stmt.setSchemaName(name);
        if (this.lexer.identifierEquals(FnvHash.Constants.RESTRICT)) {
            this.lexer.nextToken();
            stmt.setRestrict(true);
        } else if (this.lexer.token() == Token.CASCADE || this.lexer.identifierEquals(FnvHash.Constants.CASCADE)) {
            this.lexer.nextToken();
            stmt.setCascade(true);
        } else {
            stmt.setCascade(false);
        }
        return stmt;
    }

    @Override
    public PGDeleteStatement parseDeleteStatement() {
        this.lexer.nextToken();
        PGDeleteStatement deleteStatement = new PGDeleteStatement();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.ONLY) {
            this.lexer.nextToken();
            deleteStatement.setOnly(true);
        }
        SQLName tableName = this.exprParser.name();
        deleteStatement.setTableName(tableName);
        if (this.lexer.token() == Token.AS) {
            this.accept(Token.AS);
        }
        if (this.lexer.token() == Token.IDENTIFIER) {
            deleteStatement.setAlias(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            SQLTableSource tableSource = this.createSQLSelectParser().parseTableSource();
            deleteStatement.setUsing(tableSource);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.CURRENT) {
                this.lexer.nextToken();
                this.accept(Token.OF);
                SQLName cursorName = this.exprParser.name();
                SQLCurrentOfCursorExpr where = new SQLCurrentOfCursorExpr(cursorName);
                deleteStatement.setWhere(where);
            } else {
                SQLExpr where = this.exprParser.expr();
                deleteStatement.setWhere(where);
            }
        }
        if (this.lexer.token() == Token.RETURNING) {
            this.lexer.nextToken();
            this.accept(Token.STAR);
            deleteStatement.setReturning(true);
        }
        return deleteStatement;
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        switch (this.lexer.token()) {
            case BEGIN: 
            case START: {
                PGStartTransactionStatement stmt = this.parseBegin();
                statementList.add(stmt);
                return true;
            }
            case WITH: {
                statementList.add(this.parseWith());
                return true;
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CONNECT)) {
            SQLStatement stmt = this.parseConnectTo();
            statementList.add(stmt);
            return true;
        }
        return false;
    }

    protected PGStartTransactionStatement parseBegin() {
        PGStartTransactionStatement stmt = new PGStartTransactionStatement();
        if (this.lexer.token() == Token.START) {
            this.lexer.nextToken();
            this.acceptIdentifier("TRANSACTION");
        } else {
            this.accept(Token.BEGIN);
        }
        return stmt;
    }

    public SQLStatement parseConnectTo() {
        this.acceptIdentifier("CONNECT");
        this.accept(Token.TO);
        PGConnectToStatement stmt = new PGConnectToStatement();
        SQLName target = this.exprParser.name();
        stmt.setTarget(target);
        return stmt;
    }

    @Override
    public PGSelectStatement parseSelect() {
        PGSelectParser selectParser = this.createSQLSelectParser();
        SQLSelect select = selectParser.select();
        return new PGSelectStatement(select);
    }

    @Override
    public SQLStatement parseWith() {
        SQLWithSubqueryClause with = this.parseWithQuery();
        if (this.lexer.token() == Token.INSERT) {
            PGInsertStatement stmt = this.parseInsert();
            stmt.setWith(with);
            return stmt;
        }
        if (this.lexer.token() == Token.SELECT) {
            PGSelectStatement stmt = this.parseSelect();
            stmt.getSelect().setWithSubQuery(with);
            return stmt;
        }
        if (this.lexer.token() == Token.DELETE) {
            PGDeleteStatement stmt = this.parseDeleteStatement();
            stmt.setWith(with);
            return stmt;
        }
        if (this.lexer.token() == Token.UPDATE) {
            PGUpdateStatement stmt = (PGUpdateStatement)this.parseUpdateStatement();
            stmt.setWith(with);
            return stmt;
        }
        throw new ParserException("TODO. " + this.lexer.info());
    }

    @Override
    protected SQLAlterTableAlterColumn parseAlterColumn() {
        if (this.lexer.token() == Token.COLUMN) {
            this.lexer.nextToken();
        }
        SQLColumnDefinition column = this.exprParser.parseColumn();
        SQLAlterTableAlterColumn alterColumn = new SQLAlterTableAlterColumn();
        alterColumn.setColumn(column);
        if (column.getDataType() == null && column.getConstraints().size() == 0) {
            if (this.lexer.token() == Token.SET) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.NOT) {
                    this.lexer.nextToken();
                    this.accept(Token.NULL);
                    alterColumn.setSetNotNull(true);
                } else {
                    this.accept(Token.DEFAULT);
                    SQLExpr defaultValue = this.exprParser.expr();
                    alterColumn.setSetDefault(defaultValue);
                }
            } else if (this.lexer.token() == Token.DROP) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.NOT) {
                    this.lexer.nextToken();
                    this.accept(Token.NULL);
                    alterColumn.setDropNotNull(true);
                } else {
                    this.accept(Token.DEFAULT);
                    alterColumn.setDropDefault(true);
                }
            }
        }
        return alterColumn;
    }

    @Override
    public SQLStatement parseShow() {
        this.accept(Token.SHOW);
        PGShowStatement stmt = new PGShowStatement();
        switch (this.lexer.token()) {
            case ALL: {
                stmt.setExpr(new SQLIdentifierExpr(Token.ALL.name()));
                this.lexer.nextToken();
                break;
            }
            default: {
                stmt.setExpr(this.exprParser.expr());
            }
        }
        return stmt;
    }

    @Override
    public SQLStatement parseCommit() {
        SQLCommitStatement stmt = new SQLCommitStatement();
        stmt.setDbType(this.dbType);
        this.lexer.nextToken();
        return stmt;
    }

    @Override
    public SQLStatement parseSet() {
        SQLExpr valueExpr;
        SQLIdentifierExpr paramExpr;
        this.accept(Token.SET);
        Token token = this.lexer.token();
        String range = "";
        SQLSetStatement.Option option = null;
        if (token == Token.SESSION) {
            this.lexer.nextToken();
            range = Token.SESSION.name();
            option = SQLSetStatement.Option.SESSION;
        } else if (token == Token.IDENTIFIER && LOCAL.equalsIgnoreCase(this.lexer.stringVal())) {
            range = LOCAL;
            option = SQLSetStatement.Option.LOCAL;
            this.lexer.nextToken();
        }
        long hash = this.lexer.hash_lower();
        String parameter = this.lexer.stringVal();
        ArrayList<SQLExpr> values = new ArrayList<SQLExpr>();
        if (hash == FnvHash.Constants.TIME) {
            this.lexer.nextToken();
            this.acceptIdentifier("ZONE");
            paramExpr = new SQLIdentifierExpr(TIME_ZONE);
            String value = this.lexer.stringVal();
            if (this.lexer.token() == Token.IDENTIFIER) {
                values.add(new SQLIdentifierExpr(value.toUpperCase()));
            } else {
                values.add(new SQLCharExpr(value));
            }
            this.lexer.nextToken();
        } else if (hash == FnvHash.Constants.ROLE) {
            paramExpr = new SQLIdentifierExpr(parameter);
            this.lexer.nextToken();
            values.add(this.exprParser.primary());
            this.lexer.nextToken();
        } else {
            paramExpr = new SQLIdentifierExpr(parameter);
            this.lexer.nextToken();
            while (!this.lexer.isEOF()) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LITERAL_CHARS) {
                    values.add(new SQLCharExpr(this.lexer.stringVal()));
                } else if (this.lexer.token() == Token.LITERAL_INT) {
                    values.add(new SQLIdentifierExpr(this.lexer.numberString()));
                } else if (this.lexer.identifierEquals(FnvHash.Constants.JSON_SET) || this.lexer.identifierEquals(FnvHash.Constants.JSONB_SET)) {
                    SQLExpr json_set = this.exprParser.expr();
                    values.add(json_set);
                } else {
                    values.add(new SQLIdentifierExpr(this.lexer.stringVal()));
                }
                this.lexer.nextToken();
            }
        }
        if (values.size() == 1) {
            valueExpr = (SQLExpr)values.get(0);
        } else {
            SQLListExpr listExpr = new SQLListExpr();
            for (SQLExpr value : values) {
                listExpr.addItem(value);
            }
            valueExpr = listExpr;
        }
        SQLSetStatement stmt = new SQLSetStatement(paramExpr, valueExpr, this.dbType);
        stmt.setOption(option);
        return stmt;
    }

    @Override
    public SQLCreateIndexStatement parseCreateIndex(boolean acceptCreate) {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        SQLCreateIndexStatement stmt = new SQLCreateIndexStatement(this.getDbType());
        if (this.lexer.token() == Token.UNIQUE) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("CLUSTERED")) {
                this.lexer.nextToken();
                stmt.setType("UNIQUE CLUSTERED");
            } else {
                stmt.setType("UNIQUE");
            }
        } else if (this.lexer.identifierEquals("FULLTEXT")) {
            stmt.setType("FULLTEXT");
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals("NONCLUSTERED")) {
            stmt.setType("NONCLUSTERED");
            this.lexer.nextToken();
        }
        this.accept(Token.INDEX);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CONCURRENTLY)) {
            this.lexer.nextToken();
            stmt.setConcurrently(true);
        }
        if (this.lexer.token() != Token.ON) {
            stmt.setName(this.exprParser.name());
        }
        this.accept(Token.ON);
        stmt.setTable(this.exprParser.name());
        if (this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            String using = this.lexer.stringVal();
            this.accept(Token.IDENTIFIER);
            stmt.setUsing(using);
        }
        this.accept(Token.LPAREN);
        while (true) {
            SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
            item.setParent(stmt);
            stmt.addItem(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                String optionName = this.lexer.stringVal();
                this.accept(Token.IDENTIFIER);
                this.accept(Token.EQ);
                SQLExpr option = this.exprParser.expr();
                option.setParent(stmt);
                stmt.addOption(optionName, option);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.TABLESPACE) {
            this.lexer.nextToken();
            SQLName tablespace = this.exprParser.name();
            stmt.setTablespace(tablespace);
        }
        return stmt;
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new PGCreateTableParser(this.exprParser);
    }
}

