/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.repository;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDeclareItem;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLWindow;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLFetchStatement;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyConstraint;
import com.alibaba.druid.sql.ast.statement.SQLIfStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUniqueConstraint;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.db2.ast.DB2Object;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsertStatement;
import com.alibaba.druid.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.druid.sql.dialect.hive.stmt.HiveCreateTableStatement;
import com.alibaba.druid.sql.dialect.hive.visitor.HiveASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.mysql.ast.MysqlForeignKey;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlCursorDeclareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlDeclareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlRepeatStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsCreateTableStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.alibaba.druid.sql.dialect.odps.visitor.OdpsASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreatePackageStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDeleteStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleForStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleForeignKey;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMultiInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectSubqueryTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDeleteStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGFunctionTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerInsertStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerUpdateStatement;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitorAdapter;
import com.alibaba.druid.sql.repository.SchemaObject;
import com.alibaba.druid.sql.repository.SchemaRepository;
import com.alibaba.druid.sql.repository.SchemaResolveVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.druid.util.FnvHash;
import com.alibaba.druid.util.PGUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class SchemaResolveVisitorFactory {
    SchemaResolveVisitorFactory() {
    }

    static void resolve(SchemaResolveVisitor visitor, SQLCreateTableStatement x) {
        SchemaRepository repository;
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLExprTableSource table = x.getTableSource();
        ctx.setTableSource(table);
        table.accept(visitor);
        List<SQLTableElement> elements = x.getTableElementList();
        for (int i = 0; i < elements.size(); ++i) {
            SQLTableElement e = elements.get(i);
            if (e instanceof SQLColumnDefinition) {
                SQLColumnDefinition columnn = (SQLColumnDefinition)e;
                SQLName columnnName = columnn.getName();
                if (!(columnnName instanceof SQLIdentifierExpr)) continue;
                SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)columnnName;
                identifierExpr.setResolvedTableSource(table);
                identifierExpr.setResolvedColumn(columnn);
                continue;
            }
            if (e instanceof SQLUniqueConstraint) {
                List<SQLSelectOrderByItem> columns = ((SQLUniqueConstraint)((Object)e)).getColumns();
                for (SQLSelectOrderByItem orderByItem : columns) {
                    SQLExpr orderByItemExpr = orderByItem.getExpr();
                    if (!(orderByItemExpr instanceof SQLIdentifierExpr)) continue;
                    SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)orderByItemExpr;
                    identifierExpr.setResolvedTableSource(table);
                    SQLColumnDefinition column = x.findColumn(identifierExpr.nameHashCode64());
                    if (column == null) continue;
                    identifierExpr.setResolvedColumn(column);
                }
                continue;
            }
            e.accept(visitor);
        }
        SQLSelect select = x.getSelect();
        if (select != null) {
            visitor.visit(select);
        }
        if ((repository = visitor.getRepository()) != null) {
            repository.acceptCreateTable(x);
        }
        visitor.popContext();
        SQLExprTableSource like = x.getLike();
        if (like != null) {
            like.accept(visitor);
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLUpdateStatement x) {
        SQLOrderBy orderBy;
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLWithSubqueryClause with = x.getWith();
        if (with != null) {
            with.accept(visitor);
        }
        SQLTableSource table = x.getTableSource();
        SQLTableSource from = x.getFrom();
        ctx.setTableSource(table);
        ctx.setFrom(from);
        table.accept(visitor);
        if (from != null) {
            from.accept(visitor);
        }
        List<SQLUpdateSetItem> items = x.getItems();
        for (SQLUpdateSetItem item : items) {
            SQLExpr value;
            SQLExpr column = item.getColumn();
            if (column instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)column;
                identifierExpr.setResolvedTableSource(table);
                visitor.visit(identifierExpr);
            } else if (column instanceof SQLListExpr) {
                SQLListExpr columnGroup = (SQLListExpr)column;
                for (SQLExpr columnGroupItem : columnGroup.getItems()) {
                    if (columnGroupItem instanceof SQLIdentifierExpr) {
                        SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)columnGroupItem;
                        identifierExpr.setResolvedTableSource(table);
                        visitor.visit(identifierExpr);
                        continue;
                    }
                    columnGroupItem.accept(visitor);
                }
            } else {
                column.accept(visitor);
            }
            if ((value = item.getValue()) == null) continue;
            value.accept(visitor);
        }
        SQLExpr where = x.getWhere();
        if (where != null) {
            where.accept(visitor);
        }
        if ((orderBy = x.getOrderBy()) != null) {
            orderBy.accept(visitor);
        }
        for (SQLExpr sqlExpr : x.getReturning()) {
            sqlExpr.accept(visitor);
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLDeleteStatement x) {
        SQLExpr where;
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLWithSubqueryClause with = x.getWith();
        if (with != null) {
            visitor.visit(with);
        }
        SQLTableSource table = x.getTableSource();
        SQLTableSource from = x.getFrom();
        if (from == null) {
            from = x.getUsing();
        }
        if (table == null && from != null) {
            table = from;
            from = null;
        }
        if (from != null) {
            ctx.setFrom(from);
            from.accept(visitor);
        }
        if (table != null) {
            String alias;
            SQLTableSource refTableSource;
            SQLExpr tableExpr;
            if (from != null && table instanceof SQLExprTableSource && (tableExpr = ((SQLExprTableSource)table).getExpr()) instanceof SQLPropertyExpr && ((SQLPropertyExpr)tableExpr).getName().equals("*") && (refTableSource = from.findTableSource(alias = ((SQLPropertyExpr)tableExpr).getOwnernName())) != null) {
                ((SQLPropertyExpr)tableExpr).setResolvedTableSource(refTableSource);
            }
            table.accept(visitor);
            ctx.setTableSource(table);
        }
        if ((where = x.getWhere()) != null) {
            where.accept(visitor);
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLInsertStatement x) {
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLWithSubqueryClause with = x.getWith();
        if (with != null) {
            visitor.visit(with);
        }
        SQLExprTableSource table = x.getTableSource();
        ctx.setTableSource(table);
        if (table != null) {
            table.accept(visitor);
        }
        for (SQLExpr column : x.getColumns()) {
            column.accept(visitor);
        }
        if (x instanceof HiveInsertStatement) {
            for (SQLAssignItem item : ((HiveInsertStatement)x).getPartitions()) {
                item.accept(visitor);
            }
        }
        for (SQLInsertStatement.ValuesClause valuesClause : x.getValuesList()) {
            valuesClause.accept(visitor);
        }
        SQLSelect query = x.getQuery();
        if (query != null) {
            visitor.visit(query);
        }
        visitor.popContext();
    }

    static void resolveIdent(SchemaResolveVisitor visitor, SQLIdentifierExpr x) {
        SQLParameter parameter;
        SQLDeclareItem declareItem;
        SchemaResolveVisitor.Context parentCtx;
        SQLSelectQueryBlock queryBlock;
        SchemaResolveVisitor.Context ctx = visitor.getContext();
        if (ctx == null) {
            return;
        }
        String ident = x.getName();
        long hash = x.nameHashCode64();
        SQLTableSource tableSource = null;
        if (!(hash != FnvHash.Constants.LEVEL && hash != FnvHash.Constants.CONNECT_BY_ISCYCLE || !(ctx.object instanceof SQLSelectQueryBlock) || (queryBlock = (SQLSelectQueryBlock)ctx.object).getStartWith() == null && queryBlock.getConnectBy() == null)) {
            return;
        }
        SQLTableSource ctxTable = ctx.getTableSource();
        if (ctxTable instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)ctxTable;
            tableSource = join.findTableSourceWithColumn(hash, ident, visitor.getOptions());
            if (tableSource == null) {
                SQLTableSource left = join.getLeft();
                SQLTableSource right = join.getRight();
                if (left instanceof SQLSubqueryTableSource && right instanceof SQLExprTableSource) {
                    boolean hasAllColumn;
                    SQLSelect leftSelect = ((SQLSubqueryTableSource)left).getSelect();
                    if (leftSelect.getQuery() instanceof SQLSelectQueryBlock && !(hasAllColumn = ((SQLSelectQueryBlock)leftSelect.getQuery()).selectItemHasAllColumn())) {
                        tableSource = right;
                    }
                } else if (right instanceof SQLSubqueryTableSource && left instanceof SQLExprTableSource) {
                    boolean hasAllColumn;
                    SQLSelect rightSelect = ((SQLSubqueryTableSource)right).getSelect();
                    if (rightSelect.getQuery() instanceof SQLSelectQueryBlock && !(hasAllColumn = ((SQLSelectQueryBlock)rightSelect.getQuery()).selectItemHasAllColumn())) {
                        tableSource = left;
                    }
                } else if (left instanceof SQLExprTableSource && right instanceof SQLExprTableSource) {
                    SQLExprTableSource leftExprTableSource = (SQLExprTableSource)left;
                    SQLExprTableSource rightExprTableSource = (SQLExprTableSource)right;
                    if (leftExprTableSource.getSchemaObject() != null && rightExprTableSource.getSchemaObject() == null) {
                        tableSource = rightExprTableSource;
                    } else if (rightExprTableSource.getSchemaObject() != null && leftExprTableSource.getSchemaObject() == null) {
                        tableSource = leftExprTableSource;
                    }
                }
            }
        } else if (ctxTable instanceof SQLSubqueryTableSource) {
            tableSource = ctxTable.findTableSourceWithColumn(hash, ident, visitor.getOptions());
        } else if (ctxTable instanceof SQLLateralViewTableSource) {
            tableSource = ctxTable.findTableSourceWithColumn(hash, ident, visitor.getOptions());
            if (tableSource == null) {
                tableSource = ((SQLLateralViewTableSource)ctxTable).getTableSource();
            }
        } else {
            SchemaObject table;
            parentCtx = ctx;
            while (parentCtx != null) {
                SQLCreateProcedureStatement createProc;
                declareItem = parentCtx.findDeclare(hash);
                if (declareItem != null) {
                    x.setResolvedDeclareItem(declareItem);
                    return;
                }
                if (parentCtx.object instanceof SQLBlockStatement) {
                    SQLBlockStatement block = (SQLBlockStatement)parentCtx.object;
                    parameter = block.findParameter(hash);
                    if (parameter != null) {
                        x.setResolvedParameter(parameter);
                        return;
                    }
                } else if (parentCtx.object instanceof SQLCreateProcedureStatement && (parameter = (createProc = (SQLCreateProcedureStatement)parentCtx.object).findParameter(hash)) != null) {
                    x.setResolvedParameter(parameter);
                    return;
                }
                parentCtx = parentCtx.parent;
            }
            tableSource = ctxTable;
            if (tableSource instanceof SQLExprTableSource && (table = ((SQLExprTableSource)tableSource).getSchemaObject()) != null && table.findColumn(hash) == null) {
                SQLCreateTableStatement createStmt = null;
                SQLStatement smt = table.getStatement();
                if (smt instanceof SQLCreateTableStatement) {
                    createStmt = (SQLCreateTableStatement)smt;
                }
                if (createStmt != null && createStmt.getTableElementList().size() > 0) {
                    tableSource = null;
                }
            }
        }
        if (tableSource instanceof SQLExprTableSource) {
            SQLMethodInvokeExpr func;
            SQLExpr expr = ((SQLExprTableSource)tableSource).getExpr();
            if (expr instanceof SQLMethodInvokeExpr && (func = (SQLMethodInvokeExpr)expr).methodNameHashCode64() == FnvHash.Constants.ANN) {
                expr = func.getArguments().get(0);
            }
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
                long identHash = identExpr.nameHashCode64();
                tableSource = SchemaResolveVisitorFactory.unwrapAlias(ctx, tableSource, identHash);
            }
        }
        if (tableSource != null) {
            x.setResolvedTableSource(tableSource);
            SQLColumnDefinition column = tableSource.findColumn(hash);
            if (column != null) {
                x.setResolvedColumn(column);
            }
            if (ctxTable instanceof SQLJoinTableSource) {
                String alias = tableSource.computeAlias();
                if (alias == null || tableSource instanceof SQLWithSubqueryClause.Entry) {
                    return;
                }
                if (visitor.isEnabled(SchemaResolveVisitor.Option.ResolveIdentifierAlias)) {
                    SQLPropertyExpr propertyExpr = new SQLPropertyExpr(new SQLIdentifierExpr(alias), ident, hash);
                    propertyExpr.setResolvedColumn(x.getResolvedColumn());
                    propertyExpr.setResolvedTableSource(x.getResolvedTableSource());
                    SQLUtils.replaceInParent(x, propertyExpr);
                }
            }
        }
        if (x.getResolvedColumn() == null && x.getResolvedTableSource() == null) {
            parentCtx = ctx;
            while (parentCtx != null) {
                SQLCreateProcedureStatement createProc;
                declareItem = parentCtx.findDeclare(hash);
                if (declareItem != null) {
                    x.setResolvedDeclareItem(declareItem);
                    return;
                }
                if (parentCtx.object instanceof SQLBlockStatement) {
                    SQLBlockStatement block = (SQLBlockStatement)parentCtx.object;
                    parameter = block.findParameter(hash);
                    if (parameter != null) {
                        x.setResolvedParameter(parameter);
                        return;
                    }
                } else if (parentCtx.object instanceof SQLCreateProcedureStatement && (parameter = (createProc = (SQLCreateProcedureStatement)parentCtx.object).findParameter(hash)) != null) {
                    x.setResolvedParameter(parameter);
                    return;
                }
                parentCtx = parentCtx.parent;
            }
        }
        if (x.getResolvedColumnObject() == null && ctx.object instanceof SQLSelectQueryBlock) {
            SQLSelectItem selectItem;
            SQLSelectQueryBlock queryBlock2 = (SQLSelectQueryBlock)ctx.object;
            boolean having = false;
            SQLObject current = x;
            for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof SQLSelectGroupByClause && parent.getParent() == queryBlock2) {
                    SQLSelectGroupByClause groupBy = (SQLSelectGroupByClause)parent;
                    if (current != groupBy.getHaving()) break;
                    having = true;
                    break;
                }
                current = parent;
            }
            if (having && (selectItem = queryBlock2.findSelectItem(x.hashCode64())) != null) {
                x.setResolvedColumn(selectItem);
            }
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLPropertyExpr x) {
        SQLTableSource ctxFrom;
        SchemaResolveVisitor.Context ctx = visitor.getContext();
        if (ctx == null) {
            return;
        }
        long owner_hash = 0L;
        SQLExpr ownerObj = x.getOwner();
        if (ownerObj instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr owner = (SQLIdentifierExpr)ownerObj;
            owner_hash = owner.nameHashCode64();
        } else if (ownerObj instanceof SQLPropertyExpr) {
            owner_hash = ((SQLPropertyExpr)ownerObj).hashCode64();
        }
        SQLTableSource tableSource = null;
        SQLTableSource ctxTable = ctx.getTableSource();
        if (ctxTable != null) {
            tableSource = ctxTable.findTableSource(owner_hash);
        }
        if (tableSource == null && (ctxFrom = ctx.getFrom()) != null) {
            tableSource = ctxFrom.findTableSource(owner_hash);
        }
        if (tableSource == null) {
            SchemaResolveVisitor.Context parentCtx = ctx;
            while (parentCtx != null) {
                SQLTableSource parentCtxTable = parentCtx.getTableSource();
                if (parentCtxTable != null) {
                    SQLTableSource ctxFrom2;
                    tableSource = parentCtxTable.findTableSource(owner_hash);
                    if (tableSource == null && (ctxFrom2 = parentCtx.getFrom()) != null) {
                        tableSource = ctxFrom2.findTableSource(owner_hash);
                    }
                    if (tableSource != null) {
                        break;
                    }
                } else {
                    SQLDeclareItem declareItem;
                    SQLMergeStatement mergeStatement;
                    SQLTableSource into;
                    if (parentCtx.object instanceof SQLBlockStatement) {
                        SQLBlockStatement block = (SQLBlockStatement)parentCtx.object;
                        SQLParameter parameter = block.findParameter(owner_hash);
                        if (parameter != null) {
                            x.setResolvedOwnerObject(parameter);
                            return;
                        }
                    } else if (parentCtx.object instanceof SQLMergeStatement && (into = (mergeStatement = (SQLMergeStatement)parentCtx.object).getInto()) instanceof SQLSubqueryTableSource && into.aliasHashCode64() == owner_hash) {
                        x.setResolvedOwnerObject(into);
                    }
                    if ((declareItem = parentCtx.findDeclare(owner_hash)) != null) {
                        SQLObject resolvedObject = declareItem.getResolvedObject();
                        if (!(resolvedObject instanceof SQLCreateProcedureStatement) && !(resolvedObject instanceof SQLCreateFunctionStatement) && !(resolvedObject instanceof SQLTableSource)) break;
                        x.setResolvedOwnerObject(resolvedObject);
                        break;
                    }
                }
                parentCtx = parentCtx.parent;
            }
        }
        if (tableSource != null) {
            x.setResolvedTableSource(tableSource);
            SQLObject column = tableSource.resolveColum(x.nameHashCode64());
            if (column instanceof SQLColumnDefinition) {
                x.setResolvedColumn((SQLColumnDefinition)column);
            } else if (column instanceof SQLSelectItem) {
                x.setResolvedColumn((SQLSelectItem)column);
            }
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLBinaryOpExpr x) {
        SQLExpr right;
        SQLBinaryOperator op = x.getOperator();
        SQLExpr left = x.getLeft();
        if ((op == SQLBinaryOperator.BooleanAnd || op == SQLBinaryOperator.BooleanOr) && left instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)left).getOperator() == op) {
            List<SQLExpr> groupList = SQLBinaryOpExpr.split(x, op);
            for (int i = 0; i < groupList.size(); ++i) {
                SQLExpr item = groupList.get(i);
                item.accept(visitor);
            }
            return;
        }
        if (left != null) {
            if (left instanceof SQLBinaryOpExpr) {
                SchemaResolveVisitorFactory.resolve(visitor, (SQLBinaryOpExpr)left);
            } else {
                left.accept(visitor);
            }
        }
        if ((right = x.getRight()) != null) {
            right.accept(visitor);
        }
    }

    static SQLTableSource unwrapAlias(SchemaResolveVisitor.Context ctx, SQLTableSource tableSource, long identHash) {
        SQLTableSource found;
        if (ctx == null) {
            return tableSource;
        }
        if (ctx.object instanceof SQLDeleteStatement && (ctx.getTableSource() == null || tableSource == ctx.getTableSource()) && ctx.getFrom() != null && (found = ctx.getFrom().findTableSource(identHash)) != null) {
            return found;
        }
        SchemaResolveVisitor.Context parentCtx = ctx;
        while (parentCtx != null) {
            SQLWithSubqueryClause.Entry entry;
            SQLWithSubqueryClause with = null;
            if (parentCtx.object instanceof SQLSelect) {
                SQLSelect select = (SQLSelect)parentCtx.object;
                with = select.getWithSubQuery();
            } else if (parentCtx.object instanceof SQLDeleteStatement) {
                SQLDeleteStatement delete = (SQLDeleteStatement)parentCtx.object;
                with = delete.getWith();
            } else if (parentCtx.object instanceof SQLInsertStatement) {
                SQLInsertStatement insertStmt = (SQLInsertStatement)parentCtx.object;
                with = insertStmt.getWith();
            } else if (parentCtx.object instanceof SQLUpdateStatement) {
                SQLUpdateStatement updateStmt = (SQLUpdateStatement)parentCtx.object;
                with = updateStmt.getWith();
            }
            if (with != null && (entry = with.findEntry(identHash)) != null) {
                return entry;
            }
            parentCtx = parentCtx.parent;
        }
        return tableSource;
    }

    static void resolve(SchemaResolveVisitor visitor, SQLSelectQueryBlock x) {
        List<SQLSelectOrderByItem> list;
        List<SQLSelectOrderByItem> list2;
        int n;
        SQLOrderBy orderBy;
        List<SQLWindow> windows;
        SQLSelectGroupByClause groupBy;
        SQLExpr connectBy;
        SQLExpr startWith;
        SQLExpr where;
        HiveMultiInsertStatement insert;
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        if (ctx != null && ctx.level >= 32) {
            return;
        }
        SQLTableSource from = x.getFrom();
        if (from != null) {
            ctx.setTableSource(from);
            Class<?> fromClass = from.getClass();
            if (fromClass == SQLExprTableSource.class) {
                visitor.visit((SQLExprTableSource)from);
            } else {
                from.accept(visitor);
            }
        } else if (x.getParent() != null && x.getParent().getParent() instanceof HiveInsert && x.getParent().getParent().getParent() instanceof HiveMultiInsertStatement && (insert = (HiveMultiInsertStatement)x.getParent().getParent().getParent()).getFrom() instanceof SQLExprTableSource) {
            from = insert.getFrom();
            ctx.setTableSource(from);
        }
        List<SQLSelectItem> selectList = x.getSelectList();
        ArrayList<SQLSelectItem> columns = new ArrayList<SQLSelectItem>();
        for (int i = selectList.size() - 1; i >= 0; --i) {
            SQLSelectItem selectItem = selectList.get(i);
            SQLExpr expr = selectItem.getExpr();
            if (expr instanceof SQLAllColumnExpr) {
                SQLAllColumnExpr allColumnExpr = (SQLAllColumnExpr)expr;
                allColumnExpr.setResolvedTableSource(from);
                visitor.visit(allColumnExpr);
                if (visitor.isEnabled(SchemaResolveVisitor.Option.ResolveAllColumn)) {
                    SchemaResolveVisitorFactory.extractColumns(visitor, from, null, columns);
                }
            } else if (expr instanceof SQLPropertyExpr) {
                SQLColumnDefinition column;
                SQLPropertyExpr propertyExpr = (SQLPropertyExpr)expr;
                visitor.visit(propertyExpr);
                String ownerName = propertyExpr.getOwnernName();
                if (propertyExpr.getName().equals("*") && visitor.isEnabled(SchemaResolveVisitor.Option.ResolveAllColumn)) {
                    SQLTableSource tableSource = x.findTableSource(ownerName);
                    SchemaResolveVisitorFactory.extractColumns(visitor, tableSource, ownerName, columns);
                }
                if ((column = propertyExpr.getResolvedColumn()) != null) continue;
                SQLTableSource tableSource = x.findTableSource(propertyExpr.getOwnernName());
                if (tableSource != null && (column = tableSource.findColumn(propertyExpr.nameHashCode64())) != null) {
                    propertyExpr.setResolvedColumn(column);
                }
            } else if (expr instanceof SQLIdentifierExpr) {
                Iterator identExpr = (SQLIdentifierExpr)expr;
                visitor.visit((SQLIdentifierExpr)((Object)identExpr));
                long name_hash = ((SQLIdentifierExpr)((Object)identExpr)).nameHashCode64();
                Object column = ((SQLIdentifierExpr)((Object)identExpr)).getResolvedColumn();
                if (column != null || from == null) continue;
                column = from.findColumn(name_hash);
                if (column != null) {
                    ((SQLIdentifierExpr)((Object)identExpr)).setResolvedColumn((SQLColumnDefinition)column);
                }
            } else {
                expr.accept(visitor);
            }
            if (columns.size() <= 0) continue;
            for (SQLSelectItem column : columns) {
                column.setParent(x);
                column.getExpr().accept(visitor);
            }
            selectList.remove(i);
            selectList.addAll(i, columns);
            columns.clear();
        }
        SQLExprTableSource into = x.getInto();
        if (into != null) {
            visitor.visit(into);
        }
        if ((where = x.getWhere()) != null) {
            if (where instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)where;
                SchemaResolveVisitorFactory.resolveExpr(visitor, binaryOpExpr.getLeft());
                SchemaResolveVisitorFactory.resolveExpr(visitor, binaryOpExpr.getRight());
            } else if (where instanceof SQLBinaryOpExprGroup) {
                SQLBinaryOpExprGroup binaryOpExprGroup = (SQLBinaryOpExprGroup)where;
                for (SQLExpr item : binaryOpExprGroup.getItems()) {
                    if (item instanceof SQLBinaryOpExpr) {
                        SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)item;
                        SchemaResolveVisitorFactory.resolveExpr(visitor, binaryOpExpr.getLeft());
                        SchemaResolveVisitorFactory.resolveExpr(visitor, binaryOpExpr.getRight());
                        continue;
                    }
                    item.accept(visitor);
                }
            } else {
                where.accept(visitor);
            }
        }
        if ((startWith = x.getStartWith()) != null) {
            startWith.accept(visitor);
        }
        if ((connectBy = x.getConnectBy()) != null) {
            connectBy.accept(visitor);
        }
        if ((groupBy = x.getGroupBy()) != null) {
            groupBy.accept(visitor);
        }
        if ((windows = x.getWindows()) != null) {
            for (SQLWindow sQLWindow : windows) {
                sQLWindow.accept(visitor);
            }
        }
        if ((orderBy = x.getOrderBy()) != null) {
            for (SQLSelectOrderByItem sQLSelectOrderByItem : orderBy.getItems()) {
                SQLIdentifierExpr orderByItemIdentExpr;
                long hash;
                SQLSelectItem selectItem;
                SQLExpr sQLExpr = sQLSelectOrderByItem.getExpr();
                if (sQLExpr instanceof SQLIdentifierExpr && (selectItem = x.findSelectItem(hash = (orderByItemIdentExpr = (SQLIdentifierExpr)sQLExpr).nameHashCode64())) != null) {
                    sQLSelectOrderByItem.setResolvedSelectItem(selectItem);
                    SQLExpr selectItemExpr = selectItem.getExpr();
                    if (selectItemExpr instanceof SQLIdentifierExpr) {
                        orderByItemIdentExpr.setResolvedTableSource(((SQLIdentifierExpr)selectItemExpr).getResolvedTableSource());
                        orderByItemIdentExpr.setResolvedColumn(((SQLIdentifierExpr)selectItemExpr).getResolvedColumn());
                        continue;
                    }
                    if (!(selectItemExpr instanceof SQLPropertyExpr)) continue;
                    orderByItemIdentExpr.setResolvedTableSource(((SQLPropertyExpr)selectItemExpr).getResolvedTableSource());
                    orderByItemIdentExpr.setResolvedColumn(((SQLPropertyExpr)selectItemExpr).getResolvedColumn());
                    continue;
                }
                sQLExpr.accept(visitor);
            }
        }
        if ((n = x.getForUpdateOfSize()) > 0) {
            for (SQLExpr sQLExpr : x.getForUpdateOf()) {
                sQLExpr.accept(visitor);
            }
        }
        if ((list2 = x.getDistributeBy()) != null) {
            for (SQLSelectOrderByItem item : list2) {
                item.accept(visitor);
            }
        }
        if ((list = x.getSortBy()) != null) {
            for (SQLSelectOrderByItem item : list) {
                item.accept(visitor);
            }
        }
        visitor.popContext();
    }

    static void extractColumns(SchemaResolveVisitor visitor, SQLTableSource from, String ownerName, List<SQLSelectItem> columns) {
        block20: {
            block19: {
                SQLTableSource resolvedTableSource;
                if (!(from instanceof SQLExprTableSource)) break block19;
                SQLExpr expr = ((SQLExprTableSource)from).getExpr();
                SchemaRepository repository = visitor.getRepository();
                if (repository == null) {
                    return;
                }
                String alias = from.getAlias();
                SchemaObject table = repository.findTable((SQLExprTableSource)from);
                if (table != null) {
                    SQLCreateTableStatement createTableStmt = (SQLCreateTableStatement)table.getStatement();
                    for (SQLTableElement e : createTableStmt.getTableElementList()) {
                        SQLExprImpl name;
                        if (!(e instanceof SQLColumnDefinition)) continue;
                        SQLColumnDefinition column = (SQLColumnDefinition)e;
                        if (alias != null) {
                            name = new SQLPropertyExpr(alias, column.getName().getSimpleName());
                            ((SQLPropertyExpr)name).setResolvedColumn(column);
                            columns.add(new SQLSelectItem(name));
                            continue;
                        }
                        if (ownerName != null) {
                            name = new SQLPropertyExpr(ownerName, column.getName().getSimpleName());
                            ((SQLPropertyExpr)name).setResolvedColumn(column);
                            columns.add(new SQLSelectItem(name));
                            continue;
                        }
                        if (from.getParent() instanceof SQLJoinTableSource && from instanceof SQLExprTableSource && expr instanceof SQLName) {
                            String tableName = expr.toString();
                            SQLPropertyExpr name2 = new SQLPropertyExpr(tableName, column.getName().getSimpleName());
                            name2.setResolvedColumn(column);
                            columns.add(new SQLSelectItem(name2));
                            continue;
                        }
                        name = (SQLIdentifierExpr)column.getName().clone();
                        ((SQLIdentifierExpr)name).setResolvedColumn(column);
                        columns.add(new SQLSelectItem(name));
                    }
                    return;
                }
                if (!(expr instanceof SQLIdentifierExpr) || !((resolvedTableSource = ((SQLIdentifierExpr)expr).getResolvedTableSource()) instanceof SQLWithSubqueryClause.Entry)) break block20;
                SQLWithSubqueryClause.Entry entry = (SQLWithSubqueryClause.Entry)resolvedTableSource;
                SQLSelect select = ((SQLWithSubqueryClause.Entry)resolvedTableSource).getSubQuery();
                SQLSelectQueryBlock firstQueryBlock = select.getFirstQueryBlock();
                if (firstQueryBlock != null) {
                    for (SQLSelectItem item : firstQueryBlock.getSelectList()) {
                        String itemAlias = item.computeAlias();
                        if (itemAlias == null) continue;
                        SQLIdentifierExpr columnExpr = new SQLIdentifierExpr(itemAlias);
                        columnExpr.setResolvedColumn(item);
                        columns.add(new SQLSelectItem(columnExpr));
                    }
                }
                break block20;
            }
            if (from instanceof SQLJoinTableSource) {
                SQLJoinTableSource join = (SQLJoinTableSource)from;
                SchemaResolveVisitorFactory.extractColumns(visitor, join.getLeft(), ownerName, columns);
                SchemaResolveVisitorFactory.extractColumns(visitor, join.getRight(), ownerName, columns);
            } else if (from instanceof SQLSubqueryTableSource) {
                SQLSelectQueryBlock subQuery = ((SQLSubqueryTableSource)from).getSelect().getQueryBlock();
                if (subQuery == null) {
                    return;
                }
                List<SQLSelectItem> subSelectList = subQuery.getSelectList();
                for (SQLSelectItem subSelectItem : subSelectList) {
                    if (subSelectItem.getAlias() != null || subSelectItem.getExpr() instanceof SQLName) continue;
                    return;
                }
                for (SQLSelectItem subSelectItem : subSelectList) {
                    String alias = subSelectItem.computeAlias();
                    columns.add(new SQLSelectItem(new SQLIdentifierExpr(alias)));
                }
            } else if (from instanceof SQLUnionQueryTableSource) {
                SQLSelectQueryBlock firstQueryBlock = ((SQLUnionQueryTableSource)from).getUnion().getFirstQueryBlock();
                if (firstQueryBlock == null) {
                    return;
                }
                List<SQLSelectItem> subSelectList = firstQueryBlock.getSelectList();
                for (SQLSelectItem subSelectItem : subSelectList) {
                    if (subSelectItem.getAlias() != null || subSelectItem.getExpr() instanceof SQLName) continue;
                    return;
                }
                for (SQLSelectItem subSelectItem : subSelectList) {
                    String alias = subSelectItem.computeAlias();
                    columns.add(new SQLSelectItem(new SQLIdentifierExpr(alias)));
                }
            }
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLAllColumnExpr x) {
        SQLTableSource resolvedTableSource;
        SQLExpr expr;
        SQLTableSource tableSource = x.getResolvedTableSource();
        if (tableSource == null) {
            SQLSelectQueryBlock queryBlock = null;
            for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof SQLTableSource) {
                    return;
                }
                if (!(parent instanceof SQLSelectQueryBlock)) continue;
                queryBlock = (SQLSelectQueryBlock)parent;
                break;
            }
            if (queryBlock == null) {
                return;
            }
            SQLTableSource from = queryBlock.getFrom();
            if (from == null || from instanceof SQLJoinTableSource) {
                return;
            }
            x.setResolvedTableSource(from);
            tableSource = from;
        }
        if (tableSource instanceof SQLExprTableSource && (expr = ((SQLExprTableSource)tableSource).getExpr()) instanceof SQLIdentifierExpr && (resolvedTableSource = ((SQLIdentifierExpr)expr).getResolvedTableSource()) != null) {
            x.setResolvedTableSource(resolvedTableSource);
        }
    }

    static void resolve(SchemaResolveVisitor v, SQLMethodInvokeExpr x) {
        SQLDataType dataType;
        SQLExpr _for;
        SQLExpr using;
        SQLExpr owner = x.getOwner();
        if (owner != null) {
            SchemaResolveVisitorFactory.resolveExpr(v, owner);
        }
        for (SQLExpr arg : x.getArguments()) {
            SchemaResolveVisitorFactory.resolveExpr(v, arg);
        }
        SQLExpr from = x.getFrom();
        if (from != null) {
            SchemaResolveVisitorFactory.resolveExpr(v, from);
        }
        if ((using = x.getUsing()) != null) {
            SchemaResolveVisitorFactory.resolveExpr(v, using);
        }
        if ((_for = x.getFor()) != null) {
            SchemaResolveVisitorFactory.resolveExpr(v, _for);
        }
        long nameHash = x.methodNameHashCode64();
        SchemaRepository repository = v.getRepository();
        if (repository != null && (dataType = repository.findFuntionReturnType(nameHash)) != null) {
            x.setResolvedReturnDataType(dataType);
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLSelect x) {
        SQLSelectQuery query;
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLWithSubqueryClause with = x.getWithSubQuery();
        if (with != null) {
            visitor.visit(with);
        }
        if ((query = x.getQuery()) != null) {
            if (query instanceof SQLSelectQueryBlock) {
                visitor.visit((SQLSelectQueryBlock)query);
            } else {
                query.accept(visitor);
            }
        }
        SQLSelectQueryBlock queryBlock = x.getFirstQueryBlock();
        SQLOrderBy orderBy = x.getOrderBy();
        if (orderBy != null) {
            for (SQLSelectOrderByItem orderByItem : orderBy.getItems()) {
                SQLExpr orderByItemExpr = orderByItem.getExpr();
                if (orderByItemExpr instanceof SQLIdentifierExpr) {
                    SQLIdentifierExpr orderByItemIdentExpr = (SQLIdentifierExpr)orderByItemExpr;
                    long hash = orderByItemIdentExpr.nameHashCode64();
                    SQLSelectItem selectItem = null;
                    if (queryBlock != null) {
                        selectItem = queryBlock.findSelectItem(hash);
                    }
                    if (selectItem != null) {
                        orderByItem.setResolvedSelectItem(selectItem);
                        SQLExpr selectItemExpr = selectItem.getExpr();
                        if (selectItemExpr instanceof SQLIdentifierExpr) {
                            orderByItemIdentExpr.setResolvedTableSource(((SQLIdentifierExpr)selectItemExpr).getResolvedTableSource());
                            orderByItemIdentExpr.setResolvedColumn(((SQLIdentifierExpr)selectItemExpr).getResolvedColumn());
                            continue;
                        }
                        if (!(selectItemExpr instanceof SQLPropertyExpr)) continue;
                        orderByItemIdentExpr.setResolvedTableSource(((SQLPropertyExpr)selectItemExpr).getResolvedTableSource());
                        orderByItemIdentExpr.setResolvedColumn(((SQLPropertyExpr)selectItemExpr).getResolvedColumn());
                        continue;
                    }
                }
                orderByItemExpr.accept(visitor);
            }
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLWithSubqueryClause x) {
        List<SQLWithSubqueryClause.Entry> entries = x.getEntries();
        SchemaResolveVisitor.Context context = visitor.getContext();
        for (SQLWithSubqueryClause.Entry entry : entries) {
            SQLSelect query = entry.getSubQuery();
            if (query != null) {
                visitor.visit(query);
                long alias_hash = entry.aliasHashCode64();
                if (context == null || alias_hash == 0L) continue;
                context.addTableSource(alias_hash, entry);
                continue;
            }
            entry.getReturningStatement().accept(visitor);
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLExprTableSource x) {
        SQLMethodInvokeExpr func;
        SQLExpr expr = x.getExpr();
        SQLExpr annFeature = null;
        if (expr instanceof SQLMethodInvokeExpr && (func = (SQLMethodInvokeExpr)expr).methodNameHashCode64() == FnvHash.Constants.ANN) {
            expr = func.getArguments().get(0);
            annFeature = func.getArguments().get(1);
            if (annFeature instanceof SQLIdentifierExpr) {
                ((SQLIdentifierExpr)annFeature).setResolvedTableSource(x);
            } else if (annFeature instanceof SQLPropertyExpr) {
                ((SQLPropertyExpr)annFeature).setResolvedTableSource(x);
            }
        }
        if (expr instanceof SQLName) {
            SchemaRepository repository;
            SQLExpr owner;
            if (x.getSchemaObject() != null) {
                return;
            }
            SQLIdentifierExpr identifierExpr = null;
            if (expr instanceof SQLIdentifierExpr) {
                identifierExpr = (SQLIdentifierExpr)expr;
            } else if (expr instanceof SQLPropertyExpr && (owner = ((SQLPropertyExpr)expr).getOwner()) instanceof SQLIdentifierExpr) {
                identifierExpr = (SQLIdentifierExpr)owner;
            }
            if (identifierExpr != null) {
                SQLWithSubqueryClause with;
                SchemaResolveVisitorFactory.checkParameter(visitor, identifierExpr);
                SQLTableSource tableSource = SchemaResolveVisitorFactory.unwrapAlias(visitor.getContext(), null, identifierExpr.nameHashCode64());
                if (tableSource == null && x.getParent() instanceof HiveMultiInsertStatement && (with = ((HiveMultiInsertStatement)x.getParent()).getWith()) != null) {
                    SQLWithSubqueryClause.Entry entry = with.findEntry(identifierExpr.nameHashCode64());
                    tableSource = entry;
                }
                if (tableSource != null) {
                    identifierExpr.setResolvedTableSource(tableSource);
                    return;
                }
            }
            if ((repository = visitor.getRepository()) != null) {
                SchemaObject table = repository.findTable((SQLName)expr);
                if (table != null) {
                    SQLIdentifierExpr identExpr;
                    SQLColumnDefinition column;
                    x.setSchemaObject(table);
                    if (annFeature != null && annFeature instanceof SQLIdentifierExpr && (column = table.findColumn((identExpr = (SQLIdentifierExpr)annFeature).nameHashCode64())) != null) {
                        identExpr.setResolvedColumn(column);
                    }
                    return;
                }
                SchemaObject view = repository.findView((SQLName)expr);
                if (view != null) {
                    x.setSchemaObject(view);
                    return;
                }
            }
            return;
        }
        if (expr instanceof SQLMethodInvokeExpr) {
            visitor.visit((SQLMethodInvokeExpr)expr);
            return;
        }
        if (expr instanceof SQLQueryExpr) {
            SQLSelect select = ((SQLQueryExpr)expr).getSubQuery();
            visitor.visit(select);
            SQLSelectQueryBlock queryBlock = select.getQueryBlock();
            if (queryBlock != null && annFeature instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr identExpr = (SQLIdentifierExpr)annFeature;
                SQLObject columnDef = queryBlock.resolveColum(identExpr.nameHashCode64());
                if (columnDef instanceof SQLColumnDefinition) {
                    identExpr.setResolvedColumn((SQLColumnDefinition)columnDef);
                } else if (columnDef instanceof SQLSelectItem) {
                    identExpr.setResolvedColumn((SQLSelectItem)columnDef);
                }
            }
            return;
        }
        expr.accept(visitor);
    }

    static void resolve(SchemaResolveVisitor visitor, SQLAlterTableStatement x) {
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLExprTableSource tableSource = x.getTableSource();
        ctx.setTableSource(tableSource);
        for (SQLAlterTableItem item : x.getItems()) {
            item.accept(visitor);
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLMergeStatement x) {
        SQLMergeStatement.MergeInsertClause insertClause;
        SQLMergeStatement.MergeUpdateClause updateClause;
        SQLExpr on;
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLTableSource into = x.getInto();
        if (into instanceof SQLExprTableSource) {
            ctx.setTableSource(into);
        } else {
            into.accept(visitor);
        }
        SQLTableSource using = x.getUsing();
        if (using != null) {
            using.accept(visitor);
            ctx.setFrom(using);
        }
        if ((on = x.getOn()) != null) {
            on.accept(visitor);
        }
        if ((updateClause = x.getUpdateClause()) != null) {
            Iterator<SQLExpr> deleteWhere;
            for (SQLUpdateSetItem item : updateClause.getItems()) {
                SQLExpr value;
                SQLExpr column = item.getColumn();
                if (column instanceof SQLIdentifierExpr) {
                    ((SQLIdentifierExpr)column).setResolvedTableSource(into);
                } else if (column instanceof SQLPropertyExpr) {
                    ((SQLPropertyExpr)column).setResolvedTableSource(into);
                } else {
                    column.accept(visitor);
                }
                if ((value = item.getValue()) == null) continue;
                value.accept(visitor);
            }
            SQLExpr where = updateClause.getWhere();
            if (where != null) {
                where.accept(visitor);
            }
            if ((deleteWhere = updateClause.getDeleteWhere()) != null) {
                deleteWhere.accept(visitor);
            }
        }
        if ((insertClause = x.getInsertClause()) != null) {
            for (SQLExpr column : insertClause.getColumns()) {
                if (column instanceof SQLIdentifierExpr) {
                    ((SQLIdentifierExpr)column).setResolvedTableSource(into);
                } else if (column instanceof SQLPropertyExpr) {
                    ((SQLPropertyExpr)column).setResolvedTableSource(into);
                }
                column.accept(visitor);
            }
            for (SQLExpr value : insertClause.getValues()) {
                value.accept(visitor);
            }
            SQLExpr where = insertClause.getWhere();
            if (where != null) {
                where.accept(visitor);
            }
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLCreateFunctionStatement x) {
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLDeclareItem declareItem = new SQLDeclareItem(x.getName().clone(), null);
        declareItem.setResolvedObject(x);
        SchemaResolveVisitor.Context parentCtx = visitor.getContext();
        if (parentCtx != null) {
            parentCtx.declare(declareItem);
        } else {
            ctx.declare(declareItem);
        }
        for (SQLParameter parameter : x.getParameters()) {
            parameter.accept(visitor);
        }
        SQLStatement block = x.getBlock();
        if (block != null) {
            block.accept(visitor);
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLCreateProcedureStatement x) {
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLDeclareItem declareItem = new SQLDeclareItem(x.getName().clone(), null);
        declareItem.setResolvedObject(x);
        SchemaResolveVisitor.Context parentCtx = visitor.getContext();
        if (parentCtx != null) {
            parentCtx.declare(declareItem);
        } else {
            ctx.declare(declareItem);
        }
        for (SQLParameter parameter : x.getParameters()) {
            parameter.accept(visitor);
        }
        SQLStatement block = x.getBlock();
        if (block != null) {
            block.accept(visitor);
        }
        visitor.popContext();
    }

    static boolean resolve(SchemaResolveVisitor visitor, SQLIfStatement x) {
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLExpr condition = x.getCondition();
        if (condition != null) {
            condition.accept(visitor);
        }
        for (SQLStatement stmt : x.getStatements()) {
            stmt.accept(visitor);
        }
        for (SQLIfStatement.ElseIf elseIf : x.getElseIfList()) {
            elseIf.accept(visitor);
        }
        SQLIfStatement.Else e = x.getElseItem();
        if (e != null) {
            e.accept(visitor);
        }
        visitor.popContext();
        return false;
    }

    static void resolve(SchemaResolveVisitor visitor, SQLBlockStatement x) {
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        for (SQLParameter parameter : x.getParameters()) {
            visitor.visit(parameter);
        }
        for (SQLStatement stmt : x.getStatementList()) {
            stmt.accept(visitor);
        }
        SQLStatement exception = x.getException();
        if (exception != null) {
            exception.accept(visitor);
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLParameter x) {
        SQLName name = x.getName();
        if (name instanceof SQLIdentifierExpr) {
            ((SQLIdentifierExpr)name).setResolvedParameter(x);
        }
        SQLExpr expr = x.getDefaultValue();
        SchemaResolveVisitor.Context ctx = null;
        if (expr != null) {
            if (expr instanceof SQLQueryExpr) {
                ctx = visitor.createContext(x);
                SQLSubqueryTableSource tableSource = new SQLSubqueryTableSource(((SQLQueryExpr)expr).getSubQuery());
                tableSource.setParent(x);
                tableSource.setAlias(x.getName().getSimpleName());
                ctx.setTableSource(tableSource);
            }
            expr.accept(visitor);
        }
        if (ctx != null) {
            visitor.popContext();
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLDeclareItem x) {
        SQLName name;
        SchemaResolveVisitor.Context ctx = visitor.getContext();
        if (ctx != null) {
            ctx.declare(x);
        }
        if ((name = x.getName()) instanceof SQLIdentifierExpr) {
            ((SQLIdentifierExpr)name).setResolvedDeclareItem(x);
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLOver x) {
        SQLName of = x.getOf();
        SQLOrderBy orderBy = x.getOrderBy();
        List<SQLExpr> partitionBy = x.getPartitionBy();
        if (of == null && orderBy != null) {
            orderBy.accept(visitor);
        }
        if (partitionBy != null) {
            for (SQLExpr expr : partitionBy) {
                expr.accept(visitor);
            }
        }
    }

    private static boolean checkParameter(SchemaResolveVisitor visitor, SQLIdentifierExpr x) {
        if (x.getResolvedParameter() != null) {
            return true;
        }
        SchemaResolveVisitor.Context ctx = visitor.getContext();
        if (ctx == null) {
            return false;
        }
        long hash = x.hashCode64();
        SchemaResolveVisitor.Context parentCtx = ctx;
        while (parentCtx != null) {
            SQLDeclareItem declareItem;
            SQLCreateProcedureStatement createProc;
            SQLBlockStatement block;
            SQLParameter parameter;
            if (parentCtx.object instanceof SQLBlockStatement && (parameter = (block = (SQLBlockStatement)parentCtx.object).findParameter(hash)) != null) {
                x.setResolvedParameter(parameter);
                return true;
            }
            if (parentCtx.object instanceof SQLCreateProcedureStatement && (parameter = (createProc = (SQLCreateProcedureStatement)parentCtx.object).findParameter(hash)) != null) {
                x.setResolvedParameter(parameter);
                return true;
            }
            if (parentCtx.object instanceof SQLSelect) {
                SchemaObject view;
                SQLWithSubqueryClause.Entry entry;
                SQLSelect select = (SQLSelect)parentCtx.object;
                SQLWithSubqueryClause with = select.getWithSubQuery();
                if (with != null && (entry = with.findEntry(hash)) != null) {
                    x.setResolvedTableSource(entry);
                    return true;
                }
                SchemaRepository repo = visitor.getRepository();
                if (repo != null && (view = repo.findView(x)) != null && view.getStatement() instanceof SQLCreateViewStatement) {
                    x.setResolvedOwnerObject(view.getStatement());
                }
            }
            if ((declareItem = parentCtx.findDeclare(hash)) != null) {
                x.setResolvedDeclareItem(declareItem);
                break;
            }
            parentCtx = parentCtx.parent;
        }
        return false;
    }

    static void resolve(SchemaResolveVisitor visitor, SQLReplaceStatement x) {
        SchemaResolveVisitor.Context ctx = visitor.createContext(x);
        SQLExprTableSource tableSource = x.getTableSource();
        ctx.setTableSource(tableSource);
        visitor.visit(tableSource);
        for (SQLExpr column : x.getColumns()) {
            column.accept(visitor);
        }
        SQLQueryExpr queryExpr = x.getQuery();
        if (queryExpr != null) {
            visitor.visit(queryExpr.getSubQuery());
        }
        visitor.popContext();
    }

    static void resolve(SchemaResolveVisitor visitor, SQLFetchStatement x) {
        SchemaResolveVisitorFactory.resolveExpr(visitor, x.getCursorName());
        for (SQLExpr expr : x.getInto()) {
            SchemaResolveVisitorFactory.resolveExpr(visitor, expr);
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLForeignKeyConstraint x) {
        SQLIdentifierExpr columnName;
        Object table;
        SchemaRepository repository = visitor.getRepository();
        SQLObject parent = x.getParent();
        if (parent instanceof SQLCreateTableStatement) {
            SQLCreateTableStatement createTableStmt = (SQLCreateTableStatement)parent;
            table = createTableStmt.getTableSource();
            for (SQLName item : x.getReferencingColumns()) {
                columnName = (SQLIdentifierExpr)item;
                columnName.setResolvedTableSource((SQLTableSource)table);
                SQLColumnDefinition column = createTableStmt.findColumn(columnName.nameHashCode64());
                if (column == null) continue;
                columnName.setResolvedColumn(column);
            }
        } else if (parent instanceof SQLAlterTableAddConstraint) {
            SQLAlterTableStatement stmt = (SQLAlterTableStatement)parent.getParent();
            table = stmt.getTableSource();
            for (SQLName item : x.getReferencingColumns()) {
                columnName = (SQLIdentifierExpr)item;
                columnName.setResolvedTableSource((SQLTableSource)table);
            }
        }
        if (repository == null) {
            return;
        }
        SQLExprTableSource table2 = x.getReferencedTable();
        for (SQLName item : x.getReferencedColumns()) {
            SQLIdentifierExpr columnName2 = (SQLIdentifierExpr)item;
            columnName2.setResolvedTableSource(table2);
        }
        SQLName tableName = table2.getName();
        SchemaObject tableObject = repository.findTable(tableName);
        if (tableObject == null) {
            return;
        }
        SQLStatement tableStmt = tableObject.getStatement();
        if (tableStmt instanceof SQLCreateTableStatement) {
            SQLCreateTableStatement refCreateTableStmt = (SQLCreateTableStatement)tableStmt;
            for (SQLName item : x.getReferencedColumns()) {
                SQLIdentifierExpr columnName3 = (SQLIdentifierExpr)item;
                SQLColumnDefinition column = refCreateTableStmt.findColumn(columnName3.nameHashCode64());
                if (column == null) continue;
                columnName3.setResolvedColumn(column);
            }
        }
    }

    static void resolve(SchemaResolveVisitor visitor, SQLCreateViewStatement x) {
        x.getSubQuery().accept(visitor);
    }

    static void resolveExpr(SchemaResolveVisitor visitor, SQLExpr x) {
        if (x == null) {
            return;
        }
        Class<?> clazz = x.getClass();
        if (clazz == SQLIdentifierExpr.class) {
            visitor.visit((SQLIdentifierExpr)x);
            return;
        }
        if (clazz == SQLIntegerExpr.class || clazz == SQLCharExpr.class) {
            return;
        }
        x.accept(visitor);
    }

    static void resolveUnion(SchemaResolveVisitor visitor, SQLUnionQuery x) {
        boolean bracket;
        SQLUnionOperator operator = x.getOperator();
        List<SQLSelectQuery> relations = x.getRelations();
        if (relations.size() > 2) {
            for (SQLSelectQuery relation : relations) {
                relation.accept(visitor);
            }
            return;
        }
        SQLSelectQuery left = x.getLeft();
        SQLSelectQuery right = x.getRight();
        boolean bl = bracket = x.isBracket() && !(x.getParent() instanceof SQLUnionQueryTableSource);
        if (!bracket && left instanceof SQLUnionQuery && ((SQLUnionQuery)left).getOperator() == operator && !right.isBracket() && x.getOrderBy() == null) {
            SQLUnionQuery leftUnion = (SQLUnionQuery)left;
            ArrayList<SQLSelectQuery> rights = new ArrayList<SQLSelectQuery>();
            rights.add(right);
            if (leftUnion.getRelations().size() > 2) {
                rights.addAll(leftUnion.getRelations());
            } else {
                SQLSelectQuery leftRight;
                SQLSelectQuery leftLeft;
                while (true) {
                    leftLeft = leftUnion.getLeft();
                    leftRight = leftUnion.getRight();
                    if (leftUnion.isBracket() || leftUnion.getOrderBy() != null || leftLeft.isBracket() || leftRight.isBracket() || !(leftLeft instanceof SQLUnionQuery) || ((SQLUnionQuery)leftLeft).getOperator() != operator) break;
                    rights.add(leftRight);
                    leftUnion = (SQLUnionQuery)leftLeft;
                }
                rights.add(leftRight);
                rights.add(leftLeft);
            }
            for (int i = rights.size() - 1; i >= 0; --i) {
                SQLSelectQuery item = (SQLSelectQuery)rights.get(i);
                item.accept(visitor);
            }
            return;
        }
        if (left != null) {
            left.accept(visitor);
        }
        if (right != null) {
            right.accept(visitor);
        }
    }

    static class SQLResolveVisitor
    extends SQLASTVisitorAdapter
    implements SchemaResolveVisitor {
        private int options;
        private SchemaRepository repository;
        private SchemaResolveVisitor.Context context;

        public SQLResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolveIdent(this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }

    static class SQLServerResolveVisitor
    extends SQLServerASTVisitorAdapter
    implements SchemaResolveVisitor {
        private int options;
        private SchemaRepository repository;
        private SchemaResolveVisitor.Context context;

        public SQLServerResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        @Override
        public boolean visit(SQLServerSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolveIdent(this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(SQLServerUpdateStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLServerInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }

    static class PGResolveVisitor
    extends PGASTVisitorAdapter
    implements SchemaResolveVisitor {
        private int options;
        private SchemaRepository repository;
        private SchemaResolveVisitor.Context context;

        public PGResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        @Override
        public boolean visit(PGSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(PGFunctionTableSource x) {
            for (SQLParameter parameter : x.getParameters()) {
                SQLName name = parameter.getName();
                if (!(name instanceof SQLIdentifierExpr)) continue;
                SQLIdentifierExpr identName = (SQLIdentifierExpr)name;
                identName.setResolvedTableSource(x);
            }
            return false;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolveIdent(this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            if (PGUtils.isPseudoColumn(x.nameHashCode64())) {
                return false;
            }
            SchemaResolveVisitorFactory.resolveIdent(this, x);
            return true;
        }

        @Override
        public boolean visit(PGUpdateStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(PGDeleteStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(PGSelectStatement x) {
            this.createContext(x);
            this.visit(x.getSelect());
            this.popContext();
            return false;
        }

        @Override
        public boolean visit(PGInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }

    static class HiveResolveVisitor
    extends HiveASTVisitorAdapter
    implements SchemaResolveVisitor {
        private int options;
        private SchemaRepository repository;
        private SchemaResolveVisitor.Context context;

        public HiveResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        public boolean visit(OdpsSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolveIdent(this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(HiveCreateTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(HiveInsert x) {
            SQLSelect select;
            List<SQLAssignItem> partitions;
            SchemaResolveVisitor.Context ctx = this.createContext(x);
            SQLExprTableSource tableSource = x.getTableSource();
            if (tableSource != null) {
                ctx.setTableSource(x.getTableSource());
                this.visit(tableSource);
            }
            if ((partitions = x.getPartitions()) != null) {
                for (SQLAssignItem item : partitions) {
                    item.accept(this);
                }
            }
            if ((select = x.getQuery()) != null) {
                this.visit(select);
            }
            this.popContext();
            return false;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }

    static class OdpsResolveVisitor
    extends OdpsASTVisitorAdapter
    implements SchemaResolveVisitor {
        private int options;
        private SchemaRepository repository;
        private SchemaResolveVisitor.Context context;

        public OdpsResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        @Override
        public boolean visit(OdpsSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolveIdent(this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(OdpsCreateTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(HiveInsert x) {
            SQLSelect select;
            List<SQLAssignItem> partitions;
            SchemaResolveVisitor.Context ctx = this.createContext(x);
            SQLExprTableSource tableSource = x.getTableSource();
            if (tableSource != null) {
                ctx.setTableSource(x.getTableSource());
                this.visit(tableSource);
            }
            if ((partitions = x.getPartitions()) != null) {
                for (SQLAssignItem item : partitions) {
                    item.accept(this);
                }
            }
            if ((select = x.getQuery()) != null) {
                this.visit(select);
            }
            this.popContext();
            return false;
        }

        @Override
        public boolean visit(HiveInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }

    static class OracleResolveVisitor
    extends OracleASTVisitorAdapter
    implements SchemaResolveVisitor {
        private SchemaRepository repository;
        private int options;
        private SchemaResolveVisitor.Context context;

        public OracleResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        @Override
        public boolean visit(OracleCreatePackageStatement x) {
            SchemaResolveVisitor.Context ctx = this.createContext(x);
            for (SQLStatement stmt : x.getStatements()) {
                stmt.accept(this);
            }
            this.popContext();
            return false;
        }

        @Override
        public boolean visit(OracleForStatement x) {
            SchemaResolveVisitor.Context ctx = this.createContext(x);
            SQLName index = x.getIndex();
            SQLExpr range = x.getRange();
            if (index != null) {
                SQLDeclareItem declareItem = new SQLDeclareItem(index, null);
                declareItem.setParent(x);
                if (index instanceof SQLIdentifierExpr) {
                    ((SQLIdentifierExpr)index).setResolvedDeclareItem(declareItem);
                }
                declareItem.setResolvedObject(range);
                ctx.declare(declareItem);
                if (range instanceof SQLQueryExpr) {
                    SQLSelect select = ((SQLQueryExpr)range).getSubQuery();
                    SQLSubqueryTableSource tableSource = new SQLSubqueryTableSource(select);
                    declareItem.setResolvedObject(tableSource);
                }
                index.accept(this);
            }
            if (range != null) {
                range.accept(this);
            }
            for (SQLStatement stmt : x.getStatements()) {
                stmt.accept(this);
            }
            this.popContext();
            return false;
        }

        @Override
        public boolean visit(OracleForeignKey x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(OracleSelectTableReference x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(OracleSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolveIdent(this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            if (x.nameHashCode64() == FnvHash.Constants.ROWNUM) {
                return false;
            }
            SchemaResolveVisitorFactory.resolveIdent(this, x);
            return true;
        }

        @Override
        public boolean visit(OracleCreateTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(OracleUpdateStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(OracleDeleteStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(OracleMultiInsertStatement x) {
            SchemaResolveVisitor.Context ctx = this.createContext(x);
            SQLSelect select = x.getSubQuery();
            this.visit(select);
            OracleSelectSubqueryTableSource tableSource = new OracleSelectSubqueryTableSource(select);
            tableSource.setParent(x);
            ctx.setTableSource(tableSource);
            for (OracleMultiInsertStatement.Entry entry : x.getEntries()) {
                entry.accept(this);
            }
            this.popContext();
            return false;
        }

        @Override
        public boolean visit(OracleMultiInsertStatement.InsertIntoClause x) {
            for (SQLExpr column : x.getColumns()) {
                if (!(column instanceof SQLIdentifierExpr)) continue;
                SQLIdentifierExpr identColumn = (SQLIdentifierExpr)column;
                identColumn.setResolvedTableSource(x.getTableSource());
            }
            return true;
        }

        @Override
        public boolean visit(OracleInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }

    static class DB2ResolveVisitor
    extends DB2ASTVisitorAdapter
    implements SchemaResolveVisitor {
        private SchemaRepository repository;
        private int options;
        private SchemaResolveVisitor.Context context;

        public DB2ResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        @Override
        public boolean visit(DB2SelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolveIdent(this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            long hash64 = x.hashCode64();
            if (hash64 == FnvHash.Constants.CURRENT_DATE || hash64 == DB2Object.Constants.CURRENT_TIME) {
                return false;
            }
            SchemaResolveVisitorFactory.resolveIdent(this, x);
            return true;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }

    static class MySqlResolveVisitor
    extends MySqlASTVisitorAdapter
    implements SchemaResolveVisitor {
        private SchemaRepository repository;
        private int options;
        private SchemaResolveVisitor.Context context;

        public MySqlResolveVisitor(SchemaRepository repository, int options) {
            this.repository = repository;
            this.options = options;
        }

        @Override
        public boolean visit(MySqlRepeatStatement x) {
            return true;
        }

        @Override
        public boolean visit(MySqlDeclareStatement x) {
            for (SQLDeclareItem declareItem : x.getVarList()) {
                this.visit(declareItem);
            }
            return false;
        }

        @Override
        public boolean visit(MySqlCursorDeclareStatement x) {
            return true;
        }

        @Override
        public boolean visit(MysqlForeignKey x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(MySqlSelectQueryBlock x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(SQLSelectItem x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SchemaResolveVisitorFactory.resolveIdent(this, (SQLIdentifierExpr)expr);
                return false;
            }
            if (expr instanceof SQLPropertyExpr) {
                SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, (SQLPropertyExpr)expr);
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(MySqlCreateTableStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            SQLExprTableSource like = x.getLike();
            if (like != null) {
                like.accept(this);
            }
            return false;
        }

        @Override
        public boolean visit(MySqlUpdateStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(MySqlDeleteStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean visit(MySqlInsertStatement x) {
            SchemaResolveVisitorFactory.resolve((SchemaResolveVisitor)this, x);
            return false;
        }

        @Override
        public boolean isEnabled(SchemaResolveVisitor.Option option) {
            return (this.options & option.mask) != 0;
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public SchemaResolveVisitor.Context getContext() {
            return this.context;
        }

        @Override
        public SchemaResolveVisitor.Context createContext(SQLObject object) {
            this.context = new SchemaResolveVisitor.Context(object, this.context);
            return this.context;
        }

        @Override
        public void popContext() {
            if (this.context != null) {
                this.context = this.context.parent;
            }
        }

        @Override
        public SchemaRepository getRepository() {
            return this.repository;
        }
    }
}

