/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.alibaba.acm.shaded.org.codehaus.jackson.annotate.JsonProperty;
import com.alibaba.acm.shaded.org.codehaus.jackson.type.TypeReference;
import com.alibaba.middleware.tls.JavaSSLSocketFactory;
import com.alibaba.middleware.tls.util.TlsUtil;
import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.IOUtils;
import com.taobao.diamond.client.impl.Limiter;
import com.taobao.diamond.client.impl.ServerHttpAgent;
import com.taobao.diamond.client.impl.ServerListManager;
import com.taobao.diamond.client.impl.SpasAdapter;
import com.taobao.diamond.config.STSConfig;
import com.taobao.diamond.md5.MD5;
import com.taobao.diamond.utils.EnvUtil;
import com.taobao.diamond.utils.JSONUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HttpSimpleClient {
    static String DIAMOND_CLIENT_VERSION = "unknown";
    static final int DIAMOND_CONNECT_TIMEOUT;
    private static volatile STSCredential stsCredential;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult httpGet(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs, boolean isSSL) throws IOException {
        String encodedContent = HttpSimpleClient.encodingParams(paramValues, encoding);
        url = url + (null == encodedContent ? "" : "?" + encodedContent);
        if (Limiter.isLimit(MD5.getInstance().getMD5String(url + encodedContent))) {
            return new HttpResult(-503, "More than client-side current limit threshold");
        }
        HttpURLConnection conn = null;
        try {
            if (isSSL) {
                TlsUtil.replaceHostnameVerifier();
                SSLSocketFactory ssf = JavaSSLSocketFactory.createJavaSSLSocketFactory(null, null);
                HttpsURLConnection httpsConn = (HttpsURLConnection)new URL(url).openConnection();
                httpsConn.setSSLSocketFactory(ssf);
                conn = httpsConn;
            } else {
                conn = (HttpURLConnection)new URL(url).openConnection();
            }
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(DIAMOND_CONNECT_TIMEOUT > 100 ? DIAMOND_CONNECT_TIMEOUT : 100);
            conn.setReadTimeout((int)readTimeoutMs);
            List<String> newHeaders = HttpSimpleClient.getHeaders(url, headers, paramValues);
            HttpSimpleClient.setHeaders(conn, newHeaders, encoding);
            conn.connect();
            int respCode = conn.getResponseCode();
            String resp = null;
            resp = 200 == respCode ? IOUtils.toString(conn.getInputStream(), encoding) : IOUtils.toString(conn.getErrorStream(), encoding);
            HttpResult httpResult = new HttpResult(respCode, conn.getHeaderFields(), resp);
            return httpResult;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static List<String> getHeaders(String url, List<String> headers, List<String> paramValues) throws IOException {
        List<String> newHeaders = HttpSimpleClient.getSpasHeaders(url, paramValues);
        if (headers != null) {
            newHeaders.addAll(headers);
        }
        newHeaders.add("exConfigInfo");
        newHeaders.add("true");
        return newHeaders;
    }

    private static List<String> getSpasHeaders(String url, List<String> paramValues) throws IOException {
        String secretKey;
        String accessKey;
        ArrayList<String> newHeaders = new ArrayList<String>();
        if (ServerListManager.ADDRESS_SERVER_URL.equals(url)) {
            return newHeaders;
        }
        if (STSConfig.getInstance().isSTSOn()) {
            STSCredential stsCredential = HttpSimpleClient.getSTSCredential();
            accessKey = stsCredential.accessKeyId;
            secretKey = stsCredential.accessKeySecret;
            newHeaders.add("Spas-SecurityToken");
            newHeaders.add(stsCredential.securityToken);
        } else {
            accessKey = SpasAdapter.getAk();
            secretKey = SpasAdapter.getSk();
        }
        newHeaders.add("Spas-AccessKey");
        newHeaders.add(accessKey);
        List<String> signHeaders = SpasAdapter.getSignHeaders(paramValues, secretKey);
        if (signHeaders != null) {
            newHeaders.addAll(signHeaders);
        }
        return newHeaders;
    }

    private static STSCredential getSTSCredential() throws IOException {
        STSCredential stsCredential;
        boolean cacheSecurityCredentials = STSConfig.getInstance().isCacheSecurityCredentials();
        if (cacheSecurityCredentials && HttpSimpleClient.stsCredential != null) {
            int timeToRefreshInMillisecond;
            long currentTime = System.currentTimeMillis();
            long expirationTime = HttpSimpleClient.stsCredential.expiration.getTime();
            if (expirationTime - currentTime > (long)(timeToRefreshInMillisecond = STSConfig.getInstance().getTimeToRefreshInMillisecond())) {
                return HttpSimpleClient.stsCredential;
            }
        }
        String stsResponse = HttpSimpleClient.getSTSResponse();
        HttpSimpleClient.stsCredential = stsCredential = (STSCredential)JSONUtils.deserializeObject(stsResponse, new TypeReference<STSCredential>(){});
        DiamondEnv.log.info("getSTSCredential", "code:{}, accessKeyId:{}, lastUpdated:{}, expiration:{}", stsCredential.getCode(), stsCredential.getAccessKeyId(), stsCredential.getLastUpdated(), stsCredential.getExpiration());
        return stsCredential;
    }

    private static String getSTSResponse() throws IOException {
        String response;
        int respCode;
        String securityCredentials = STSConfig.getInstance().getSecurityCredentials();
        if (securityCredentials != null) {
            return securityCredentials;
        }
        String securityCredentialsUrl = STSConfig.getInstance().getSecurityCredentialsUrl();
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(securityCredentialsUrl).openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(DIAMOND_CONNECT_TIMEOUT > 100 ? DIAMOND_CONNECT_TIMEOUT : 100);
            conn.setReadTimeout(1000);
            conn.connect();
            respCode = conn.getResponseCode();
            String encoding = "UTF-8";
            response = 200 == respCode ? IOUtils.toString(conn.getInputStream(), encoding) : IOUtils.toString(conn.getErrorStream(), encoding);
        }
        catch (IOException e) {
            DiamondEnv.log.error("500", "can not get security credentials", e);
            throw e;
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
        if (200 == respCode) {
            return response;
        }
        DiamondEnv.log.error(respCode + "", "can not get security credentials, securityCredentialsUrl:{}, response:{}", new Object[]{securityCredentialsUrl, response});
        throw new IOException("can not get security credentials, responseCode: " + respCode + ", response: " + response);
    }

    public static HttpResult httpGet(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        return HttpSimpleClient.httpGet(url, headers, paramValues, encoding, readTimeoutMs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult httpPost(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs, boolean isSSL) throws IOException {
        String encodedContent = HttpSimpleClient.encodingParams(paramValues, encoding);
        if (Limiter.isLimit(MD5.getInstance().getMD5String(url + encodedContent))) {
            return new HttpResult(-503, "More than client-side current limit threshold");
        }
        HttpURLConnection conn = null;
        try {
            if (isSSL) {
                TlsUtil.replaceHostnameVerifier();
                SSLSocketFactory ssf = JavaSSLSocketFactory.createJavaSSLSocketFactory(null, null);
                HttpsURLConnection httpsConn = (HttpsURLConnection)new URL(url).openConnection();
                httpsConn.setSSLSocketFactory(ssf);
                conn = httpsConn;
            } else {
                conn = (HttpURLConnection)new URL(url).openConnection();
            }
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(DIAMOND_CONNECT_TIMEOUT > 3000 ? DIAMOND_CONNECT_TIMEOUT : 3000);
            conn.setReadTimeout((int)readTimeoutMs);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            List<String> newHeaders = HttpSimpleClient.getHeaders(url, headers, paramValues);
            HttpSimpleClient.setHeaders(conn, newHeaders, encoding);
            conn.getOutputStream().write(encodedContent.getBytes());
            int respCode = conn.getResponseCode();
            String resp = null;
            resp = 200 == respCode ? IOUtils.toString(conn.getInputStream(), encoding) : IOUtils.toString(conn.getErrorStream(), encoding);
            HttpResult httpResult = new HttpResult(respCode, conn.getHeaderFields(), resp);
            return httpResult;
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
    }

    public static HttpResult httpPost(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        return HttpSimpleClient.httpPost(url, headers, paramValues, encoding, readTimeoutMs, false);
    }

    private static void setHeaders(HttpURLConnection conn, List<String> headers, String encoding) {
        if (null != headers) {
            Iterator<String> iter = headers.iterator();
            while (iter.hasNext()) {
                conn.addRequestProperty(iter.next(), iter.next());
            }
        }
        conn.addRequestProperty("Client-Version", DIAMOND_CLIENT_VERSION);
        conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + encoding);
        String ts = String.valueOf(System.currentTimeMillis());
        String token = MD5.getInstance().getMD5String(ts + ServerHttpAgent.appKey);
        conn.addRequestProperty("Diamond-Client-AppName", ServerHttpAgent.appName);
        conn.addRequestProperty("Diamond-Client-RequestTS", ts);
        conn.addRequestProperty("Diamond-Client-RequestToken", token);
        conn.addRequestProperty("Amory-Tag", EnvUtil.getSelfAmorayTag());
        conn.addRequestProperty("Vipserver-Tag", EnvUtil.getSelfVipserverTag());
        conn.addRequestProperty("Location-Tag", EnvUtil.getSelfLocationTag());
    }

    private static String encodingParams(List<String> paramValues, String encoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (null == paramValues) {
            return null;
        }
        Iterator<String> iter = paramValues.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append("=");
            sb.append(URLEncoder.encode(iter.next(), encoding));
            if (!iter.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public static String getDIAMOND_CLIENT_VERSION() {
        return DIAMOND_CLIENT_VERSION;
    }

    static {
        String tmp = "1000";
        try {
            tmp = System.getProperty("DIAMOND.CONNECT.TIMEOUT", "1000");
            DIAMOND_CONNECT_TIMEOUT = Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            String msg = "[http-client] invalid connect timeout:" + tmp;
            DiamondEnv.log.error("settings", "DIAMOND-XXXX", msg, e);
            throw new IllegalArgumentException(msg, e);
        }
        DiamondEnv.log.info("settings", "[http-client] connect timeout:{}", DIAMOND_CONNECT_TIMEOUT);
        try {
            InputStream in = HttpSimpleClient.class.getClassLoader().getResourceAsStream("application.properties");
            Properties props = new Properties();
            props.load(in);
            String val = null;
            val = props.getProperty("version");
            if (val != null) {
                DIAMOND_CLIENT_VERSION = val;
            }
            DiamondEnv.log.info("DIAMOND_CLIENT_VERSION:{}", DIAMOND_CLIENT_VERSION);
        }
        catch (Exception e) {
            DiamondEnv.log.error("500", "read application.properties", e);
        }
    }

    private static class STSCredential {
        @JsonProperty(value="AccessKeyId")
        private String accessKeyId;
        @JsonProperty(value="AccessKeySecret")
        private String accessKeySecret;
        @JsonProperty(value="Expiration")
        private Date expiration;
        @JsonProperty(value="SecurityToken")
        private String securityToken;
        @JsonProperty(value="LastUpdated")
        private Date lastUpdated;
        @JsonProperty(value="Code")
        private String code;

        private STSCredential() {
        }

        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        public void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public String getAccessKeySecret() {
            return this.accessKeySecret;
        }

        public void setAccessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
        }

        public Date getExpiration() {
            return this.expiration;
        }

        public void setExpiration(Date expiration) {
            this.expiration = expiration;
        }

        public String getSecurityToken() {
            return this.securityToken;
        }

        public void setSecurityToken(String securityToken) {
            this.securityToken = securityToken;
        }

        public Date getLastUpdated() {
            return this.lastUpdated;
        }

        public void setLastUpdated(Date lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String toString() {
            return "STSCredential{accessKeyId='" + this.accessKeyId + '\'' + ", accessKeySecret='" + this.accessKeySecret + '\'' + ", expiration=" + this.expiration + ", securityToken='" + this.securityToken + '\'' + ", lastUpdated=" + this.lastUpdated + ", code='" + this.code + '\'' + '}';
        }
    }

    public static class HttpResult {
        public final int code;
        public final Map<String, List<String>> headers;
        public final String content;

        public HttpResult(int code, String content) {
            this.code = code;
            this.headers = null;
            this.content = content;
        }

        public HttpResult(int code, Map<String, List<String>> headers, String content) {
            this.code = code;
            this.headers = headers;
            this.content = content;
        }
    }
}

