/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.taobao.diamond.client.SnapShotSwitch;
import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.LocalConfigInfoProcessor;
import com.taobao.diamond.domain.ConfigInfoEx;
import com.taobao.diamond.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class LocalEncryptedDataKeyProcessor
extends LocalConfigInfoProcessor {
    public static String getEncryptDataKeyFailover(DiamondEnv env, String dataId, String group, String tenant) {
        File file = LocalEncryptedDataKeyProcessor.getEncryptDataKeyFailoverFile(env, dataId, group, tenant);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        try {
            return LocalEncryptedDataKeyProcessor.readFile(file);
        }
        catch (IOException ioe) {
            DiamondEnv.log.error(env.getName(), "DIAMOND-0009", "get failover error, " + file + ioe.toString());
            return null;
        }
    }

    public static String getEncryptDataKeySnapshot(DiamondEnv env, String dataId, String group, String tenant) {
        if (!SnapShotSwitch.getIsSnapShot().booleanValue()) {
            return null;
        }
        File file = LocalEncryptedDataKeyProcessor.getEncryptDataKeySnapshotFile(env, dataId, group, tenant);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        try {
            return LocalEncryptedDataKeyProcessor.readFile(file);
        }
        catch (IOException ioe) {
            DiamondEnv.log.error(env.getName(), "DIAMOND-0009", "get snapshot error, " + file + ", " + ioe.toString());
            return null;
        }
    }

    public static void batchSaveEncryptDataKeySnapshot(DiamondEnv env, List<ConfigInfoEx> configInfos) {
        for (ConfigInfoEx config : configInfos) {
            if (config.getStatus() == 2) continue;
            LocalEncryptedDataKeyProcessor.saveEncryptDataKeySnapshot(env, config.getDataId(), config.getGroup(), config.getTenant(), config.getEncryptedDataKey());
        }
    }

    public static void saveEncryptDataKeySnapshot(DiamondEnv env, String dataId, String group, String tenant, String encryptDataKey) {
        String envName = env.serverMgr.name;
        if (!SnapShotSwitch.getIsSnapShot().booleanValue()) {
            return;
        }
        File file = LocalEncryptedDataKeyProcessor.getEncryptDataKeySnapshotFile(envName, dataId, group, tenant);
        LocalEncryptedDataKeyProcessor.write(envName, encryptDataKey, file);
    }

    private static File getEncryptDataKeyFailoverFile(DiamondEnv env, String dataId, String group, String tenant) {
        File tmp = new File(localSnapShotPath, env.serverMgr.name + "_diamond");
        tmp = new File(tmp, "encrypted-data-key");
        if (StringUtils.isBlank(tenant)) {
            tmp = new File(tmp, "failover");
        } else {
            tmp = new File(tmp, "failover-tenant");
            tmp = new File(tmp, tenant);
        }
        return new File(new File(tmp, group), dataId);
    }

    private static File getEncryptDataKeySnapshotFile(DiamondEnv env, String dataId, String group, String tenant) {
        return LocalEncryptedDataKeyProcessor.getEncryptDataKeySnapshotFile(env.serverMgr.name, dataId, group, tenant);
    }

    private static File getEncryptDataKeySnapshotFile(String envName, String dataId, String group, String tenant) {
        File tmp = new File(localSnapShotPath, envName + "_diamond");
        tmp = new File(tmp, "encrypted-data-key");
        if (StringUtils.isBlank(tenant)) {
            tmp = new File(tmp, "snapshot");
        } else {
            tmp = new File(tmp, "snapshot-tenant");
            tmp = new File(tmp, tenant);
        }
        return new File(new File(tmp, group), dataId);
    }
}

