/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.auth.impl.process;

import com.alibaba.nacos.client.auth.impl.process.LoginProcessor;
import com.alibaba.nacos.client.utils.ClientBasicParamUtil;
import com.alibaba.nacos.client.utils.ContextPathUtil;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.utils.InternetAddressUtil;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.plugin.auth.api.LoginIdentityContext;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpLoginProcessor
implements LoginProcessor {
    private static final Logger SECURITY_LOGGER = LoggerFactory.getLogger(HttpLoginProcessor.class);
    private static final String LOGIN_V1_URL = "/v1/auth/users/login";
    private static final String LOGIN_V3_URL = "/v3/auth/user/login";
    public static final String DEFAULT_NACOS_WEB_CONTEXT = "/nacos";
    private final NacosRestTemplate nacosRestTemplate;

    public HttpLoginProcessor(NacosRestTemplate nacosRestTemplate) {
        this.nacosRestTemplate = nacosRestTemplate;
    }

    @Override
    public LoginIdentityContext getResponse(Properties properties) {
        String contextPath = ContextPathUtil.normalizeContextPath(properties.getProperty("contextPath", DEFAULT_NACOS_WEB_CONTEXT));
        String server = properties.getProperty("server", "");
        if (!server.startsWith("https://") && !server.startsWith("http://")) {
            if (!InternetAddressUtil.containsPort((String)server)) {
                server = server + ":" + ClientBasicParamUtil.getDefaultServerPort();
            }
            server = "http://" + server;
        }
        String url = server + contextPath + LOGIN_V3_URL;
        HashMap<String, String> params = new HashMap<String, String>(2);
        HashMap<String, String> bodyMap = new HashMap<String, String>(2);
        params.put("username", properties.getProperty("username", ""));
        bodyMap.put("password", properties.getProperty("password", ""));
        try {
            HttpRestResult restResult = this.nacosRestTemplate.postForm(url, Header.EMPTY, Query.newInstance().initParams(params), bodyMap, String.class);
            int code = restResult.getCode();
            if (code == 404 || code == 501) {
                url = server + contextPath + LOGIN_V1_URL;
                restResult = this.nacosRestTemplate.postForm(url, Header.EMPTY, Query.newInstance().initParams(params), bodyMap, String.class);
            }
            if (!restResult.ok()) {
                SECURITY_LOGGER.error("login failed: {}", (Object)JacksonUtils.toJson((Object)restResult));
                return null;
            }
            JsonNode obj = JacksonUtils.toObj((String)((String)restResult.getData()));
            LoginIdentityContext loginIdentityContext = new LoginIdentityContext();
            if (obj.has("accessToken")) {
                loginIdentityContext.setParameter("accessToken", obj.get("accessToken").asText());
                loginIdentityContext.setParameter("tokenTtl", obj.get("tokenTtl").asText());
            } else {
                SECURITY_LOGGER.info("[NacosClientAuthServiceImpl] ACCESS_TOKEN is empty from response");
            }
            return loginIdentityContext;
        }
        catch (Exception e) {
            HashMap<String, String> newBodyMap = new HashMap<String, String>(bodyMap);
            newBodyMap.put("password", ClientBasicParamUtil.desensitiseParameter((String)bodyMap.get("password")));
            SECURITY_LOGGER.error("[NacosClientAuthServiceImpl] login http request failed url: {}, params: {}, bodyMap: {}, errorMsg: {}", new Object[]{url, params, newBodyMap, e.getMessage()});
            return null;
        }
    }
}

