/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.auth.ram.utils;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class CalculateV4SigningKeyUtil {
    private static final String PREFIX = "aliyun_v4";
    private static final String CONSTANT = "aliyun_v4_request";
    private static final DateTimeFormatter V4_SIGN_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final ZoneId UTC_0 = ZoneId.of("GMT+00:00");

    private static byte[] firstSigningKey(String secret, String date, String signMethod) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(signMethod);
        mac.init(new SecretKeySpec((PREFIX + secret).getBytes(StandardCharsets.UTF_8), signMethod));
        return mac.doFinal(date.getBytes(StandardCharsets.UTF_8));
    }

    private static byte[] regionSigningKey(String secret, String date, String region, String signMethod) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] firstSignkey = CalculateV4SigningKeyUtil.firstSigningKey(secret, date, signMethod);
        Mac mac = Mac.getInstance(signMethod);
        mac.init(new SecretKeySpec(firstSignkey, signMethod));
        return mac.doFinal(region.getBytes(StandardCharsets.UTF_8));
    }

    private static byte[] finalSigningKey(String secret, String date, String region, String productCode, String signMethod) {
        try {
            byte[] secondSignkey = CalculateV4SigningKeyUtil.regionSigningKey(secret, date, region, signMethod);
            Mac mac = Mac.getInstance(signMethod);
            mac.init(new SecretKeySpec(secondSignkey, signMethod));
            byte[] thirdSigningKey = mac.doFinal(productCode.getBytes(StandardCharsets.UTF_8));
            mac = Mac.getInstance(signMethod);
            mac.init(new SecretKeySpec(thirdSigningKey, signMethod));
            return mac.doFinal(CONSTANT.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("unsupported Algorithm:" + signMethod);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("InvalidKey");
        }
    }

    public static String finalSigningKeyString(String secret, String date, String region, String productCode, String signMethod) {
        return Base64.getEncoder().encodeToString(CalculateV4SigningKeyUtil.finalSigningKey(secret, date, region, productCode, signMethod));
    }

    public static String finalSigningKeyStringWithDefaultInfo(String secret, String region) {
        String signDate = LocalDateTime.now(UTC_0).format(V4_SIGN_DATE_FORMATTER);
        return CalculateV4SigningKeyUtil.finalSigningKeyString(secret, signDate, region, "mse-nacos", "HmacSHA256");
    }
}

