/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.env.convert;

import com.alibaba.nacos.client.env.convert.AbstractPropertyConverter;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.HashSet;
import java.util.Set;

class BooleanConverter
extends AbstractPropertyConverter<Boolean> {
    private static final Set<String> TRUE_VALUES = new HashSet<String>(8);
    private static final Set<String> FALSE_VALUES = new HashSet<String>(8);

    BooleanConverter() {
    }

    @Override
    Boolean convert(String property) {
        if (StringUtils.isEmpty((String)property)) {
            return null;
        }
        if (TRUE_VALUES.contains(property = property.toLowerCase())) {
            return Boolean.TRUE;
        }
        if (FALSE_VALUES.contains(property)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean value '" + property + "'");
    }

    static {
        TRUE_VALUES.add("true");
        TRUE_VALUES.add("on");
        TRUE_VALUES.add("yes");
        TRUE_VALUES.add("1");
        FALSE_VALUES.add("false");
        FALSE_VALUES.add("off");
        FALSE_VALUES.add("no");
        FALSE_VALUES.add("0");
    }
}

