/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http;

import com.alibaba.nacos.common.http.DefaultHttpClientFactory;
import com.alibaba.nacos.common.http.HttpClientFactory;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientBeanHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientBeanHolder.class);
    private static final Map<String, NacosRestTemplate> SINGLETON_REST = new HashMap<String, NacosRestTemplate>(10);
    private static final Map<String, NacosAsyncRestTemplate> SINGLETON_ASYNC_REST = new HashMap<String, NacosAsyncRestTemplate>(10);
    private static final AtomicBoolean ALREADY_SHUTDOWN = new AtomicBoolean(false);

    public static NacosRestTemplate getNacosRestTemplate(Logger logger) {
        return HttpClientBeanHolder.getNacosRestTemplate(new DefaultHttpClientFactory(logger));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NacosRestTemplate getNacosRestTemplate(HttpClientFactory httpClientFactory) {
        if (httpClientFactory == null) {
            throw new NullPointerException("httpClientFactory is null");
        }
        String factoryName = httpClientFactory.getClass().getName();
        NacosRestTemplate nacosRestTemplate = SINGLETON_REST.get(factoryName);
        if (nacosRestTemplate == null) {
            Map<String, NacosRestTemplate> map = SINGLETON_REST;
            synchronized (map) {
                nacosRestTemplate = SINGLETON_REST.get(factoryName);
                if (nacosRestTemplate != null) {
                    return nacosRestTemplate;
                }
                nacosRestTemplate = httpClientFactory.createNacosRestTemplate();
                SINGLETON_REST.put(factoryName, nacosRestTemplate);
            }
        }
        return nacosRestTemplate;
    }

    public static NacosAsyncRestTemplate getNacosAsyncRestTemplate(Logger logger) {
        return HttpClientBeanHolder.getNacosAsyncRestTemplate(new DefaultHttpClientFactory(logger));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NacosAsyncRestTemplate getNacosAsyncRestTemplate(HttpClientFactory httpClientFactory) {
        if (httpClientFactory == null) {
            throw new NullPointerException("httpClientFactory is null");
        }
        String factoryName = httpClientFactory.getClass().getName();
        NacosAsyncRestTemplate nacosAsyncRestTemplate = SINGLETON_ASYNC_REST.get(factoryName);
        if (nacosAsyncRestTemplate == null) {
            Map<String, NacosAsyncRestTemplate> map = SINGLETON_ASYNC_REST;
            synchronized (map) {
                nacosAsyncRestTemplate = SINGLETON_ASYNC_REST.get(factoryName);
                if (nacosAsyncRestTemplate != null) {
                    return nacosAsyncRestTemplate;
                }
                nacosAsyncRestTemplate = httpClientFactory.createNacosAsyncRestTemplate();
                SINGLETON_ASYNC_REST.put(factoryName, nacosAsyncRestTemplate);
            }
        }
        return nacosAsyncRestTemplate;
    }

    private static void shutdown() {
        if (!ALREADY_SHUTDOWN.compareAndSet(false, true)) {
            return;
        }
        LOGGER.info("[HttpClientBeanHolder] Start destroying common HttpClient");
        try {
            HttpClientBeanHolder.shutdown(DefaultHttpClientFactory.class.getName());
        }
        catch (Exception ex) {
            LOGGER.error("An exception occurred when the common HTTP client was closed : {}", (Object)ExceptionUtil.getStackTrace(ex));
        }
        LOGGER.info("[HttpClientBeanHolder] Completed destruction of HttpClient");
    }

    public static void shutdown(String className) throws Exception {
        HttpClientBeanHolder.shutdownNacosSyncRest(className);
        HttpClientBeanHolder.shutdownNacosAsyncRest(className);
    }

    public static void shutdownNacosSyncRest(String className) throws Exception {
        NacosRestTemplate nacosRestTemplate = SINGLETON_REST.get(className);
        if (nacosRestTemplate != null) {
            nacosRestTemplate.close();
            SINGLETON_REST.remove(className);
        }
    }

    public static void shutdownNacosAsyncRest(String className) throws Exception {
        NacosAsyncRestTemplate nacosAsyncRestTemplate = SINGLETON_ASYNC_REST.get(className);
        if (nacosAsyncRestTemplate != null) {
            nacosAsyncRestTemplate.close();
            SINGLETON_ASYNC_REST.remove(className);
        }
    }

    static {
        ThreadUtils.addShutdownHook(HttpClientBeanHolder::shutdown);
    }
}

