/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

public class JsonUtils {
    public static <T> T unmarshalFromByte(byte[] bytes, Class<T> targetClass) {
        return (T)JSON.parseObject((byte[])bytes, targetClass, (Feature[])new Feature[0]);
    }

    public static <T> T unmarshalFromByte(byte[] bytes, TypeReference<T> type) {
        return (T)JSON.parseObject((byte[])bytes, (Type)type.getType(), (Feature[])new Feature[0]);
    }

    public static byte[] marshalToByte(Object obj) {
        return JSON.toJSONBytes((Object)obj, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static byte[] marshalToByte(Object obj, SerializerFeature ... features) {
        return JSON.toJSONBytes((Object)obj, (SerializerFeature[])features);
    }

    public static <T> T unmarshalFromString(String json, Class<T> targetClass) {
        return (T)JSON.parseObject((String)json, targetClass);
    }

    public static <T> T unmarshalFromString(String json, TypeReference<T> type) {
        return (T)JSON.parseObject((String)json, type, (Feature[])new Feature[0]);
    }

    public static String marshalToString(Object obj) {
        return JSON.toJSONString((Object)obj);
    }

    public static String marshalToString(Object obj, SerializerFeature ... features) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String marshalToString(Object obj, String ... fliterFields) {
        final List<String> propertyFliters = Arrays.asList(fliterFields);
        SerializeWriter out = new SerializeWriter();
        try {
            JSONSerializer serializer = new JSONSerializer(out);
            serializer.getPropertyFilters().add(new PropertyFilter(){

                public boolean apply(Object source, String name, Object value) {
                    return !propertyFliters.contains(name);
                }
            });
            serializer.write(obj);
            String string = out.toString();
            return string;
        }
        finally {
            out.close();
        }
    }
}

