/*
 * Decompiled with CFR 0.152.
 */
package pemja.core;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public final class PythonInterpreterConfig {
    private final String[] paths;
    private final String pythonExec;
    private final ExecType execType;

    private PythonInterpreterConfig(String[] paths, String pythonExec, ExecType execType) {
        this.paths = paths;
        this.pythonExec = pythonExec;
        this.execType = execType;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public String getPythonExec() {
        return this.pythonExec;
    }

    public ExecType getExecType() {
        return this.execType;
    }

    public static PythonInterpreterConfigBuilder newBuilder() {
        return new PythonInterpreterConfigBuilder();
    }

    public static enum ExecType {
        MULTI_THREAD,
        SUB_INTERPRETER;

    }

    public static class PythonInterpreterConfigBuilder {
        private Set<String> paths = new LinkedHashSet<String>();
        private String pythonExec = null;
        private ExecType execType = ExecType.MULTI_THREAD;

        public PythonInterpreterConfigBuilder addPythonPaths(String paths) {
            return this.addPythonPaths(paths.split(File.pathSeparator));
        }

        public PythonInterpreterConfigBuilder addPythonPaths(String ... paths) {
            this.paths.addAll(Arrays.asList(paths));
            return this;
        }

        public PythonInterpreterConfigBuilder setPythonExec(String pythonExec) {
            this.pythonExec = pythonExec;
            return this;
        }

        public PythonInterpreterConfigBuilder setExcType(ExecType excType) {
            this.execType = excType;
            return this;
        }

        public PythonInterpreterConfig build() {
            return new PythonInterpreterConfig(this.paths.toArray(new String[0]), this.pythonExec, this.execType);
        }
    }
}

