/*
 * Decompiled with CFR 0.152.
 */
package pemja.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Vector;
import java.util.regex.Pattern;

public class CommonUtils {
    public static final CommonUtils INSTANCE = new CommonUtils();
    private boolean initialized = false;
    private static final String GET_PYTHON_LIB_PATH_SCRIPT = "from find_libpython import find_libpython;print(find_libpython())";
    private static final String GET_SITE_PACKAGES_PATH_SCRIPT = "import sysconfig; print(sysconfig.get_paths()[\"purelib\"])";
    private static final String GET_PEMJA_MODULE_PATH_SCRIPT = "import pemja;import os;print(os.path.dirname(pemja.__file__))";

    private CommonUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLibrary(String pythonExec, String library) {
        if (!this.initialized) {
            String utilsLibPath = this.getLibraryPathWithPattern(pythonExec, "^pemja_utils\\.cpython-.*\\.so$");
            try {
                System.load(utilsLibPath);
            }
            catch (UnsatisfiedLinkError error) {
                try {
                    Vector libs;
                    Field field = ClassLoader.class.getDeclaredField("loadedLibraryNames");
                    field.setAccessible(true);
                    Vector vector = libs = (Vector)field.get(null);
                    synchronized (vector) {
                        int size = libs.size();
                        for (int i = 0; i < size; ++i) {
                            String element = (String)libs.elementAt(i);
                            if (!element.contains("pemja_utils")) continue;
                            libs.removeElementAt(i);
                        }
                    }
                    System.load(utilsLibPath);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.initialized = true;
        }
        this.loadLibrary0(library);
    }

    public String getLibraryPathWithPattern(String pythonExec, String pattern) {
        String sitePackagesPath;
        if (pythonExec == null) {
            String pythonModulePath = String.join((CharSequence)File.separator, System.getProperty("user.dir"), "src", "main", "python");
            File pythonModuleFile = new File(pythonModulePath);
            for (File f : Objects.requireNonNull(pythonModuleFile.listFiles())) {
                if (!f.isFile() || !Pattern.matches(pattern, f.getName())) continue;
                return f.getAbsolutePath();
            }
            throw new IllegalArgumentException("Test in source, you need to execute`python setup.py build_ext --inplace --force ` to build pemja.");
        }
        try {
            String out = this.execute(new String[]{pythonExec, "-c", GET_SITE_PACKAGES_PATH_SCRIPT});
            sitePackagesPath = String.join((CharSequence)File.pathSeparator, out.trim().split("\n"));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get pemja path. You need to `pip install pemja` firstly.", e);
        }
        File libFile = new File(sitePackagesPath);
        if (libFile.isDirectory()) {
            for (File f : Objects.requireNonNull(libFile.listFiles())) {
                if (!f.isFile() || !Pattern.matches(pattern, f.getName())) continue;
                return f.getAbsolutePath();
            }
        }
        throw new RuntimeException("Failed to find PemJa Library");
    }

    public String getPemJaModulePath(String pythonExec) {
        String out;
        if (pythonExec == null) {
            return String.join((CharSequence)File.separator, System.getProperty("user.dir"), "src", "main", "python", "pemja");
        }
        try {
            out = this.execute(new String[]{pythonExec, "-c", GET_PEMJA_MODULE_PATH_SCRIPT});
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get PemJa module path", e);
        }
        return String.join((CharSequence)File.pathSeparator, out.trim().split("\n"));
    }

    public String getPythonLibrary(String pythonExec) {
        try {
            String out = pythonExec == null ? this.execute(new String[]{"python3", "-c", GET_PYTHON_LIB_PATH_SCRIPT}) : this.execute(new String[]{pythonExec, "-c", GET_PYTHON_LIB_PATH_SCRIPT});
            return String.join((CharSequence)File.pathSeparator, out.trim().split("\n"));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to find libpython", e);
        }
    }

    public boolean isLinuxOs() {
        String os = System.getProperty("os.name");
        return os.startsWith("Linux");
    }

    private String execute(String[] commands) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(commands);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        BufferedInputStream in = new BufferedInputStream(p.getInputStream());
        StringBuilder out = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String s;
            while ((s = br.readLine()) != null) {
                out.append(s).append("\n");
            }
        }
        try {
            if (p.waitFor() != 0) {
                throw new IOException(String.format("Failed to execute the command: %s\noutput: %s", String.join((CharSequence)" ", commands), out));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return out.toString();
    }

    private native void loadLibrary0(String var1);
}

