/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.common.message;

import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.message.MessageExt;
import com.alibaba.rocketmq.common.message.MessageId;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageDecoder {
    public static final int MSG_ID_LENGTH = 16;
    public static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    public static final int MessageMagicCodePostion = 4;
    public static final int MessageFlagPostion = 16;
    public static final int MessagePhysicOffsetPostion = 28;
    public static final int MessageStoreTimestampPostion = 56;
    public static final int MessageMagicCode = -626843481;
    public static final char NAME_VALUE_SEPARATOR = '\u0001';
    public static final char PROPERTY_SEPARATOR = '\u0002';

    public static String createMessageId(SocketAddress socketAddress, long transactionIdhashCode) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        byteBuffer.put(inetSocketAddress.getAddress().getAddress());
        byteBuffer.putInt(inetSocketAddress.getPort());
        byteBuffer.putLong(transactionIdhashCode);
        byteBuffer.flip();
        return UtilAll.bytes2string(byteBuffer.array());
    }

    public static MessageId decodeMessageId(String msgId) throws UnknownHostException {
        byte[] ip = UtilAll.string2bytes(msgId.substring(0, 8));
        byte[] port = UtilAll.string2bytes(msgId.substring(8, 16));
        ByteBuffer bb = ByteBuffer.wrap(port);
        int portInt = bb.getInt(0);
        InetSocketAddress address = new InetSocketAddress(InetAddress.getByAddress(ip), portInt);
        byte[] data = UtilAll.string2bytes(msgId.substring(16, 32));
        bb = ByteBuffer.wrap(data);
        long offset = bb.getLong(0);
        return new MessageId(address, offset);
    }

    public static MessageExt decode(ByteBuffer byteBuffer) {
        return MessageDecoder.decode(byteBuffer, true, true);
    }

    public static MessageExt decode(ByteBuffer byteBuffer, boolean readBody, boolean deCompressBody) {
        try {
            MessageExt msgExt = new MessageExt();
            int storeSize = byteBuffer.getInt();
            msgExt.setStoreSize(storeSize);
            byteBuffer.getInt();
            int bodyCRC = byteBuffer.getInt();
            msgExt.setBodyCRC(bodyCRC);
            int queueId = byteBuffer.getInt();
            msgExt.setQueueId(queueId);
            int flag = byteBuffer.getInt();
            msgExt.setFlag(flag);
            long queueOffset = byteBuffer.getLong();
            msgExt.setQueueOffset(queueOffset);
            long physicOffset = byteBuffer.getLong();
            msgExt.setCommitLogOffset(physicOffset);
            int sysFlag = byteBuffer.getInt();
            msgExt.setSysFlag(sysFlag);
            long bornTimeStamp = byteBuffer.getLong();
            msgExt.setBornTimestamp(bornTimeStamp);
            byte[] bornHost = new byte[4];
            byteBuffer.get(bornHost, 0, 4);
            int port = byteBuffer.getInt();
            msgExt.setBornHost(new InetSocketAddress(InetAddress.getByAddress(bornHost), port));
            long storeTimestamp = byteBuffer.getLong();
            msgExt.setStoreTimestamp(storeTimestamp);
            byte[] storeHost = new byte[4];
            byteBuffer.get(storeHost, 0, 4);
            port = byteBuffer.getInt();
            msgExt.setStoreHost(new InetSocketAddress(InetAddress.getByAddress(storeHost), port));
            int reconsumeTimes = byteBuffer.getInt();
            msgExt.setReconsumeTimes(reconsumeTimes);
            long preparedTransactionOffset = byteBuffer.getLong();
            msgExt.setPreparedTransactionOffset(preparedTransactionOffset);
            int bodyLen = byteBuffer.getInt();
            if (bodyLen > 0) {
                if (readBody) {
                    byte[] body = new byte[bodyLen];
                    byteBuffer.get(body);
                    if (deCompressBody && (sysFlag & 1) == 1) {
                        body = UtilAll.uncompress(body);
                    }
                    msgExt.setBody(body);
                } else {
                    byteBuffer.position(byteBuffer.position() + bodyLen);
                }
            }
            byte topicLen = byteBuffer.get();
            byte[] topic = new byte[topicLen];
            byteBuffer.get(topic);
            msgExt.setTopic(new String(topic, CHARSET_UTF8));
            short propertiesLength = byteBuffer.getShort();
            if (propertiesLength > 0) {
                byte[] properties = new byte[propertiesLength];
                byteBuffer.get(properties);
                String propertiesString = new String(properties, CHARSET_UTF8);
                Map<String, String> map = MessageDecoder.string2messageProperties(propertiesString);
                msgExt.setProperties(map);
            }
            ByteBuffer byteBufferMsgId = ByteBuffer.allocate(16);
            String msgId = MessageDecoder.createMessageId(byteBufferMsgId, msgExt.getStoreHostBytes(), msgExt.getCommitLogOffset());
            msgExt.setMsgId(msgId);
            return msgExt;
        }
        catch (UnknownHostException e) {
            byteBuffer.position(byteBuffer.limit());
        }
        catch (BufferUnderflowException e) {
            byteBuffer.position(byteBuffer.limit());
        }
        catch (Exception e) {
            byteBuffer.position(byteBuffer.limit());
        }
        return null;
    }

    public static Map<String, String> string2messageProperties(String properties) {
        String[] items;
        HashMap<String, String> map = new HashMap<String, String>();
        if (properties != null && (items = properties.split(String.valueOf('\u0002'))) != null) {
            for (String i : items) {
                String[] nv = i.split(String.valueOf('\u0001'));
                if (nv == null || 2 != nv.length) continue;
                map.put(nv[0], nv[1]);
            }
        }
        return map;
    }

    public static String createMessageId(ByteBuffer input, ByteBuffer addr, long offset) {
        input.flip();
        input.limit(16);
        input.put(addr);
        input.putLong(offset);
        return UtilAll.bytes2string(input.array());
    }

    public static byte[] encode(MessageExt messageExt, boolean needCompress) throws Exception {
        ByteBuffer byteBuffer;
        byte[] body = messageExt.getBody();
        byte[] topics = messageExt.getTopic().getBytes(CHARSET_UTF8);
        byte topicLen = (byte)topics.length;
        String properties = MessageDecoder.messageProperties2String(messageExt.getProperties());
        byte[] propertiesBytes = properties.getBytes(CHARSET_UTF8);
        short propertiesLength = (short)propertiesBytes.length;
        int sysFlag = messageExt.getSysFlag();
        byte[] newBody = messageExt.getBody();
        if (needCompress && (sysFlag & 1) == 1) {
            newBody = UtilAll.compress(body, 5);
        }
        int bodyLength = newBody.length;
        int storeSize = messageExt.getStoreSize();
        if (storeSize > 0) {
            byteBuffer = ByteBuffer.allocate(storeSize);
        } else {
            storeSize = 88 + bodyLength + 1 + topicLen + 2 + propertiesLength + 0;
            byteBuffer = ByteBuffer.allocate(storeSize);
        }
        byteBuffer.putInt(storeSize);
        byteBuffer.putInt(-626843481);
        int bodyCRC = messageExt.getBodyCRC();
        byteBuffer.putInt(bodyCRC);
        int queueId = messageExt.getQueueId();
        byteBuffer.putInt(queueId);
        int flag = messageExt.getFlag();
        byteBuffer.putInt(flag);
        long queueOffset = messageExt.getQueueOffset();
        byteBuffer.putLong(queueOffset);
        long physicOffset = messageExt.getCommitLogOffset();
        byteBuffer.putLong(physicOffset);
        byteBuffer.putInt(sysFlag);
        long bornTimeStamp = messageExt.getBornTimestamp();
        byteBuffer.putLong(bornTimeStamp);
        InetSocketAddress bornHost = (InetSocketAddress)messageExt.getBornHost();
        byteBuffer.put(bornHost.getAddress().getAddress());
        byteBuffer.putInt(bornHost.getPort());
        long storeTimestamp = messageExt.getStoreTimestamp();
        byteBuffer.putLong(storeTimestamp);
        InetSocketAddress serverHost = (InetSocketAddress)messageExt.getStoreHost();
        byteBuffer.put(serverHost.getAddress().getAddress());
        byteBuffer.putInt(serverHost.getPort());
        int reconsumeTimes = messageExt.getReconsumeTimes();
        byteBuffer.putInt(reconsumeTimes);
        long preparedTransactionOffset = messageExt.getPreparedTransactionOffset();
        byteBuffer.putLong(preparedTransactionOffset);
        byteBuffer.putInt(bodyLength);
        byteBuffer.put(newBody);
        byteBuffer.put(topicLen);
        byteBuffer.put(topics);
        byteBuffer.putShort(propertiesLength);
        byteBuffer.put(propertiesBytes);
        return byteBuffer.array();
    }

    public static String messageProperties2String(Map<String, String> properties) {
        StringBuilder sb = new StringBuilder();
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                sb.append(name);
                sb.append('\u0001');
                sb.append(value);
                sb.append('\u0002');
            }
        }
        return sb.toString();
    }

    public static List<MessageExt> decodes(ByteBuffer byteBuffer) {
        return MessageDecoder.decodes(byteBuffer, true);
    }

    public static List<MessageExt> decodes(ByteBuffer byteBuffer, boolean readBody) {
        MessageExt msgExt;
        ArrayList<MessageExt> msgExts = new ArrayList<MessageExt>();
        while (byteBuffer.hasRemaining() && null != (msgExt = MessageDecoder.decode(byteBuffer, readBody))) {
            msgExts.add(msgExt);
        }
        return msgExts;
    }

    public static MessageExt decode(ByteBuffer byteBuffer, boolean readBody) {
        return MessageDecoder.decode(byteBuffer, readBody, true);
    }
}

