/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.cdc.formats.json;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.json.JsonRowDataDeserializationSchema;
import org.apache.flink.formats.json.TimestampFormat;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

public class ChangelogJsonDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = -2084214292622004460L;
    private final JsonRowDataDeserializationSchema jsonDeserializer;
    private final TypeInformation<RowData> resultTypeInfo;
    private final boolean ignoreParseErrors;

    public ChangelogJsonDeserializationSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, boolean ignoreParseErrors, TimestampFormat timestampFormatOption) {
        this.resultTypeInfo = resultTypeInfo;
        this.ignoreParseErrors = ignoreParseErrors;
        this.jsonDeserializer = new JsonRowDataDeserializationSchema(ChangelogJsonDeserializationSchema.createJsonRowType(TypeConversions.fromLogicalToDataType((LogicalType)rowType)), resultTypeInfo, false, ignoreParseErrors, timestampFormatOption);
    }

    public RowData deserialize(byte[] message) throws IOException {
        throw new RuntimeException("Please invoke DeserializationSchema#deserialize(byte[], Collector<RowData>) instead.");
    }

    public void deserialize(byte[] bytes, Collector<RowData> out) throws IOException {
        block2: {
            try {
                GenericRowData row = (GenericRowData)this.jsonDeserializer.deserialize(bytes);
                GenericRowData data = (GenericRowData)row.getField(0);
                String op = row.getString(1).toString();
                RowKind rowKind = ChangelogJsonDeserializationSchema.parseRowKind(op);
                data.setRowKind(rowKind);
                out.collect((Object)data);
            }
            catch (Throwable t) {
                if (this.ignoreParseErrors) break block2;
                throw new IOException(String.format("Corrupt Debezium JSON message '%s'.", new String(bytes)), t);
            }
        }
    }

    private static RowKind parseRowKind(String op) {
        switch (op) {
            case "+I": {
                return RowKind.INSERT;
            }
            case "-U": {
                return RowKind.UPDATE_BEFORE;
            }
            case "+U": {
                return RowKind.UPDATE_AFTER;
            }
            case "-D": {
                return RowKind.DELETE;
            }
        }
        throw new UnsupportedOperationException("Unsupported operation '" + op + "' for row kind.");
    }

    public boolean isEndOfStream(RowData rowData) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.resultTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangelogJsonDeserializationSchema that = (ChangelogJsonDeserializationSchema)o;
        return this.ignoreParseErrors == that.ignoreParseErrors && Objects.equals(this.jsonDeserializer, that.jsonDeserializer) && Objects.equals(this.resultTypeInfo, that.resultTypeInfo);
    }

    public int hashCode() {
        return Objects.hash(this.jsonDeserializer, this.resultTypeInfo, this.ignoreParseErrors);
    }

    private static RowType createJsonRowType(DataType databaseSchema) {
        DataType payload = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"data", (DataType)databaseSchema), DataTypes.FIELD((String)"op", (DataType)DataTypes.STRING())});
        return (RowType)payload.getLogicalType();
    }
}

