/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.cdc.formats.json;

import java.util.Objects;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.json.JsonRowDataSerializationSchema;
import org.apache.flink.formats.json.TimestampFormat;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.RowKind;

public class ChangelogJsonSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = -3999450457829887684L;
    private static final StringData OP_INSERT = StringData.fromString((String)"+I");
    private static final StringData OP_UPDATE_BEFORE = StringData.fromString((String)"-U");
    private static final StringData OP_UPDATE_AFTER = StringData.fromString((String)"+U");
    private static final StringData OP_DELETE = StringData.fromString((String)"-D");
    private final JsonRowDataSerializationSchema jsonSerializer;
    private final TimestampFormat timestampFormat;
    private transient GenericRowData reuse;

    public ChangelogJsonSerializationSchema(RowType rowType, TimestampFormat timestampFormat) {
        this.jsonSerializer = new JsonRowDataSerializationSchema(ChangelogJsonSerializationSchema.createJsonRowType(TypeConversions.fromLogicalToDataType((LogicalType)rowType)), timestampFormat);
        this.timestampFormat = timestampFormat;
    }

    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.reuse = new GenericRowData(2);
    }

    public byte[] serialize(RowData rowData) {
        this.reuse.setField(0, (Object)rowData);
        this.reuse.setField(1, (Object)ChangelogJsonSerializationSchema.stringifyRowKind(rowData.getRowKind()));
        return this.jsonSerializer.serialize((RowData)this.reuse);
    }

    private static StringData stringifyRowKind(RowKind rowKind) {
        switch (rowKind) {
            case INSERT: {
                return OP_INSERT;
            }
            case UPDATE_BEFORE: {
                return OP_UPDATE_BEFORE;
            }
            case UPDATE_AFTER: {
                return OP_UPDATE_AFTER;
            }
            case DELETE: {
                return OP_DELETE;
            }
        }
        throw new UnsupportedOperationException("Unsupported operation '" + rowKind + "' for row kind.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangelogJsonSerializationSchema that = (ChangelogJsonSerializationSchema)o;
        return Objects.equals(this.jsonSerializer, that.jsonSerializer) && this.timestampFormat == that.timestampFormat;
    }

    public int hashCode() {
        return Objects.hash(this.jsonSerializer, this.timestampFormat);
    }

    private static RowType createJsonRowType(DataType databaseSchema) {
        DataType payload = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"data", (DataType)databaseSchema), DataTypes.FIELD((String)"op", (DataType)DataTypes.STRING())});
        return (RowType)payload.getLogicalType();
    }
}

