/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.anno.method.SpringCacheContext;
import com.alicp.jetcache.anno.support.CacheContext;
import com.alicp.jetcache.anno.support.ConfigProvider;
import com.alicp.jetcache.anno.support.DefaultSpringEncoderParser;
import com.alicp.jetcache.anno.support.DefaultSpringKeyConvertorParser;
import com.alicp.jetcache.anno.support.EncoderParser;
import com.alicp.jetcache.anno.support.KeyConvertorParser;
import com.alicp.jetcache.support.StatInfo;
import java.util.function.Consumer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringConfigProvider
extends ConfigProvider
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    public SpringConfigProvider() {
        this.encoderParser = new DefaultSpringEncoderParser();
        this.keyConvertorParser = new DefaultSpringKeyConvertorParser();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    protected void doInit() {
        if (this.encoderParser instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.encoderParser).setApplicationContext(this.applicationContext);
        }
        if (this.keyConvertorParser instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.keyConvertorParser).setApplicationContext(this.applicationContext);
        }
        super.doInit();
    }

    @Override
    public CacheContext newContext(CacheManager cacheManager) {
        return new SpringCacheContext(cacheManager, this, this.globalCacheConfig, this.applicationContext);
    }

    @Override
    @Autowired(required=false)
    public void setEncoderParser(EncoderParser encoderParser) {
        super.setEncoderParser(encoderParser);
    }

    @Override
    @Autowired(required=false)
    public void setKeyConvertorParser(KeyConvertorParser keyConvertorParser) {
        super.setKeyConvertorParser(keyConvertorParser);
    }

    @Override
    @Autowired(required=false)
    public void setMetricsCallback(Consumer<StatInfo> metricsCallback) {
        super.setMetricsCallback(metricsCallback);
    }
}

