/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log;

import com.alipay.sofa.common.log.Constants;
import com.alipay.sofa.common.log.SpaceId;
import com.alipay.sofa.common.log.SpaceInfo;
import com.alipay.sofa.common.log.adapter.level.AdapterLevel;
import com.alipay.sofa.common.log.env.LogEnvUtils;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.log.factory.LoggerSpaceFactory4CommonsLoggingBuilder;
import com.alipay.sofa.common.log.factory.LoggerSpaceFactory4Log4j2Builder;
import com.alipay.sofa.common.log.factory.LoggerSpaceFactory4Log4jBuilder;
import com.alipay.sofa.common.log.factory.LoggerSpaceFactory4LogbackBuilder;
import com.alipay.sofa.common.log.proxy.TemporaryILoggerFactoryPool;
import com.alipay.sofa.common.utils.ReportUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class MultiAppLoggerSpaceManager {
    private static final AbstractLoggerSpaceFactory NOP_LOGGER_FACTORY = new AbstractLoggerSpaceFactory("nop"){

        public Logger getLogger(String name) {
            return Constants.DEFAULT_LOG;
        }
    };
    private static final ConcurrentHashMap<SpaceId, SpaceInfo> spacesMap = new ConcurrentHashMap();

    public static void init(String spaceName, Map<String, String> props) {
        MultiAppLoggerSpaceManager.init(new SpaceId(spaceName), props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(SpaceId spaceId, Map<String, String> props) {
        if (MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId)) {
            throw new IllegalStateException("Logger Space:" + spaceId.toString() + " is already initialized!");
        }
        Class<MultiAppLoggerSpaceManager> clazz = MultiAppLoggerSpaceManager.class;
        synchronized (MultiAppLoggerSpaceManager.class) {
            if (MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId)) {
                throw new IllegalStateException("Logger Space:" + spaceId.toString() + " is already initialized!");
            }
            MultiAppLoggerSpaceManager.doInit(spaceId, props);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ReportUtil.report("Logger Space:{" + spaceId.toString() + "} init ok.");
            return;
        }
    }

    static void doInit(String spaceName, Map<String, String> props) {
        MultiAppLoggerSpaceManager.doInit(new SpaceId(spaceName), props);
    }

    static void doInit(SpaceId spaceId, Map<String, String> props) {
        SpaceInfo spaceInfo = new SpaceInfo();
        spacesMap.putIfAbsent(spaceId, spaceInfo);
        if (props != null) {
            spaceInfo.properties().putAll(props);
        }
    }

    public static Logger getLoggerBySpace(String name, String spaceName) {
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, new SpaceId(spaceName));
    }

    public static Logger getLoggerBySpace(String name, SpaceId spaceId) {
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, spaceId, MultiAppLoggerSpaceManager.class.getClassLoader());
    }

    public static Logger setLoggerLevel(String loggerName, String spaceName, AdapterLevel adapterLevel) {
        return MultiAppLoggerSpaceManager.setLoggerLevel(loggerName, new SpaceId(spaceName), adapterLevel);
    }

    public static Logger setLoggerLevel(String loggerName, SpaceId spaceId, AdapterLevel adapterLevel) {
        AbstractLoggerSpaceFactory abstractLoggerSpaceFactory = MultiAppLoggerSpaceManager.getILoggerFactoryBySpaceName(spaceId, MultiAppLoggerSpaceManager.class.getClassLoader());
        try {
            abstractLoggerSpaceFactory.setLevel(loggerName, adapterLevel);
        }
        catch (Exception e) {
            ReportUtil.reportError("SetLoggerLevel Error : ", e);
        }
        return abstractLoggerSpaceFactory.getLogger(loggerName);
    }

    public static Logger getLoggerBySpace(String name, String spaceName, ClassLoader spaceClassloader) {
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, new SpaceId(spaceName), spaceClassloader);
    }

    public static Logger getLoggerBySpace(String name, SpaceId spaceId, ClassLoader spaceClassloader) {
        AbstractLoggerSpaceFactory abstractLoggerSpaceFactory = MultiAppLoggerSpaceManager.getILoggerFactoryBySpaceName(spaceId, spaceClassloader);
        return abstractLoggerSpaceFactory.getLogger(name);
    }

    public static ILoggerFactory removeILoggerFactoryBySpaceName(String spaceName) {
        return MultiAppLoggerSpaceManager.removeILoggerFactoryBySpaceId(new SpaceId(spaceName));
    }

    public static ILoggerFactory removeILoggerFactoryBySpaceId(SpaceId spaceId) {
        if (spaceId == null) {
            return null;
        }
        if (MultiAppLoggerSpaceManager.isSpaceILoggerFactoryExisted(spaceId)) {
            AbstractLoggerSpaceFactory iLoggeriFactory = spacesMap.get(spaceId).getAbstractLoggerSpaceFactory();
            spacesMap.get(spaceId).setAbstractLoggerSpaceFactory(null);
            Logger rootLogger = iLoggeriFactory.getLogger("ROOT");
            rootLogger.warn("Log Space Name[" + spaceId.toString() + "] is Removed from Current Log Space Manager!");
            return iLoggeriFactory;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractLoggerSpaceFactory getILoggerFactoryBySpaceName(SpaceId spaceId, ClassLoader spaceClassloader) {
        if (!MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId)) {
            return TemporaryILoggerFactoryPool.get(spaceId, spaceClassloader);
        }
        AbstractLoggerSpaceFactory iLoggerFactory = NOP_LOGGER_FACTORY;
        if (!MultiAppLoggerSpaceManager.isSpaceILoggerFactoryExisted(spaceId)) {
            Class<MultiAppLoggerSpaceManager> clazz = MultiAppLoggerSpaceManager.class;
            synchronized (MultiAppLoggerSpaceManager.class) {
                if (!MultiAppLoggerSpaceManager.isSpaceILoggerFactoryExisted(spaceId)) {
                    iLoggerFactory = MultiAppLoggerSpaceManager.createILoggerFactory(spaceId, spaceClassloader);
                    spacesMap.get(spaceId).setAbstractLoggerSpaceFactory(iLoggerFactory);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            iLoggerFactory = spacesMap.get(spaceId).getAbstractLoggerSpaceFactory();
        }
        return iLoggerFactory;
    }

    public static boolean isSpaceInitialized(String spaceName) {
        return MultiAppLoggerSpaceManager.isSpaceInitialized(new SpaceId(spaceName));
    }

    public static boolean isSpaceInitialized(SpaceId spaceId) {
        return spacesMap.get(spaceId) != null;
    }

    private static boolean isSpaceILoggerFactoryExisted(String spaceName) {
        return MultiAppLoggerSpaceManager.isSpaceILoggerFactoryExisted(new SpaceId(spaceName));
    }

    private static boolean isSpaceILoggerFactoryExisted(SpaceId spaceId) {
        return MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId) && spacesMap.get(spaceId).getAbstractLoggerSpaceFactory() != null;
    }

    private static AbstractLoggerSpaceFactory createILoggerFactory(SpaceId spaceId, ClassLoader spaceClassloader) {
        if (System.getProperty("sofa.middleware.log.disable") != null && Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("sofa.middleware.log.disable"))) {
            ReportUtil.reportWarn("Sofa-Middleware-Log is disabled!  -Dsofa.middleware.log.disable=true");
            return NOP_LOGGER_FACTORY;
        }
        LogEnvUtils.processGlobalSystemLogProperties();
        try {
            String isLog4jDisable;
            if (LogEnvUtils.isLogbackUsable(spaceClassloader)) {
                String isLogbackDisable = System.getProperty("logback.middleware.log.disable");
                if (isLogbackDisable != null && Boolean.TRUE.toString().equalsIgnoreCase(isLogbackDisable)) {
                    ReportUtil.reportWarn("Logback-Sofa-Middleware-Log is disabled!  -Dlogback.middleware.log.disable=true");
                } else {
                    ReportUtil.report("Actual binding is of type [ " + spaceId.toString() + " Logback ]");
                    LoggerSpaceFactory4LogbackBuilder loggerSpaceFactory4LogbackBuilder = new LoggerSpaceFactory4LogbackBuilder(spacesMap.get(spaceId));
                    return loggerSpaceFactory4LogbackBuilder.build(spaceId.getSpaceName(), spaceClassloader);
                }
            }
            if (LogEnvUtils.isLog4j2Usable(spaceClassloader)) {
                String isLog4j2Disable = System.getProperty("log4j2.middleware.log.disable");
                if (isLog4j2Disable != null && Boolean.TRUE.toString().equalsIgnoreCase(isLog4j2Disable)) {
                    ReportUtil.reportWarn("Log4j2-Sofa-Middleware-Log is disabled!  -Dlog4j2.middleware.log.disable=true");
                } else {
                    ReportUtil.report("Actual binding is of type [ " + spaceId.toString() + " Log4j2 ]");
                    LoggerSpaceFactory4Log4j2Builder loggerSpaceFactory4Log4j2Builder = new LoggerSpaceFactory4Log4j2Builder(spacesMap.get(spaceId));
                    return loggerSpaceFactory4Log4j2Builder.build(spaceId.getSpaceName(), spaceClassloader);
                }
            }
            if (LogEnvUtils.isLog4jUsable(spaceClassloader)) {
                isLog4jDisable = System.getProperty("log4j.middleware.log.disable");
                if (isLog4jDisable != null && Boolean.TRUE.toString().equalsIgnoreCase(isLog4jDisable)) {
                    ReportUtil.reportWarn("Log4j-Sofa-Middleware-Log is disabled!  -Dlog4j.middleware.log.disable=true");
                } else {
                    ReportUtil.report("Actual binding is of type [ " + spaceId.toString() + " Log4j ]");
                    LoggerSpaceFactory4Log4jBuilder loggerSpaceFactory4Log4jBuilder = new LoggerSpaceFactory4Log4jBuilder(spacesMap.get(spaceId));
                    return loggerSpaceFactory4Log4jBuilder.build(spaceId.getSpaceName(), spaceClassloader);
                }
            }
            if (LogEnvUtils.isCommonsLoggingUsable(spaceClassloader)) {
                isLog4jDisable = System.getProperty("log4j.commons.logging.middleware.log.disable");
                if (isLog4jDisable != null && Boolean.TRUE.toString().equalsIgnoreCase(isLog4jDisable)) {
                    ReportUtil.reportWarn("Log4j-Sofa-Middleware-Log(But adapter commons-logging to slf4j) is disabled!  -Dlog4j.commons.logging.middleware.log.disable=true");
                } else {
                    ReportUtil.report("Actual binding is of type [ " + spaceId.toString() + " Log4j (Adapter commons-logging to slf4j)]");
                    LoggerSpaceFactory4CommonsLoggingBuilder loggerSpaceFactory4Log4jBuilder = new LoggerSpaceFactory4CommonsLoggingBuilder(spacesMap.get(spaceId));
                    return loggerSpaceFactory4Log4jBuilder.build(spaceId.getSpaceName(), spaceClassloader);
                }
            }
            ReportUtil.reportWarn("No log util is usable, Default app logger will be used.");
        }
        catch (Throwable e) {
            ReportUtil.reportError("Build ILoggerFactory error! Default app logger will be used.", e);
        }
        return NOP_LOGGER_FACTORY;
    }
}

