/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.env;

import com.alipay.sofa.common.log.Constants;
import com.alipay.sofa.common.utils.AssertUtil;
import com.alipay.sofa.common.utils.ReportUtil;

public final class LogEnvUtils {
    private LogEnvUtils() {
    }

    public static boolean isLogbackUsable(ClassLoader spaceClassloader) {
        AssertUtil.notNull(spaceClassloader);
        try {
            return spaceClassloader.loadClass("ch.qos.logback.classic.LoggerContext") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isLog4j2Usable(ClassLoader spaceClassloader) {
        AssertUtil.notNull(spaceClassloader);
        try {
            return spaceClassloader.loadClass("org.apache.logging.slf4j.Log4jLoggerFactory") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isLog4jUsable(ClassLoader spaceClassloader) {
        AssertUtil.notNull(spaceClassloader);
        try {
            return spaceClassloader.loadClass("org.slf4j.impl.Log4jLoggerFactory") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isCommonsLoggingUsable(ClassLoader spaceClassloader) {
        AssertUtil.notNull(spaceClassloader);
        try {
            return spaceClassloader.loadClass("org.slf4j.impl.JCLLoggerAdapter") != null && spaceClassloader.loadClass("org.apache.commons.logging.impl.Log4JLogger") != null && spaceClassloader.loadClass("org.apache.log4j.Logger") != null && spaceClassloader.loadClass("org.apache.commons.logging.Log") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void processGlobalSystemLogProperties() {
        if (System.getProperty("file.encoding") == null) {
            System.setProperty("file.encoding", "UTF-8");
        }
        String loggingPath = System.getProperty("logging.path");
        String loggingRoot = System.getProperty("loggingRoot");
        if (loggingPath != null && !loggingPath.equalsIgnoreCase(loggingRoot)) {
            System.setProperty("loggingRoot", loggingPath);
            return;
        }
        if (loggingRoot != null && (loggingPath == null || loggingPath.isEmpty())) {
            System.setProperty("logging.path", loggingRoot);
        }
        if ((loggingPath == null || loggingPath.isEmpty()) && (loggingRoot == null || loggingRoot.isEmpty())) {
            System.setProperty("logging.path", Constants.LOGGING_PATH_DEFAULT);
            System.setProperty("loggingRoot", Constants.LOGGING_PATH_DEFAULT);
        }
    }

    public static String getLogConfEnvSuffix(String spaceName) {
        String logEnvConfig = System.getProperty("log.env.suffix", "");
        String[] spaceNameToEnvSuffix = logEnvConfig.split("&");
        String suffix = null;
        for (int i = 0; i < spaceNameToEnvSuffix.length && suffix == null; ++i) {
            String envConf = spaceNameToEnvSuffix[i];
            String[] conf = envConf.split(":");
            if (conf.length != 2 || !conf[0].equals(spaceName)) continue;
            if (!conf[1].isEmpty()) {
                conf[1] = "." + conf[1];
            }
            suffix = conf[1];
        }
        String string = suffix = suffix == null ? "" : suffix;
        if (!suffix.isEmpty()) {
            ReportUtil.report(spaceName + " log configuration: " + "log-conf.xml" + suffix);
        }
        return suffix;
    }
}

