/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.factory;

import com.alipay.sofa.common.log.SpaceInfo;
import com.alipay.sofa.common.log.env.LogEnvUtils;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.log.factory.LoggerSpaceFactoryBuilder;
import com.alipay.sofa.common.utils.AssertUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoggerSpaceFactoryBuilder
implements LoggerSpaceFactoryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLoggerSpaceFactoryBuilder.class);
    private SpaceInfo spaceInfo;

    public AbstractLoggerSpaceFactoryBuilder(SpaceInfo space) {
        AssertUtil.notNull(space);
        this.spaceInfo = space;
    }

    @Override
    public AbstractLoggerSpaceFactory build(String spaceName, ClassLoader spaceClassloader) {
        AssertUtil.hasText(spaceName);
        AssertUtil.notNull(spaceClassloader);
        URL configFileUrl = this.getSpaceLogConfigFileURL(spaceClassloader, spaceName);
        this.specifySpaceLogConfigProperites(spaceName);
        return this.doBuild(spaceName, spaceClassloader, configFileUrl);
    }

    private URL getSpaceLogConfigFileURL(ClassLoader spaceClassloader, String spaceName) {
        URL configFileUrl;
        block7: {
            String suffix = LogEnvUtils.getLogConfEnvSuffix(spaceName);
            String logConfigLocation = spaceName.replace('.', '/') + "/" + "log" + "/" + this.getLoggingToolName() + "/" + "log-conf.xml" + suffix;
            String configProperyConfigLocation = spaceName.replace('.', '/') + "/" + "log" + "/" + this.getLoggingToolName() + "/" + "config.properties" + suffix;
            configFileUrl = null;
            try {
                ArrayList<URL> logConfigFileUrls = new ArrayList<URL>();
                Enumeration<URL> logUrls = spaceClassloader.getResources(logConfigLocation);
                if (logUrls != null) {
                    while (logUrls.hasMoreElements()) {
                        URL url = logUrls.nextElement();
                        logConfigFileUrls.add(url);
                    }
                }
                ArrayList<URL> configPropertyFileUrls = new ArrayList<URL>();
                Enumeration<URL> configUrls = spaceClassloader.getResources(configProperyConfigLocation);
                if (configUrls != null) {
                    while (configUrls.hasMoreElements()) {
                        URL url = configUrls.nextElement();
                        configPropertyFileUrls.add(url);
                    }
                }
                if ((configFileUrl = this.getResource(spaceClassloader, logConfigFileUrls, configPropertyFileUrls)) == null && suffix != null && !suffix.isEmpty()) {
                    logConfigLocation = spaceName.replace('.', '/') + "/" + "log" + "/" + this.getLoggingToolName() + "/" + String.format("log-conf-%s.xml", suffix.substring(1));
                    configFileUrl = spaceClassloader.getResource(logConfigLocation);
                }
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block7;
                logger.warn("Error when get resources of " + spaceName + " from classpath", (Throwable)e);
            }
        }
        AssertUtil.state(configFileUrl != null, this + " build error: No " + this.getLoggingToolName() + " config file (" + configFileUrl + ") found!");
        return configFileUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getResource(ClassLoader spaceClassloader, List<URL> logConfigFileUrls, List<URL> configPropertyFileUrls) throws IOException {
        if (logConfigFileUrls == null || logConfigFileUrls.isEmpty()) {
            return null;
        }
        if (logConfigFileUrls.size() == 1) {
            return logConfigFileUrls.get(0);
        }
        ArrayList<ConfigFile> configFiles = new ArrayList<ConfigFile>();
        for (URL logConfigUrl : logConfigFileUrls) {
            int priority = 0;
            if (configPropertyFileUrls != null) {
                for (URL configPropertyUrl : configPropertyFileUrls) {
                    String absoluteLogPath;
                    String absoluteConfigPath = new File(configPropertyUrl.getFile()).getParentFile().getAbsolutePath();
                    if (!absoluteConfigPath.equals(absoluteLogPath = new File(logConfigUrl.getFile()).getParentFile().getAbsolutePath())) continue;
                    InputStream inputStream = null;
                    try {
                        URLConnection uConn = configPropertyUrl.openConnection();
                        uConn.setUseCaches(false);
                        inputStream = uConn.getInputStream();
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        String priorityStr = properties.getProperty("priority");
                        if (priorityStr == null) break;
                        priority = Integer.parseInt(priorityStr);
                        break;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
            }
            ConfigFile configFile = new ConfigFile(priority, logConfigUrl);
            if (logger.isDebugEnabled()) {
                logger.debug("Find url {}, priority is {}", (Object)logConfigUrl, (Object)priority);
            }
            configFiles.add(configFile);
        }
        Collections.sort(configFiles, new Comparator<ConfigFile>(){

            @Override
            public int compare(ConfigFile o1, ConfigFile o2) {
                return o2.priority - o1.priority;
            }
        });
        return ((ConfigFile)configFiles.get((int)0)).url;
    }

    private void specifySpaceLogConfigProperites(String spaceName) {
        String loggingLevelKey;
        Iterator<Map.Entry<Object, Object>> iterator = this.spaceInfo.properties().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (!System.getProperties().containsKey(entry.getKey())) continue;
            iterator.remove();
            logger.warn("Props key {}  is also already existed in System.getProps ({}:{}),so use it!", new Object[]{entry.getKey(), entry.getKey(), System.getProperty((String)entry.getKey())});
        }
        String loggingPathKey = "logging.path." + spaceName;
        if (System.getProperty(loggingPathKey) == null && System.getProperty("logging.path") != null && this.spaceInfo.properties().getProperty(loggingPathKey) == null) {
            this.spaceInfo.properties().setProperty(loggingPathKey, System.getProperty("logging.path"));
        }
        if (System.getProperty(loggingLevelKey = "logging.level." + spaceName) == null && this.spaceInfo.properties().getProperty(loggingLevelKey) == null) {
            this.spaceInfo.properties().setProperty(loggingLevelKey, "INFO");
        }
    }

    protected abstract AbstractLoggerSpaceFactory doBuild(String var1, ClassLoader var2, URL var3);

    protected abstract String getLoggingToolName();

    protected Properties getProperties() {
        return this.spaceInfo.properties();
    }

    private class ConfigFile {
        final int priority;
        final URL url;

        ConfigFile(int priority, URL url) {
            this.priority = priority;
            this.url = url;
        }
    }
}

