/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.container;

import com.alipay.sofa.rpc.boot.common.SofaBootRpcRuntimeException;
import com.alipay.sofa.rpc.boot.config.RegistryConfigureProcessor;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcProperties;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.log.LogCodes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class RegistryConfigContainer {
    private static final String DEFAULT_REGISTRY = "DEFAULT";
    @Autowired
    private SofaBootRpcProperties sofaBootRpcProperties;
    @Resource(name="registryConfigMap")
    private Map<String, RegistryConfigureProcessor> registryConfigMap = new HashMap<String, RegistryConfigureProcessor>(4);
    private Map<String, RegistryConfig> registryConfigs = new ConcurrentHashMap<String, RegistryConfig>();
    private String customDefaultRegistry = System.getProperty("default.registry");
    private String customDefaultRegistryAddress;

    public RegistryConfigContainer() {
        if (StringUtils.isNotBlank((CharSequence)this.customDefaultRegistry)) {
            this.customDefaultRegistryAddress = System.getProperty(this.customDefaultRegistry);
        }
    }

    public RegistryConfig getRegistryConfig(String registryAlias) throws SofaBootRpcRuntimeException {
        int endIndex;
        String currentDefaultAlias = StringUtils.isNotBlank((CharSequence)this.customDefaultRegistry) ? this.customDefaultRegistry : DEFAULT_REGISTRY;
        if (StringUtils.isEmpty((CharSequence)registryAlias)) {
            registryAlias = currentDefaultAlias;
        }
        if (this.registryConfigs.get(registryAlias) != null) {
            return this.registryConfigs.get(registryAlias);
        }
        String registryAddress = DEFAULT_REGISTRY.equalsIgnoreCase(registryAlias) ? this.sofaBootRpcProperties.getRegistryAddress() : (registryAlias.equals(this.customDefaultRegistry) ? this.customDefaultRegistryAddress : this.sofaBootRpcProperties.getRegistries().get(registryAlias));
        String registryProtocol = StringUtils.isBlank((CharSequence)registryAddress) ? "local" : ((endIndex = registryAddress.indexOf("://")) != -1 ? registryAddress.substring(0, endIndex) : registryAlias);
        if (this.registryConfigMap.get(registryProtocol) != null) {
            RegistryConfigureProcessor registryConfigureProcessor = this.registryConfigMap.get(registryProtocol);
            RegistryConfig registryConfig = registryConfigureProcessor.buildFromAddress(registryAddress);
            this.registryConfigs.put(registryAlias, registryConfig);
            Environment environment = this.sofaBootRpcProperties.getEnvironment();
            if (environment.containsProperty("rpc_register_registry_ignore") && Boolean.TRUE.toString().equalsIgnoreCase(environment.getProperty("rpc_register_registry_ignore"))) {
                registryConfig.setRegister(false);
            }
            return registryConfig;
        }
        throw new SofaBootRpcRuntimeException(LogCodes.getLog((String)"010060028", (Object[])new Object[]{registryAddress}));
    }

    public RegistryConfig getRegistryConfig() throws SofaBootRpcRuntimeException {
        if (StringUtils.isNotBlank((CharSequence)this.customDefaultRegistry)) {
            return this.getRegistryConfig(this.customDefaultRegistry);
        }
        return this.getRegistryConfig(DEFAULT_REGISTRY);
    }

    public void removeAllRegistryConfig() {
        this.registryConfigMap.clear();
    }

    public Map<String, RegistryConfigureProcessor> getRegistryConfigMap() {
        return this.registryConfigMap;
    }

    public void setRegistryConfigMap(Map<String, RegistryConfigureProcessor> registryConfigMap) {
        this.registryConfigMap = registryConfigMap;
    }

    public Map<String, RegistryConfig> getRegistryConfigs() {
        return this.registryConfigs;
    }

    public boolean isMeshEnabled(String protocol) {
        String meshConfig = this.sofaBootRpcProperties.getEnableMesh();
        Map<String, String> registries = this.sofaBootRpcProperties.getRegistries();
        if (StringUtils.isNotBlank((CharSequence)meshConfig) && registries != null && registries.get("mesh") != null) {
            if (meshConfig.equalsIgnoreCase("all")) {
                return true;
            }
            List<String> meshEnableProtocols = Arrays.asList(meshConfig.split(","));
            for (String meshProtocol : meshEnableProtocols) {
                if (!StringUtils.equals((CharSequence)meshProtocol, (CharSequence)protocol)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

