/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.runtime.adapter;

import com.alipay.sofa.rpc.boot.container.ConsumerConfigContainer;
import com.alipay.sofa.rpc.boot.container.ProviderConfigContainer;
import com.alipay.sofa.rpc.boot.runtime.adapter.helper.ConsumerConfigHelper;
import com.alipay.sofa.rpc.boot.runtime.adapter.helper.ProviderConfigHelper;
import com.alipay.sofa.rpc.boot.runtime.adapter.processor.ProcessorContainer;
import com.alipay.sofa.rpc.boot.runtime.binding.RpcBinding;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.RegistryFactory;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.binding.BindingAdapter;
import com.alipay.sofa.runtime.spi.binding.Contract;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import java.util.List;
import org.springframework.context.ApplicationContext;

public abstract class RpcBindingAdapter
implements BindingAdapter<RpcBinding> {
    public void preOutBinding(Object contract, RpcBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        ApplicationContext applicationContext = sofaRuntimeContext.getSofaRuntimeManager().getRootApplicationContext();
        ProviderConfigContainer providerConfigContainer = (ProviderConfigContainer)applicationContext.getBean(ProviderConfigContainer.class);
        String uniqueName = providerConfigContainer.createUniqueName((Contract)contract, binding);
        ProviderConfigHelper providerConfigHelper = (ProviderConfigHelper)applicationContext.getBean(ProviderConfigHelper.class);
        ProviderConfig providerConfig = providerConfigHelper.getProviderConfig((Contract)contract, binding, target);
        try {
            providerConfigContainer.addProviderConfig(uniqueName, providerConfig);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"010000007"), (Throwable)e);
        }
    }

    public Object outBinding(Object contract, RpcBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        ApplicationContext applicationContext = sofaRuntimeContext.getSofaRuntimeManager().getRootApplicationContext();
        ProviderConfigContainer providerConfigContainer = (ProviderConfigContainer)applicationContext.getBean(ProviderConfigContainer.class);
        ProcessorContainer processorContainer = (ProcessorContainer)applicationContext.getBean(ProcessorContainer.class);
        String uniqueName = providerConfigContainer.createUniqueName((Contract)contract, binding);
        ProviderConfig providerConfig = providerConfigContainer.getProviderConfig(uniqueName);
        processorContainer.processorProvider(providerConfig);
        if (providerConfig == null) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"020100001", (Object[])new Object[]{uniqueName}));
        }
        try {
            providerConfig.export();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"010000007"), (Throwable)e);
        }
        if (providerConfigContainer.isAllowPublish()) {
            providerConfig.setRegister(true);
            List registrys = providerConfig.getRegistry();
            for (RegistryConfig registryConfig : registrys) {
                Registry registry = RegistryFactory.getRegistry((RegistryConfig)registryConfig);
                registry.init();
                registry.start();
                registry.register(providerConfig);
            }
        }
        return Boolean.TRUE;
    }

    public void preUnoutBinding(Object contract, RpcBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        ApplicationContext applicationContext = sofaRuntimeContext.getSofaRuntimeManager().getRootApplicationContext();
        ProviderConfigHelper providerConfigHelper = (ProviderConfigHelper)applicationContext.getBean(ProviderConfigHelper.class);
        ProviderConfig providerConfig = providerConfigHelper.getProviderConfig((Contract)contract, binding, target);
        try {
            providerConfig.unExport();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"010000008"), (Throwable)e);
        }
    }

    public void postUnoutBinding(Object contract, RpcBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        ApplicationContext applicationContext = sofaRuntimeContext.getSofaRuntimeManager().getRootApplicationContext();
        ProviderConfigHelper providerConfigHelper = (ProviderConfigHelper)applicationContext.getBean(ProviderConfigHelper.class);
        ProviderConfigContainer providerConfigContainer = (ProviderConfigContainer)applicationContext.getBean(ProviderConfigContainer.class);
        ProviderConfig metadata = providerConfigHelper.getProviderConfig((Contract)contract, binding, target);
        try {
            String key = providerConfigContainer.createUniqueName((Contract)contract, binding);
            List servers = providerConfigContainer.getProviderConfig(key).getServer();
            for (ServerConfig server : servers) {
                server.getServer().unRegisterProcessor(metadata, false);
            }
            providerConfigContainer.removeProviderConfig(key);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"010000009"), (Throwable)e);
        }
    }

    public Object inBinding(Object contract, RpcBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        ApplicationContext applicationContext = sofaRuntimeContext.getSofaRuntimeManager().getRootApplicationContext();
        ConsumerConfigHelper consumerConfigHelper = (ConsumerConfigHelper)applicationContext.getBean(ConsumerConfigHelper.class);
        ConsumerConfigContainer consumerConfigContainer = (ConsumerConfigContainer)applicationContext.getBean(ConsumerConfigContainer.class);
        ProcessorContainer processorContainer = (ProcessorContainer)applicationContext.getBean(ProcessorContainer.class);
        ConsumerConfig consumerConfig = consumerConfigHelper.getConsumerConfig((Contract)contract, binding);
        processorContainer.processorConsumer(consumerConfig);
        if ("local".equalsIgnoreCase(binding.getRpcBindingParam().getMockMode())) {
            consumerConfig.setMockRef(consumerConfigHelper.getMockRef(binding, applicationContext));
        }
        consumerConfigContainer.addConsumerConfig((Binding)binding, consumerConfig);
        try {
            Object result = consumerConfig.refer();
            binding.setConsumerConfig(consumerConfig);
            return result;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"010010009"), (Throwable)e);
        }
    }

    public void unInBinding(Object contract, RpcBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        try {
            ApplicationContext applicationContext = sofaRuntimeContext.getSofaRuntimeManager().getRootApplicationContext();
            ConsumerConfigContainer consumerConfigContainer = (ConsumerConfigContainer)applicationContext.getBean(ConsumerConfigContainer.class);
            consumerConfigContainer.removeAndUnReferConsumerConfig((Binding)binding);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"010010010"), (Throwable)e);
        }
    }

    public Class<RpcBinding> getBindingClass() {
        return RpcBinding.class;
    }
}

