/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.runtime.adapter.processor;

import com.alipay.sofa.rpc.boot.runtime.adapter.processor.ConsumerConfigProcessor;
import com.alipay.sofa.rpc.boot.runtime.adapter.processor.ProviderConfigProcessor;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import org.springframework.beans.factory.annotation.Value;

public class DynamicConfigProcessor
implements ConsumerConfigProcessor,
ProviderConfigProcessor {
    @Value(value="${com.alipay.sofa.rpc.dynamic-config}")
    private String dynamicConfig;

    @Override
    public void processorConsumer(ConsumerConfig consumerConfig) {
        this.setDynamicConfig((AbstractInterfaceConfig)consumerConfig);
    }

    @Override
    public void processorProvider(ProviderConfig providerConfig) {
        this.setDynamicConfig((AbstractInterfaceConfig)providerConfig);
    }

    private void setDynamicConfig(AbstractInterfaceConfig config) {
        String configAlias = config.getParameter("dynamicAlias");
        if (StringUtils.isBlank((CharSequence)configAlias) && StringUtils.isNotBlank((CharSequence)this.dynamicConfig)) {
            config.setParameter("dynamicAlias", this.dynamicConfig);
        }
    }

    public String getDynamicConfig() {
        return this.dynamicConfig;
    }

    public void setDynamicConfig(String dynamicConfig) {
        this.dynamicConfig = dynamicConfig;
    }
}

