/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.AbstractCluster;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.util.ArrayList;

@Extension(value="failover")
public class FailoverCluster
extends AbstractCluster {
    private static final Logger LOGGER = LoggerFactory.getLogger(FailoverCluster.class);

    public FailoverCluster(ConsumerBootstrap consumerBootstrap) {
        super(consumerBootstrap);
    }

    @Override
    public SofaResponse doInvoke(SofaRequest request) throws SofaRpcException {
        String methodName = request.getMethodName();
        int retries = this.consumerConfig.getMethodRetries(methodName);
        int time = 0;
        SofaRpcException throwable = null;
        ArrayList<ProviderInfo> invokedProviderInfos = new ArrayList<ProviderInfo>(retries + 1);
        do {
            ProviderInfo providerInfo;
            block13: {
                providerInfo = this.select(request, invokedProviderInfos);
                try {
                    SofaResponse response = this.filterChain(providerInfo, request);
                    if (response != null) {
                        if (throwable != null && LOGGER.isWarnEnabled(this.consumerConfig.getAppName())) {
                            LOGGER.warnWithApp(this.consumerConfig.getAppName(), LogCodes.getLog("01201", throwable.getClass() + ":" + throwable.getMessage(), invokedProviderInfos));
                        }
                        SofaResponse sofaResponse = response;
                        return sofaResponse;
                    }
                    throwable = new SofaRpcException(299, "Failed to call " + request.getInterfaceName() + "." + methodName + " on remote server " + providerInfo + ", return null");
                }
                catch (SofaRpcException e) {
                    if (e.getErrorType() == 100 || e.getErrorType() == 200) {
                        throwable = e;
                        ++time;
                        break block13;
                    }
                    throw e;
                }
                catch (Exception e) {
                    throw new SofaRpcException(299, "Failed to call " + request.getInterfaceName() + "." + request.getMethodName() + " on remote server: " + providerInfo + ", cause by unknown exception: " + e.getClass().getName() + ", message is: " + e.getMessage(), e);
                }
                finally {
                    if (RpcInternalContext.isAttachmentEnable()) {
                        RpcInternalContext.getContext().setAttachment("_invoke_times", time + 1);
                    }
                }
            }
            invokedProviderInfos.add(providerInfo);
        } while (time <= retries);
        throw throwable;
    }
}

