/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec;

import com.alipay.sofa.rpc.codec.Serializer;
import com.alipay.sofa.rpc.common.struct.TwoWayMap;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoader;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.ext.ExtensionLoaderListener;
import java.util.concurrent.ConcurrentHashMap;

public final class SerializerFactory {
    private static final ConcurrentHashMap<Byte, Serializer> TYPE_SERIALIZER_MAP = new ConcurrentHashMap();
    private static final TwoWayMap<String, Byte> TYPE_CODE_MAP = new TwoWayMap();
    private static final ExtensionLoader<Serializer> EXTENSION_LOADER = SerializerFactory.buildLoader();

    private static ExtensionLoader<Serializer> buildLoader() {
        return ExtensionLoaderFactory.getExtensionLoader(Serializer.class, new ExtensionLoaderListener<Serializer>(){

            @Override
            public void onLoad(ExtensionClass<Serializer> extensionClass) {
                TYPE_SERIALIZER_MAP.put(extensionClass.getCode(), extensionClass.getExtInstance());
                TYPE_CODE_MAP.put(extensionClass.getAlias(), extensionClass.getCode());
            }
        });
    }

    public static Serializer getSerializer(String alias) {
        return EXTENSION_LOADER.getExtension(alias);
    }

    public static Serializer getSerializer(byte type) {
        return TYPE_SERIALIZER_MAP.get(type);
    }

    public static Byte getCodeByAlias(String serializer) {
        return TYPE_CODE_MAP.get(serializer);
    }

    public static String getAliasByCode(byte code) {
        return TYPE_CODE_MAP.getKey(code);
    }
}

