/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.module;

import com.alipay.sofa.rpc.client.aft.Regulator;
import com.alipay.sofa.rpc.client.aft.impl.TimeWindowRegulator;
import com.alipay.sofa.rpc.event.ClientAsyncReceiveEvent;
import com.alipay.sofa.rpc.event.ClientSyncReceiveEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.FaultToleranceSubscriber;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.module.Module;

@Extension(value="fault-tolerance")
public class FaultToleranceModule
implements Module {
    private FaultToleranceSubscriber subscriber;
    private Regulator regulator = new TimeWindowRegulator();

    @Override
    public boolean needLoad() {
        return true;
    }

    @Override
    public void install() {
        this.subscriber = new FaultToleranceSubscriber();
        EventBus.register(ClientSyncReceiveEvent.class, this.subscriber);
        EventBus.register(ClientAsyncReceiveEvent.class, this.subscriber);
        this.regulator = new TimeWindowRegulator();
        this.regulator.init();
    }

    @Override
    public void uninstall() {
        if (this.subscriber != null) {
            EventBus.unRegister(ClientSyncReceiveEvent.class, this.subscriber);
            EventBus.unRegister(ClientAsyncReceiveEvent.class, this.subscriber);
        }
        this.regulator.destroy();
    }

    public Regulator getRegulator() {
        return this.regulator;
    }
}

