/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.aliyun.credentials.utils.AuthUtils;
import com.aliyun.credentials.utils.StringUtils;

public class SystemPropertiesCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    @Override
    public CredentialModel getCredentials() {
        if (!"default".equals(AuthUtils.getClientType())) {
            return null;
        }
        String accessKeyId = System.getProperty("alibabacloud.accessKeyId");
        String accessKeySecret = System.getProperty("alibabacloud.accessKeySecret");
        if (!StringUtils.isEmpty(System.getProperty("alibabacloud.accessKeyIdSecret"))) {
            accessKeySecret = System.getProperty("alibabacloud.accessKeyIdSecret");
        }
        String securityToken = System.getProperty("alibabacloud.sessionToken");
        if (StringUtils.isEmpty(accessKeyId) || StringUtils.isEmpty(accessKeySecret)) {
            return null;
        }
        if (!StringUtils.isEmpty(securityToken)) {
            return CredentialModel.builder().accessKeyId(accessKeyId).accessKeySecret(accessKeySecret).securityToken(securityToken).type("sts").build();
        }
        return CredentialModel.builder().accessKeyId(accessKeyId).accessKeySecret(accessKeySecret).type("access_key").build();
    }
}

