package com.aliyun.dashvector.models;

import lombok.Builder;
import lombok.Getter;

/**
 * @author jiliang.ljl
 * @date 2024/7/18
 */
@Builder
@Getter
public class RrfRanker implements Ranker {
    @Builder.Default
    private int rankConstant = 60;

    @Override
    public com.aliyun.dashvector.proto.Ranker toProto() {
        return com.aliyun.dashvector.proto.Ranker.newBuilder()
                .setRankerName("rrf")
                .putRankerParams("rank_constant", String.valueOf(rankConstant))
                .build();
    }
}
