package com.aliyun.dashvector.models;

import com.aliyun.dashvector.proto.CollectionInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Builder;
import lombok.Getter;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/**
 * @author jiliang.ljl
 * @date 2024/7/17
 */
@Builder
@Getter
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class VectorParam {
    private int dimension;
    @Builder.Default @NonNull
    private CollectionInfo.DataType dataType = CollectionInfo.DataType.FLOAT;
    @Builder.Default @NonNull
    private CollectionInfo.Metric metric = CollectionInfo.Metric.cosine;
    @Builder.Default
    private String quantizeType= StringUtils.EMPTY;
}
