package com.aliyun.dashvector.models;

import lombok.Builder;
import lombok.Getter;

import java.util.Map;
import java.util.Objects;

/**
 * @author jiliang.ljl
 * @date 2024/7/18
 */
@Builder
@Getter
public class WeightedRanker implements Ranker {
    private Map<String, Float> weights;

    private String weightsToJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<String, Float> entry : weights.entrySet()) {
            sb.append("\"").append(entry.getKey()).append("\":").append(entry.getValue()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public com.aliyun.dashvector.proto.Ranker toProto() {
        com.aliyun.dashvector.proto.Ranker.Builder builder = com.aliyun.dashvector.proto.Ranker.newBuilder()
                .setRankerName("weighted");
        if (Objects.nonNull(weights)) {
            builder.putRankerParams("weights", weightsToJson());
        }
        return builder.build();
    }
}
