/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector;

import com.aliyun.dashvector.common.ErrorCode;
import com.aliyun.dashvector.models.CollectionMeta;
import com.aliyun.dashvector.models.CollectionStats;
import com.aliyun.dashvector.models.Doc;
import com.aliyun.dashvector.models.DocOpResult;
import com.aliyun.dashvector.models.Group;
import com.aliyun.dashvector.models.PartitionStats;
import com.aliyun.dashvector.models.requests.DeleteDocRequest;
import com.aliyun.dashvector.models.requests.FetchDocRequest;
import com.aliyun.dashvector.models.requests.QueryDocGroupByRequest;
import com.aliyun.dashvector.models.requests.QueryDocRequest;
import com.aliyun.dashvector.models.requests.UpsertDocRequest;
import com.aliyun.dashvector.models.responses.Response;
import com.aliyun.dashvector.proto.CreatePartitionRequest;
import com.aliyun.dashvector.proto.CreatePartitionResponse;
import com.aliyun.dashvector.proto.DashVectorServiceGrpc;
import com.aliyun.dashvector.proto.DeleteDocResponse;
import com.aliyun.dashvector.proto.DeletePartitionRequest;
import com.aliyun.dashvector.proto.DeletePartitionResponse;
import com.aliyun.dashvector.proto.DescribePartitionRequest;
import com.aliyun.dashvector.proto.DescribePartitionResponse;
import com.aliyun.dashvector.proto.DocOpResult;
import com.aliyun.dashvector.proto.FetchDocResponse;
import com.aliyun.dashvector.proto.InsertDocRequest;
import com.aliyun.dashvector.proto.InsertDocResponse;
import com.aliyun.dashvector.proto.ListPartitionsRequest;
import com.aliyun.dashvector.proto.ListPartitionsResponse;
import com.aliyun.dashvector.proto.QueryDocGroupByResponse;
import com.aliyun.dashvector.proto.QueryDocResponse;
import com.aliyun.dashvector.proto.StatsCollectionRequest;
import com.aliyun.dashvector.proto.StatsCollectionResponse;
import com.aliyun.dashvector.proto.StatsPartitionRequest;
import com.aliyun.dashvector.proto.StatsPartitionResponse;
import com.aliyun.dashvector.proto.Status;
import com.aliyun.dashvector.proto.UpdateDocRequest;
import com.aliyun.dashvector.proto.UpdateDocResponse;
import com.aliyun.dashvector.proto.UpsertDocResponse;
import com.aliyun.dashvector.shaded.io.grpc.Metadata;
import com.aliyun.dashvector.shaded.io.grpc.stub.MetadataUtils;
import com.aliyun.dashvector.utils.Validator;
import com.aliyun.dashvector.validator.ValidatorFactory;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import lombok.NonNull;

public class DashVectorCollection {
    private String name;
    private CollectionMeta collectionMeta;
    private final int code;
    private final String message;
    private final String requestId;
    private DashVectorServiceGrpc.DashVectorServiceFutureStub stub;

    public DashVectorCollection(Response<CollectionMeta> response, DashVectorServiceGrpc.DashVectorServiceFutureStub stub) {
        this.code = response.getCode();
        this.message = response.getMessage();
        this.requestId = response.getRequestId();
        if (response.isSuccess().booleanValue()) {
            Metadata metadata = new Metadata();
            CollectionMeta collectionMeta = response.getOutput();
            metadata.put(Metadata.Key.of("collection-name", Metadata.ASCII_STRING_MARSHALLER), collectionMeta.getName());
            this.name = collectionMeta.getName();
            this.stub = (DashVectorServiceGrpc.DashVectorServiceFutureStub)stub.withInterceptors(MetadataUtils.newAttachHeadersInterceptor(metadata));
            this.collectionMeta = collectionMeta;
        }
    }

    public Boolean isSuccess() {
        return this.code == ErrorCode.SUCCESS.getCode();
    }

    public Response<List<DocOpResult>> insert(@NonNull com.aliyun.dashvector.models.requests.InsertDocRequest insertDocRequest) {
        if (insertDocRequest == null) {
            throw new NullPointerException("insertDocRequest is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Response.create(this.code, this.message, this.requestId, null);
        }
        try {
            return (Response)this.insertAsync(insertDocRequest).get();
        }
        catch (Exception e) {
            return Response.failed(e);
        }
    }

    public ListenableFuture<Response<List<DocOpResult>>> insertAsync(@NonNull com.aliyun.dashvector.models.requests.InsertDocRequest insertDocRequest) {
        if (insertDocRequest == null) {
            throw new NullPointerException("insertDocRequest is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Futures.immediateFuture(Response.create(this.code, this.message, this.requestId, null));
        }
        try {
            ListenableFuture<InsertDocResponse> response = this.stub.insertDoc((InsertDocRequest)insertDocRequest.toProto(this.collectionMeta, DocOpResult.DocOp.insert));
            return Futures.transform(response, Response::success, (Executor)MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            return Futures.immediateFuture(Response.failed(e));
        }
    }

    public Response<List<DocOpResult>> upsert(@NonNull UpsertDocRequest upsertDocRequest) {
        if (upsertDocRequest == null) {
            throw new NullPointerException("upsertDocRequest is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Response.create(this.code, this.message, this.requestId, null);
        }
        try {
            return (Response)this.upsertAsync(upsertDocRequest).get();
        }
        catch (Exception e) {
            return Response.failed(e);
        }
    }

    public ListenableFuture<Response<List<DocOpResult>>> upsertAsync(@NonNull UpsertDocRequest upsertDocRequest) {
        if (upsertDocRequest == null) {
            throw new NullPointerException("upsertDocRequest is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Futures.immediateFuture(Response.create(this.code, this.message, this.requestId, null));
        }
        try {
            ListenableFuture<UpsertDocResponse> response = this.stub.upsertDoc((com.aliyun.dashvector.proto.UpsertDocRequest)upsertDocRequest.toProto(this.collectionMeta, DocOpResult.DocOp.upsert));
            return Futures.transform(response, Response::success, (Executor)MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            return Futures.immediateFuture(Response.failed(e));
        }
    }

    public Response<List<DocOpResult>> update(@NonNull com.aliyun.dashvector.models.requests.UpdateDocRequest updateDocRequest) {
        if (updateDocRequest == null) {
            throw new NullPointerException("updateDocRequest is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Response.create(this.code, this.message, this.requestId, null);
        }
        try {
            return (Response)this.updateAsync(updateDocRequest).get();
        }
        catch (Exception e) {
            return Response.failed(e);
        }
    }

    public ListenableFuture<Response<List<DocOpResult>>> updateAsync(@NonNull com.aliyun.dashvector.models.requests.UpdateDocRequest updateDocRequest) {
        if (updateDocRequest == null) {
            throw new NullPointerException("updateDocRequest is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Futures.immediateFuture(Response.create(this.code, this.message, this.requestId, null));
        }
        try {
            ListenableFuture<UpdateDocResponse> response = this.stub.updateDoc((UpdateDocRequest)updateDocRequest.toProto(this.collectionMeta, DocOpResult.DocOp.update));
            return Futures.transform(response, Response::success, (Executor)MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            return Futures.immediateFuture(Response.failed(e));
        }
    }

    public Response<List<Doc>> query(@NonNull QueryDocRequest queryDocRequest) {
        if (queryDocRequest == null) {
            throw new NullPointerException("queryDocRequest is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Response.create(this.code, this.message, this.requestId, null);
        }
        try {
            return (Response)this.queryAsync(queryDocRequest).get();
        }
        catch (Exception e) {
            return Response.failed(e);
        }
    }

    public ListenableFuture<Response<List<Doc>>> queryAsync(@NonNull QueryDocRequest queryDocRequest) {
        if (queryDocRequest == null) {
            throw new NullPointerException("queryDocRequest is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Futures.immediateFuture(Response.create(this.code, this.message, this.requestId, null));
        }
        try {
            ValidatorFactory.create(this.collectionMeta).validateQueryDocRequest(queryDocRequest);
            ListenableFuture<QueryDocResponse> future = this.stub.queryDoc(queryDocRequest.toProto(this.collectionMeta));
            Function<QueryDocResponse, Response> transformFunc = queryDocResponse -> Response.success(queryDocResponse, this.collectionMeta);
            return Futures.transform(future, transformFunc::apply, (Executor)MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            return Futures.immediateFuture(Response.failed(e));
        }
    }

    public Response<List<Group>> queryGroupBy(@NonNull QueryDocGroupByRequest queryDocGroupByRequest) {
        if (queryDocGroupByRequest == null) {
            throw new NullPointerException("queryDocGroupByRequest is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Response.create(this.code, this.message, this.requestId, null);
        }
        try {
            return (Response)this.queryGroupByAsync(queryDocGroupByRequest).get();
        }
        catch (Exception e) {
            return Response.failed(e);
        }
    }

    public ListenableFuture<Response<List<Group>>> queryGroupByAsync(@NonNull QueryDocGroupByRequest queryDocGroupByRequest) {
        if (queryDocGroupByRequest == null) {
            throw new NullPointerException("queryDocGroupByRequest is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Futures.immediateFuture(Response.create(this.code, this.message, this.requestId, null));
        }
        try {
            ValidatorFactory.create(this.collectionMeta).validateQueryDocGroupByRequest(queryDocGroupByRequest);
            ListenableFuture<QueryDocGroupByResponse> future = this.stub.queryDocGroupBy(queryDocGroupByRequest.toProto(this.collectionMeta));
            Function<QueryDocGroupByResponse, Response> transformFunc = queryDocResponse -> Response.success(queryDocResponse, this.collectionMeta);
            return Futures.transform(future, transformFunc::apply, (Executor)MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            return Futures.immediateFuture(Response.failed(e));
        }
    }

    public Response<List<DocOpResult>> delete(@NonNull DeleteDocRequest deleteDocRequest) {
        if (deleteDocRequest == null) {
            throw new NullPointerException("deleteDocRequest is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Response.create(this.code, this.message, this.requestId, null);
        }
        try {
            return (Response)this.deleteAsync(deleteDocRequest).get();
        }
        catch (Exception e) {
            return Response.failed(e);
        }
    }

    public ListenableFuture<Response<List<DocOpResult>>> deleteAsync(@NonNull DeleteDocRequest deleteDocRequest) {
        if (deleteDocRequest == null) {
            throw new NullPointerException("deleteDocRequest is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Futures.immediateFuture(Response.create(this.code, this.message, this.requestId, null));
        }
        try {
            ListenableFuture<DeleteDocResponse> future = this.stub.deleteDoc(deleteDocRequest.toProto());
            return Futures.transform(future, Response::success, (Executor)MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            return Futures.immediateFuture(Response.failed(e));
        }
    }

    public Response<Map<String, Doc>> fetch(@NonNull FetchDocRequest fetchDocRequest) {
        if (fetchDocRequest == null) {
            throw new NullPointerException("fetchDocRequest is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Response.create(this.code, this.message, this.requestId, null);
        }
        try {
            return (Response)this.fetchAsync(fetchDocRequest).get();
        }
        catch (Exception e) {
            return Response.failed(e);
        }
    }

    public ListenableFuture<Response<Map<String, Doc>>> fetchAsync(@NonNull FetchDocRequest fetchDocRequest) {
        if (fetchDocRequest == null) {
            throw new NullPointerException("fetchDocRequest is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Futures.immediateFuture(Response.create(this.code, this.message, this.requestId, null));
        }
        try {
            ListenableFuture<FetchDocResponse> future = this.stub.fetchDoc(fetchDocRequest.toProto());
            Function<FetchDocResponse, Response> transformFunc = fetchDocResponse -> Response.success(fetchDocResponse, this.collectionMeta);
            return Futures.transform(future, transformFunc::apply, (Executor)MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            return Futures.immediateFuture(Response.failed(e));
        }
    }

    public Response<CollectionStats> stats() {
        if (!this.isSuccess().booleanValue()) {
            return Response.create(this.code, this.message, this.requestId, null);
        }
        try {
            StatsCollectionResponse response = (StatsCollectionResponse)this.stub.statsCollection(StatsCollectionRequest.getDefaultInstance()).get();
            return Response.success(response);
        }
        catch (Exception e) {
            return Response.failed(e);
        }
    }

    public Response<Void> createPartition(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.createPartition(name, null);
    }

    public Response<Void> createPartition(@NonNull String name, Integer timeout) {
        CreatePartitionResponse response;
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Response.create(this.code, this.message, this.requestId, null);
        }
        try {
            Validator.verifyPartitionName(name);
            CreatePartitionRequest request = CreatePartitionRequest.newBuilder().setName(name).build();
            response = (CreatePartitionResponse)this.stub.createPartition(request).get();
            if (response.getCode() != ErrorCode.SUCCESS.getCode() && Objects.isNull(timeout)) {
                return Response.create(response.getCode(), response.getMessage(), response.getRequestId(), null);
            }
        }
        catch (Exception e) {
            return Response.failed(e);
        }
        int createTimeout = Objects.isNull(timeout) ? 0 : timeout;
        int retryCount = 0;
        do {
            Response<Status> describeResponse;
            if ((describeResponse = this.describePartition(name)).getCode() == ErrorCode.SUCCESS.getCode()) {
                String status = describeResponse.getOutput().name();
                if ("ERROR".equals(status) || "DROPPING".equals(status)) {
                    return Response.create(ErrorCode.UNREADY_PARTITION.getCode(), String.format("DashVectorSDK collection(%s)'s partition(%s) unready. Status is %s ", this.collectionMeta.getName(), name, status), describeResponse.getRequestId(), null);
                }
                if ("SERVING".equals(status)) {
                    return Response.success(response.getCode(), response.getMessage(), response.getRequestId());
                }
            } else {
                ++retryCount;
            }
            if (retryCount > 3) {
                return Response.create(describeResponse.getCode(), String.format("DashVectorSDK Get Partition(%s) Status create", name), null, null);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                return Response.failed(e);
            }
        } while (Objects.isNull(timeout) || (createTimeout -= 5) >= 0);
        return Response.create(ErrorCode.TIMEOUT.getCode(), String.format("DashVectorSDK Get Partition(%s) Status Timeout.", name), null, null);
    }

    public Response<Status> describePartition(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Response.create(this.code, this.message, this.requestId, null);
        }
        try {
            Validator.verifyPartitionName(name);
            DescribePartitionRequest req = DescribePartitionRequest.newBuilder().setName(name).build();
            DescribePartitionResponse response = (DescribePartitionResponse)this.stub.describePartition(req).get();
            return Response.success(response);
        }
        catch (Exception e) {
            return Response.failed(e);
        }
    }

    public Response<List<String>> listPartitions() {
        if (!this.isSuccess().booleanValue()) {
            return Response.create(this.code, this.message, this.requestId, null);
        }
        try {
            ListPartitionsResponse response = (ListPartitionsResponse)this.stub.listPartitions(ListPartitionsRequest.getDefaultInstance()).get();
            return Response.success(response);
        }
        catch (Exception e) {
            return Response.failed(e);
        }
    }

    public Response<PartitionStats> statsPartition(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Response.create(this.code, this.message, this.requestId, null);
        }
        try {
            Validator.verifyPartitionName(name);
            StatsPartitionRequest req = StatsPartitionRequest.newBuilder().setName(name).build();
            StatsPartitionResponse response = (StatsPartitionResponse)this.stub.statsPartition(req).get();
            return Response.success(response);
        }
        catch (Exception e) {
            return Response.failed(e);
        }
    }

    public Response<Void> deletePartition(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (!this.isSuccess().booleanValue()) {
            return Response.create(this.code, this.message, this.requestId, null);
        }
        try {
            Validator.verifyPartitionName(name);
            DeletePartitionRequest req = DeletePartitionRequest.newBuilder().setName(name).build();
            DeletePartitionResponse response = (DeletePartitionResponse)this.stub.deletePartition(req).get();
            return Response.success(response);
        }
        catch (Exception e) {
            return Response.failed(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public CollectionMeta getCollectionMeta() {
        return this.collectionMeta;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRequestId() {
        return this.requestId;
    }
}

