/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dashvector.models;

import com.aliyun.dashvector.models.SparseVector;
import com.aliyun.dashvector.models.Vector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class Doc {
    private String id;
    private Map<String, Object> fields;
    private float score;
    private Vector vector;
    private Map<String, Vector> vectors;
    private Map<Long, Float> sparseVector;
    private Map<String, SparseVector> sparseVectors;

    Doc(String id, Map<String, Object> fields, float score, Vector vector, Map<String, Vector> vectors, Map<Long, Float> sparseVector, Map<String, SparseVector> sparseVectors) {
        this.id = id;
        this.fields = fields;
        this.score = score;
        this.vector = vector;
        this.vectors = vectors;
        this.sparseVector = sparseVector;
        this.sparseVectors = sparseVectors;
    }

    public static DocBuilder builder() {
        return new DocBuilder();
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public float getScore() {
        return this.score;
    }

    public Vector getVector() {
        return this.vector;
    }

    public Map<String, Vector> getVectors() {
        return this.vectors;
    }

    public Map<Long, Float> getSparseVector() {
        return this.sparseVector;
    }

    public Map<String, SparseVector> getSparseVectors() {
        return this.sparseVectors;
    }

    public static class DocBuilder {
        private String id;
        private ArrayList<String> fields$key;
        private ArrayList<Object> fields$value;
        private float score;
        private Vector vector;
        private ArrayList<String> vectors$key;
        private ArrayList<Vector> vectors$value;
        private Map<Long, Float> sparseVector;
        private ArrayList<String> sparseVectors$key;
        private ArrayList<SparseVector> sparseVectors$value;

        DocBuilder() {
        }

        public DocBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DocBuilder field(String fieldKey, Object fieldValue) {
            if (this.fields$key == null) {
                this.fields$key = new ArrayList();
                this.fields$value = new ArrayList();
            }
            this.fields$key.add(fieldKey);
            this.fields$value.add(fieldValue);
            return this;
        }

        public DocBuilder fields(Map<? extends String, ? extends Object> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields$key == null) {
                this.fields$key = new ArrayList();
                this.fields$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : fields.entrySet()) {
                this.fields$key.add($lombokEntry.getKey());
                this.fields$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public DocBuilder clearFields() {
            if (this.fields$key != null) {
                this.fields$key.clear();
                this.fields$value.clear();
            }
            return this;
        }

        public DocBuilder score(float score) {
            this.score = score;
            return this;
        }

        public DocBuilder vector(Vector vector) {
            this.vector = vector;
            return this;
        }

        public DocBuilder vectors(String vectorsKey, Vector vectorsValue) {
            if (this.vectors$key == null) {
                this.vectors$key = new ArrayList();
                this.vectors$value = new ArrayList();
            }
            this.vectors$key.add(vectorsKey);
            this.vectors$value.add(vectorsValue);
            return this;
        }

        public DocBuilder vectors(Map<? extends String, ? extends Vector> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors cannot be null");
            }
            if (this.vectors$key == null) {
                this.vectors$key = new ArrayList();
                this.vectors$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Vector> $lombokEntry : vectors.entrySet()) {
                this.vectors$key.add($lombokEntry.getKey());
                this.vectors$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public DocBuilder clearVectors() {
            if (this.vectors$key != null) {
                this.vectors$key.clear();
                this.vectors$value.clear();
            }
            return this;
        }

        public DocBuilder sparseVector(Map<Long, Float> sparseVector) {
            this.sparseVector = sparseVector;
            return this;
        }

        public DocBuilder sparseVectors(String sparseVectorsKey, SparseVector sparseVectorsValue) {
            if (this.sparseVectors$key == null) {
                this.sparseVectors$key = new ArrayList();
                this.sparseVectors$value = new ArrayList();
            }
            this.sparseVectors$key.add(sparseVectorsKey);
            this.sparseVectors$value.add(sparseVectorsValue);
            return this;
        }

        public DocBuilder sparseVectors(Map<? extends String, ? extends SparseVector> sparseVectors) {
            if (sparseVectors == null) {
                throw new NullPointerException("sparseVectors cannot be null");
            }
            if (this.sparseVectors$key == null) {
                this.sparseVectors$key = new ArrayList();
                this.sparseVectors$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends SparseVector> $lombokEntry : sparseVectors.entrySet()) {
                this.sparseVectors$key.add($lombokEntry.getKey());
                this.sparseVectors$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public DocBuilder clearSparseVectors() {
            if (this.sparseVectors$key != null) {
                this.sparseVectors$key.clear();
                this.sparseVectors$value.clear();
            }
            return this;
        }

        public Doc build() {
            Map<String, SparseVector> sparseVectors;
            Map<String, Vector> vectors;
            Map<Object, Object> fields;
            switch (this.fields$key == null ? 0 : this.fields$key.size()) {
                case 0: {
                    fields = Collections.emptyMap();
                    break;
                }
                case 1: {
                    fields = Collections.singletonMap(this.fields$key.get(0), this.fields$value.get(0));
                    break;
                }
                default: {
                    fields = new LinkedHashMap(this.fields$key.size() < 0x40000000 ? 1 + this.fields$key.size() + (this.fields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.fields$key.size(); ++$i) {
                        fields.put(this.fields$key.get($i), this.fields$value.get($i));
                    }
                    fields = Collections.unmodifiableMap(fields);
                }
            }
            switch (this.vectors$key == null ? 0 : this.vectors$key.size()) {
                case 0: {
                    vectors = Collections.emptyMap();
                    break;
                }
                case 1: {
                    vectors = Collections.singletonMap(this.vectors$key.get(0), this.vectors$value.get(0));
                    break;
                }
                default: {
                    vectors = new LinkedHashMap(this.vectors$key.size() < 0x40000000 ? 1 + this.vectors$key.size() + (this.vectors$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.vectors$key.size(); ++$i) {
                        vectors.put(this.vectors$key.get($i), this.vectors$value.get($i));
                    }
                    vectors = Collections.unmodifiableMap(vectors);
                }
            }
            switch (this.sparseVectors$key == null ? 0 : this.sparseVectors$key.size()) {
                case 0: {
                    sparseVectors = Collections.emptyMap();
                    break;
                }
                case 1: {
                    sparseVectors = Collections.singletonMap(this.sparseVectors$key.get(0), this.sparseVectors$value.get(0));
                    break;
                }
                default: {
                    sparseVectors = new LinkedHashMap(this.sparseVectors$key.size() < 0x40000000 ? 1 + this.sparseVectors$key.size() + (this.sparseVectors$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.sparseVectors$key.size(); ++$i) {
                        sparseVectors.put(this.sparseVectors$key.get($i), this.sparseVectors$value.get($i));
                    }
                    sparseVectors = Collections.unmodifiableMap(sparseVectors);
                }
            }
            return new Doc(this.id, fields, this.score, this.vector, vectors, this.sparseVector, sparseVectors);
        }

        public String toString() {
            return "Doc.DocBuilder(id=" + this.id + ", fields$key=" + this.fields$key + ", fields$value=" + this.fields$value + ", score=" + this.score + ", vector=" + this.vector + ", vectors$key=" + this.vectors$key + ", vectors$value=" + this.vectors$value + ", sparseVector=" + this.sparseVector + ", sparseVectors$key=" + this.sparseVectors$key + ", sparseVectors$value=" + this.sparseVectors$value + ")";
        }
    }
}

